/*
 * Decompiled with CFR 0.152.
 */
package com.rojoma.json.io;

import com.rojoma.json.io.JsonToken;
import com.rojoma.json.io.JsonTokenGenerator;
import com.rojoma.json.io.JsonTokenGeneratorImpl;
import com.rojoma.json.io.JsonTokenGeneratorImpl$IdentifierReader$;
import com.rojoma.json.io.JsonTokenGeneratorImpl$NumberReader$;
import com.rojoma.json.io.JsonTokenGeneratorImpl$StringReader$;
import com.rojoma.json.io.Position$;
import com.rojoma.json.io.SimpleJsonToken;
import com.rojoma.json.io.TokenCloseBrace;
import com.rojoma.json.io.TokenCloseBracket;
import com.rojoma.json.io.TokenColon;
import com.rojoma.json.io.TokenComma;
import com.rojoma.json.io.TokenOpenBrace;
import com.rojoma.json.io.TokenOpenBracket;
import scala.MatchError;
import scala.ScalaObject;
import scala.runtime.BoxesRunTime;

public final class JsonTokenGeneratorImpl$
implements ScalaObject {
    public static final JsonTokenGeneratorImpl$ MODULE$;

    static {
        new JsonTokenGeneratorImpl$();
    }

    public JsonTokenGenerator.Token token(JsonToken token, JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        return new JsonTokenGenerator.Token(token, new JsonTokenGeneratorImpl.WaitingForToken(input.nextCharRow(), input.nextCharCol()), input.freeze());
    }

    public JsonTokenGenerator.Result readToken(JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        JsonTokenGenerator.Result result;
        char c = input.peek();
        switch (c) {
            default: {
                char c2 = c;
                if (JsonTokenGeneratorImpl$NumberReader$.MODULE$.isDigit(c2)) {
                    result = JsonTokenGeneratorImpl$NumberReader$.MODULE$.readNumber(input);
                    break;
                }
                if (Character.isUnicodeIdentifierStart(c2)) {
                    result = JsonTokenGeneratorImpl$IdentifierReader$.MODULE$.readIdentifier(input);
                    break;
                }
                result = new JsonTokenGenerator.UnexpectedCharacter(c2, "start of datum", Position$.MODULE$.apply(input.nextCharRow(), input.nextCharCol()));
                break;
            }
            case '-': {
                result = JsonTokenGeneratorImpl$NumberReader$.MODULE$.readNumber(input);
                break;
            }
            case '\"': 
            case '\'': {
                result = JsonTokenGeneratorImpl$StringReader$.MODULE$.readString(input);
                break;
            }
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                result = this.readSingleCharToken(input);
            }
        }
        return result;
    }

    public JsonTokenGenerator.Token readSingleCharToken(JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        SimpleJsonToken simpleJsonToken;
        int tokenRow = input.nextCharRow();
        int tokenCol = input.nextCharCol();
        char c = input.next();
        switch (c) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
            }
            case ':': {
                simpleJsonToken = new TokenColon();
                break;
            }
            case '{': {
                simpleJsonToken = new TokenOpenBrace();
                break;
            }
            case '[': {
                simpleJsonToken = new TokenOpenBracket();
                break;
            }
            case ',': {
                simpleJsonToken = new TokenComma();
                break;
            }
            case ']': {
                simpleJsonToken = new TokenCloseBracket();
                break;
            }
            case '}': {
                simpleJsonToken = new TokenCloseBrace();
            }
        }
        SimpleJsonToken positionedToken = simpleJsonToken;
        positionedToken.row_$eq(tokenRow);
        positionedToken.column_$eq(tokenCol);
        return this.token(positionedToken, input);
    }

    private JsonTokenGeneratorImpl$() {
        MODULE$ = this;
    }
}

