/*
 * Decompiled with CFR 0.152.
 */
package com.rojoma.json.io;

import com.rojoma.json.io.JsonTokenGenerator;
import com.rojoma.json.io.JsonTokenGeneratorImpl;
import com.rojoma.json.io.JsonTokenGeneratorImpl$;
import com.rojoma.json.io.Position$;
import com.rojoma.json.io.TokenNumber;
import java.math.MathContext;
import scala.MatchError;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonTokenGeneratorImpl$NumberReader$
extends JsonTokenGeneratorImpl.ReaderBase
implements ScalaObject {
    public static final JsonTokenGeneratorImpl$NumberReader$ MODULE$;
    private final int ReadingSign;
    private final int ReadingFirstWholePartDigit;
    private final int ReadingWholePart;
    private final int ReadingFirstFracPartDigit;
    private final int ReadingFracPart;
    private final int ReadingExponentSign;
    private final int ReadingFirstExponentDigit;
    private final int ReadingExponent;
    private final int Done;

    static {
        new JsonTokenGeneratorImpl$NumberReader$();
    }

    public final int ReadingSign() {
        return 0;
    }

    public final int ReadingFirstWholePartDigit() {
        return 1;
    }

    public final int ReadingWholePart() {
        return 2;
    }

    public final int ReadingFirstFracPartDigit() {
        return 3;
    }

    public final int ReadingFracPart() {
        return 4;
    }

    public final int ReadingExponentSign() {
        return 5;
    }

    public final int ReadingFirstExponentDigit() {
        return 6;
    }

    public final int ReadingExponent() {
        return 7;
    }

    public final int Done() {
        return 8;
    }

    public JsonTokenGenerator.Result readNumber(JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        return this.continueReadingNumber(0, (List<String>)Nil$.MODULE$, input.nextCharRow(), input.nextCharCol(), input);
    }

    public JsonTokenGenerator.EndResult eofInNumber(int state, List<String> chunks, int startRow, int startCol, int row, int col) {
        JsonTokenGenerator.EndResult endResult;
        int n = state;
        switch (n) {
            default: {
                endResult = new JsonTokenGenerator.FinalToken(this.toNumberToken(chunks.reverse().mkString(), startRow, startCol), Position$.MODULE$.apply(row, col));
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                endResult = new JsonTokenGenerator.UnexpectedEndOfInput("number", Position$.MODULE$.apply(row, col));
            }
        }
        return endResult;
    }

    /*
     * Loose catch block
     */
    public JsonTokenGenerator.Result continueReadingNumber(int initialState, List<String> chunks, int startRow, int startCol, JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        Throwable throwable422;
        block19: {
            JsonTokenGenerator.Result exceptionResult4;
            block18: {
                exceptionResult4 = null;
                try {
                    int state = initialState;
                    StringBuilder sb = new StringBuilder();
                    while (true) {
                        int n;
                        if (input.atEnd()) {
                            exceptionResult4 = new JsonTokenGenerator.More(new JsonTokenGeneratorImpl.ReadingNumber(state, this.addChunk(sb, chunks), startRow, startCol, input.nextCharRow(), input.nextCharCol()));
                            break block18;
                        }
                        int n2 = state;
                        switch (n2) {
                            default: {
                                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                            }
                            case 4: {
                                n = this.readFracPart(sb, input, false);
                                break;
                            }
                            case 8: {
                                String number = this.mergeChunks(sb, chunks);
                                boolean exceptionResult5 = false;
                                return JsonTokenGeneratorImpl$.MODULE$.token(this.toNumberToken(number, startRow, startCol), input);
                            }
                            case 3: {
                                n = this.readFracPart(sb, input, true);
                                break;
                            }
                            case 7: {
                                n = this.readExponent(sb, input, false);
                                break;
                            }
                            case 2: {
                                n = this.readWholePart(sb, input, false);
                                break;
                            }
                            case 6: {
                                n = this.readExponent(sb, input, true);
                                break;
                            }
                            case 1: {
                                n = this.readWholePart(sb, input, true);
                                break;
                            }
                            case 5: {
                                n = this.readExponentSign(sb, input);
                                break;
                            }
                            case 0: {
                                n = this.readSign(sb, input);
                            }
                        }
                        state = n;
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        if (throwable3 instanceof JsonTokenGeneratorImpl.NumberReader.NumberOutOfRangeException) {
                            JsonTokenGeneratorImpl.NumberReader.NumberOutOfRangeException numberOutOfRangeException = (JsonTokenGeneratorImpl.NumberReader.NumberOutOfRangeException)throwable3;
                            return new JsonTokenGenerator.NumberOutOfRange(numberOutOfRangeException.number(), Position$.MODULE$.apply(numberOutOfRangeException.row(), numberOutOfRangeException.col()));
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable422) {
                    Throwable throwable5 = throwable422;
                    if (!(throwable5 instanceof JsonTokenGeneratorImpl.UnexpectedCharacterException)) break block19;
                    JsonTokenGeneratorImpl.UnexpectedCharacterException unexpectedCharacterException = (JsonTokenGeneratorImpl.UnexpectedCharacterException)throwable5;
                    exceptionResult4 = new JsonTokenGenerator.UnexpectedCharacter(unexpectedCharacterException.c(), unexpectedCharacterException.expected(), Position$.MODULE$.apply(unexpectedCharacterException.row(), unexpectedCharacterException.col()));
                }
            }
            return exceptionResult4;
        }
        throw throwable422;
    }

    public TokenNumber toNumberToken(String text, int startRow, int startCol) {
        TokenNumber exceptionResult6 = null;
        try {
            TokenNumber number = new TokenNumber(package$.MODULE$.BigDecimal().apply(text, MathContext.UNLIMITED));
            number.row_$eq(startRow);
            number.column_$eq(startCol);
            exceptionResult6 = number;
            return exceptionResult6;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonTokenGeneratorImpl.NumberReader.NumberOutOfRangeException(text, startRow, startCol);
        }
    }

    public int readSign(StringBuilder sb, JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        Object object = input.peek() == '-' ? sb.append(input.next()) : BoxedUnit.UNIT;
        return input.atEnd() ? 1 : this.readWholePart(sb, input, true);
    }

    public int readWholePart(StringBuilder sb, JsonTokenGeneratorImpl.PositionedCharExtractor input, boolean firstDigit) {
        int n;
        this.readDigits(sb, input, firstDigit);
        if (input.atEnd()) {
            n = 2;
        } else {
            char c = input.peek();
            switch (c) {
                default: {
                    n = 8;
                    break;
                }
                case '.': {
                    sb.append(input.next());
                    if (input.atEnd()) {
                        n = 3;
                        break;
                    }
                    n = this.readFracPart(sb, input, true);
                    break;
                }
                case 'E': 
                case 'e': {
                    n = this.readE(sb, input);
                }
            }
        }
        return n;
    }

    public void readDigits(StringBuilder sb, JsonTokenGeneratorImpl.PositionedCharExtractor input, boolean atLeastOne) {
        if (atLeastOne) {
            this.readDigit(sb, input);
        }
        while (!input.atEnd() && this.isDigit(input.peek())) {
            this.readDigit(sb, input);
        }
    }

    public void readDigit(StringBuilder sb, JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        int row = input.nextCharRow();
        int col = input.nextCharRow();
        char c = input.next();
        if (this.isDigit(c)) {
            sb.append(c);
            return;
        }
        throw new JsonTokenGeneratorImpl.UnexpectedCharacterException(c, "digit", row, col);
    }

    public int readFracPart(StringBuilder sb, JsonTokenGeneratorImpl.PositionedCharExtractor input, boolean firstDigit) {
        int n;
        this.readDigits(sb, input, firstDigit);
        if (input.atEnd()) {
            n = 4;
        } else {
            char c = input.peek();
            switch (c) {
                default: {
                    n = 8;
                    break;
                }
                case 'E': 
                case 'e': {
                    n = this.readE(sb, input);
                }
            }
        }
        return n;
    }

    public int readE(StringBuilder sb, JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        sb.append(input.next());
        return input.atEnd() ? 5 : this.readExponentSign(sb, input);
    }

    public int readExponentSign(StringBuilder sb, JsonTokenGeneratorImpl.PositionedCharExtractor input) {
        Object object = input.peek() == '+' || input.peek() == '-' ? sb.append(input.next()) : BoxedUnit.UNIT;
        return input.atEnd() ? 6 : this.readExponent(sb, input, true);
    }

    public int readExponent(StringBuilder sb, JsonTokenGeneratorImpl.PositionedCharExtractor input, boolean firstDigit) {
        this.readDigits(sb, input, firstDigit);
        return input.atEnd() ? 7 : 8;
    }

    public JsonTokenGeneratorImpl$NumberReader$() {
        MODULE$ = this;
    }
}

