/*
 * Decompiled with CFR 0.152.
 */
package com.rojoma.json.io;

import com.rojoma.json.io.JsonLexerEOF;
import com.rojoma.json.io.JsonNumberOutOfRange;
import com.rojoma.json.io.JsonToken;
import com.rojoma.json.io.JsonUnexpectedCharacter;
import com.rojoma.json.io.NoSuchTokenException;
import com.rojoma.json.io.Position$;
import com.rojoma.json.io.TokenCloseBrace;
import com.rojoma.json.io.TokenCloseBracket;
import com.rojoma.json.io.TokenColon;
import com.rojoma.json.io.TokenComma;
import com.rojoma.json.io.TokenIdentifier;
import com.rojoma.json.io.TokenNumber;
import com.rojoma.json.io.TokenOpenBrace;
import com.rojoma.json.io.TokenOpenBracket;
import com.rojoma.json.io.TokenString;
import java.io.Reader;
import java.math.MathContext;
import scala.ScalaObject;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001-\u0011\u0011CS:p]R{7.\u001a8Ji\u0016\u0014\u0018\r^8s\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0005UN|gN\u0003\u0002\b\u0011\u00051!o\u001c6p[\u0006T\u0011!C\u0001\u0004G>l7\u0001A\n\u0005\u00011!b\u0005\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\r)rD\t\b\u0003-qq!a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001f\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aG\u0005\u0003A\u0005\u0012\u0001CQ;gM\u0016\u0014X\rZ%uKJ\fGo\u001c:\u000b\u0005uq\u0002CA\u0012%\u001b\u0005\u0011\u0011BA\u0013\u0003\u0005%Q5o\u001c8U_.,g\u000e\u0005\u0002(Q5\ta$\u0003\u0002*=\tY1kY1mC>\u0013'.Z2u\u0011!Y\u0003A!A!\u0002\u0013a\u0013A\u0002:fC\u0012,'\u000f\u0005\u0002._5\taF\u0003\u0002\u0004!%\u0011\u0001G\f\u0002\u0007%\u0016\fG-\u001a:\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\t!T\u0007\u0005\u0002$\u0001!)1&\ra\u0001Y!9q\u0007\u0001a\u0001\n\u0013A\u0014\u0001C5t!\u0016,7.\u001a3\u0016\u0003e\u0002\"a\n\u001e\n\u0005mr\"a\u0002\"p_2,\u0017M\u001c\u0005\b{\u0001\u0001\r\u0011\"\u0003?\u00031I7\u000fU3fW\u0016$w\fJ3r)\ty$\t\u0005\u0002(\u0001&\u0011\u0011I\b\u0002\u0005+:LG\u000fC\u0004Dy\u0005\u0005\t\u0019A\u001d\u0002\u0007a$\u0013\u0007\u0003\u0004F\u0001\u0001\u0006K!O\u0001\nSN\u0004V-Z6fI\u0002Bqa\u0012\u0001A\u0002\u0013%\u0001*\u0001\u0004qK\u0016\\W\rZ\u000b\u0002\u0013B\u0011qES\u0005\u0003\u0017z\u0011Aa\u00115be\"9Q\n\u0001a\u0001\n\u0013q\u0015A\u00039fK.,Gm\u0018\u0013fcR\u0011qh\u0014\u0005\b\u00072\u000b\t\u00111\u0001J\u0011\u0019\t\u0006\u0001)Q\u0005\u0013\u00069\u0001/Z3lK\u0012\u0004\u0003bB*\u0001\u0001\u0004%I\u0001V\u0001\n]\u0016DH\u000fV8lK:,\u0012A\t\u0005\b-\u0002\u0001\r\u0011\"\u0003X\u00035qW\r\u001f;U_.,gn\u0018\u0013fcR\u0011q\b\u0017\u0005\b\u0007V\u000b\t\u00111\u0001#\u0011\u0019Q\u0006\u0001)Q\u0005E\u0005Qa.\u001a=u)>\\WM\u001c\u0011\t\u000fq\u0003\u0001\u0019!C\u0005;\u0006Ya.\u001a=u\u0007\"\f'OU8x+\u0005q\u0006CA\u0014`\u0013\t\u0001gDA\u0002J]RDqA\u0019\u0001A\u0002\u0013%1-A\boKb$8\t[1s%><x\fJ3r)\tyD\rC\u0004DC\u0006\u0005\t\u0019\u00010\t\r\u0019\u0004\u0001\u0015)\u0003_\u00031qW\r\u001f;DQ\u0006\u0014(k\\<!\u0011\u001dA\u0007\u00011A\u0005\nu\u000b1B\\3yi\u000eC\u0017M]\"pY\"9!\u000e\u0001a\u0001\n\u0013Y\u0017a\u00048fqR\u001c\u0005.\u0019:D_2|F%Z9\u0015\u0005}b\u0007bB\"j\u0003\u0003\u0005\rA\u0018\u0005\u0007]\u0002\u0001\u000b\u0015\u00020\u0002\u00199,\u0007\u0010^\"iCJ\u001cu\u000e\u001c\u0011\t\u000bA\u0004A\u0011B9\u0002\u00151,\u00070\u001a:FeJ|'\u000fF\u0004sk^\f\t!!\u0002\u0011\u0005\u001d\u001a\u0018B\u0001;\u001f\u0005\u001dqu\u000e\u001e5j]\u001eDQA^8A\u0002%\u000bAB]3dK&4X\rZ\"iCJDQ\u0001_8A\u0002e\f\u0001\"\u001a=qK\u000e$X\r\u001a\t\u0003uvt!aJ>\n\u0005qt\u0012A\u0002)sK\u0012,g-\u0003\u0002\u007f\u007f\n11\u000b\u001e:j]\u001eT!\u0001 \u0010\t\r\u0005\rq\u000e1\u0001_\u0003\r\u0011xn\u001e\u0005\u0007\u0003\u000fy\u0007\u0019\u00010\u0002\u0007\r|G\u000eC\u0004\u0002\f\u0001!I!!\u0004\u0002\u00119,\u0007\u0010^\"iCJ$\u0012!\u0013\u0005\b\u0003#\u0001A\u0011BA\u0007\u0003!\u0001X-Z6DQ\u0006\u0014\bbBA\u000b\u0001\u0011%\u0011qC\u0001\u0006CR,uJ\u0012\u000b\u0002s!9\u00111\u0004\u0001\u0005\n\u0005u\u0011aD:lSB$v.\u00128e\u001f\u001ad\u0015N\\3\u0015\u0003}Bq!!\t\u0001\t\u0013\ti\"\u0001\ttW&\u0004(\t\\8dW\u000e{W.\\3oi\"9\u0011Q\u0005\u0001\u0005\n\u0005u\u0011aC:lSB\u001cu.\\7f]RDq!!\u000b\u0001\t\u0013\ti\"\u0001\btW&\u0004x\u000b[5uKN\u0004\u0018mY3)\t\u0005\u001d\u0012Q\u0006\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u0005E\"a\u0002;bS2\u0014Xm\u0019\u0005\u0007\u0003w\u0001A\u0011\u0001\u001d\u0002\u000f!\f7OT3yi\"1\u0011q\b\u0001\u0005\u0002Q\u000bA\u0001[3bI\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013\u0001\u00028fqR$\u0012A\t\u0005\b\u0003\u0013\u0002A\u0011BA\u000f\u0003\u001d\tGM^1oG\u0016Dq!!\u0014\u0001\t\u0013\ty%A\u0004jg\u0012Kw-\u001b;\u0015\u0007e\n\t\u0006C\u0004\u0002T\u0005-\u0003\u0019A%\u0002\u0003\rDq!a\u0016\u0001\t\u0013\ti!A\u0005sK\u0006$G)[4ji\"9\u00111\f\u0001\u0005\n\u0005u\u0013A\u0003:fC\u0012tU/\u001c2feR\u0011\u0011q\f\t\u0004G\u0005\u0005\u0014bAA2\u0005\tYAk\\6f]:+XNY3s\u0011\u001d\t9\u0007\u0001C\u0005\u0003S\naB]3bI&#WM\u001c;jM&,'\u000f\u0006\u0002\u0002lA\u00191%!\u001c\n\u0007\u0005=$AA\bU_.,g.\u00133f]RLg-[3s\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\n!B]3bIN#(/\u001b8h)\t\t9\bE\u0002$\u0003sJ1!a\u001f\u0003\u0005-!vn[3o'R\u0014\u0018N\\4\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\u0006q\"/Z1e!>$XM\u001c;jC2\u001cVO\u001d:pO\u0006$X\rU1je&sGo\u001c\u000b\b\u007f\u0005\r\u0015QRAH\u0011!\t))! A\u0002\u0005\u001d\u0015AA:c!\r)\u0012\u0011R\u0005\u0004\u0003\u0017\u000b#!D*ue&twMQ;jY\u0012,'\u000fC\u0004\u0002T\u0005u\u0004\u0019A%\t\u000f\u0005E\u0015Q\u0010a\u0001\u0013\u0006YQM\u001c3PMN#(/\u001b8hQ\u0011\ti(!\f\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u000e\u0005A!/Z1e\u0007\"\f'\u000fC\u0004\u0002\u001c\u0002!I!!\u0004\u0002)I,\u0017\rZ#tG\u0006\u0004X\rZ\"iCJ\f7\r^3s\u0011\u001d\ty\n\u0001C\u0005\u0003\u001b\tAC]3bIVs\u0017nY8eK\u000eC\u0017M]1di\u0016\u0014\bbBAR\u0001\u0011%\u0011QU\u0001\re\u0016\fG\rS3y\t&<\u0017\u000e\u001e\u000b\u0002=\u0002")
public class JsonTokenIterator
implements BufferedIterator<JsonToken>,
ScalaObject {
    private final Reader reader;
    private boolean isPeeked;
    private char peeked;
    private JsonToken nextToken;
    private int nextCharRow;
    private int nextCharCol;

    private boolean isPeeked() {
        return this.isPeeked;
    }

    private void isPeeked_$eq(boolean bl) {
        this.isPeeked = bl;
    }

    private char peeked() {
        return this.peeked;
    }

    private void peeked_$eq(char c) {
        this.peeked = c;
    }

    private JsonToken nextToken() {
        return this.nextToken;
    }

    private void nextToken_$eq(JsonToken jsonToken) {
        this.nextToken = jsonToken;
    }

    private int nextCharRow() {
        return this.nextCharRow;
    }

    private void nextCharRow_$eq(int n) {
        this.nextCharRow = n;
    }

    private int nextCharCol() {
        return this.nextCharCol;
    }

    private void nextCharCol_$eq(int n) {
        this.nextCharCol = n;
    }

    private Nothing$ lexerError(char receivedChar, String expected, int row, int col) {
        throw new JsonUnexpectedCharacter(receivedChar, expected, Position$.MODULE$.apply(row, col));
    }

    private char nextChar() {
        this.peekChar();
        this.isPeeked_$eq(false);
        if (this.peeked() == '\n') {
            this.nextCharRow_$eq(this.nextCharRow() + 1);
            this.nextCharCol_$eq(1);
        } else {
            this.nextCharCol_$eq(this.nextCharCol() + 1);
        }
        return this.peeked();
    }

    private char peekChar() {
        if (!this.isPeeked()) {
            int newChar = this.reader.read();
            if (newChar == -1) {
                throw new JsonLexerEOF(Position$.MODULE$.apply(this.nextCharRow(), this.nextCharCol()));
            }
            this.peeked_$eq((char)newChar);
            this.isPeeked_$eq(true);
        }
        return this.peeked();
    }

    private boolean atEOF() {
        if (this.isPeeked()) {
            return false;
        }
        int newChar = this.reader.read();
        if (newChar == -1) {
            return true;
        }
        this.peeked_$eq((char)newChar);
        this.isPeeked_$eq(true);
        return false;
    }

    private void skipToEndOfLine() {
        while (!this.atEOF() && this.peekChar() != '\n') {
            this.nextChar();
        }
    }

    private void skipBlockComment() {
        char last = this.nextChar();
        while (last != '*' || this.peekChar() != '/') {
            last = this.nextChar();
        }
        this.nextChar();
    }

    private void skipComment() {
        this.nextChar();
        int row = this.nextCharRow();
        int col = this.nextCharCol();
        char c = this.nextChar();
        switch (c) {
            default: {
                throw this.lexerError(c, "/ or *", row, col);
            }
            case '/': {
                this.skipToEndOfLine();
                break;
            }
            case '*': {
                this.skipBlockComment();
            }
        }
    }

    private void skipWhitespace() {
        while (true) {
            if (!this.atEOF() && Character.isWhitespace(this.peekChar())) {
                this.nextChar();
                continue;
            }
            if (this.atEOF() || this.peekChar() != '/') break;
            this.skipComment();
        }
    }

    public boolean hasNext() {
        if (this.nextToken() == null) {
            this.advance();
        }
        return this.nextToken() != null;
    }

    public JsonToken head() {
        if (this.hasNext()) {
            return this.nextToken();
        }
        throw new NoSuchTokenException(Position$.MODULE$.apply(this.nextCharRow(), this.nextCharCol()));
    }

    /*
     * WARNING - void declaration
     */
    public JsonToken next() {
        void var1_1;
        JsonToken result = this.head();
        this.nextToken_$eq(null);
        return var1_1;
    }

    private void advance() {
        JsonToken jsonToken;
        this.skipWhitespace();
        if (this.atEOF()) {
            this.nextToken_$eq(null);
            return;
        }
        int tokenStartRow = this.nextCharRow();
        int tokenStartCol = this.nextCharCol();
        char c = this.peekChar();
        switch (c) {
            default: {
                char c2 = c;
                if (this.isDigit(c2)) {
                    jsonToken = this.readNumber();
                    break;
                }
                if (Character.isUnicodeIdentifierStart(c2)) {
                    jsonToken = this.readIdentifier();
                    break;
                }
                throw this.lexerError(c2, "start of datum", this.nextCharRow(), this.nextCharCol());
            }
            case ':': {
                this.nextChar();
                jsonToken = new TokenColon();
                break;
            }
            case '{': {
                this.nextChar();
                jsonToken = new TokenOpenBrace();
                break;
            }
            case '[': {
                this.nextChar();
                jsonToken = new TokenOpenBracket();
                break;
            }
            case ',': {
                this.nextChar();
                jsonToken = new TokenComma();
                break;
            }
            case '-': {
                jsonToken = this.readNumber();
                break;
            }
            case '\"': 
            case '\'': {
                jsonToken = this.readString();
                break;
            }
            case ']': {
                this.nextChar();
                jsonToken = new TokenCloseBracket();
                break;
            }
            case '}': {
                this.nextChar();
                jsonToken = new TokenCloseBrace();
            }
        }
        JsonToken token = jsonToken;
        token.row_$eq(tokenStartRow);
        token.column_$eq(tokenStartCol);
        this.nextToken_$eq(token);
    }

    private boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private char readDigit() {
        int row = this.nextCharRow();
        int col = this.nextCharCol();
        char c = this.nextChar();
        if (this.isDigit(c)) {
            return c;
        }
        throw this.lexerError(c, "digit", row, col);
    }

    private TokenNumber readNumber() {
        boolean hasExponent;
        boolean hasFrac;
        StringBuilder sb = new StringBuilder();
        int startRow = this.nextCharRow();
        int startCol = this.nextCharCol();
        Object object = this.peekChar() == '-' ? sb.$plus$eq(this.nextChar()) : BoxedUnit.UNIT;
        do {
            sb.$plus$eq(this.readDigit());
        } while (!this.atEOF() && this.isDigit(this.peekChar()));
        boolean bl = hasFrac = !this.atEOF() && this.peekChar() == '.';
        if (hasFrac) {
            sb.$plus$eq(this.nextChar());
            do {
                sb.$plus$eq(this.readDigit());
            } while (!this.atEOF() && this.isDigit(this.peekChar()));
        }
        boolean bl2 = hasExponent = !this.atEOF() && (this.peekChar() == 'e' || this.peekChar() == 'E');
        if (hasExponent) {
            sb.$plus$eq(this.nextChar());
            Object object2 = this.peekChar() == '-' ? sb.$plus$eq(this.nextChar()) : (this.peekChar() == '+' ? BoxesRunTime.boxToCharacter((char)this.nextChar()) : BoxedUnit.UNIT);
            do {
                sb.$plus$eq(this.readDigit());
            } while (!this.atEOF() && this.isDigit(this.peekChar()));
        }
        String n = sb.toString();
        TokenNumber exceptionResult1 = null;
        try {
            exceptionResult1 = new TokenNumber(package$.MODULE$.BigDecimal().apply(n, MathContext.UNLIMITED));
            return exceptionResult1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonNumberOutOfRange(n, Position$.MODULE$.apply(startRow, startCol));
        }
    }

    private TokenIdentifier readIdentifier() {
        StringBuilder sb = new StringBuilder();
        sb.$plus$eq(this.nextChar());
        while (!this.atEOF() && Character.isUnicodeIdentifierPart(this.peekChar())) {
            sb.$plus$eq(this.nextChar());
        }
        return new TokenIdentifier(sb.toString());
    }

    private TokenString readString() {
        StringBuilder sb = new StringBuilder();
        char Boundary = this.nextChar();
        while (this.peekChar() != Boundary) {
            this.readPotentialSurrogatePairInto(sb, this.readChar(), Boundary);
        }
        this.nextChar();
        return new TokenString(sb.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readPotentialSurrogatePairInto(StringBuilder sb, char c, char endOfString) {
        while (c >= '\ud800' && c <= '\udfff') {
            char badChar = (char)65533;
            if (!Character.isHighSurrogate(c)) {
                sb.$plus$eq(badChar);
                return;
            }
            if (this.peekChar() == endOfString) {
                sb.$plus$eq(badChar);
                return;
            }
            char potentialSecondHalf = this.readChar();
            if (Character.isLowSurrogate(potentialSecondHalf)) {
                sb.$plus$eq(c);
                sb.$plus$eq(potentialSecondHalf);
                return;
            }
            sb.$plus$eq(badChar);
            c = potentialSecondHalf;
        }
        sb.$plus$eq(c);
    }

    private char readChar() {
        char c = this.nextChar();
        return c == '\\' ? this.readEscapedCharacter() : c;
    }

    private char readEscapedCharacter() {
        char c;
        int row = this.nextCharRow();
        int col = this.nextCharCol();
        char c2 = this.nextChar();
        switch (c2) {
            default: {
                throw this.lexerError(c2, "string escape character", row, col);
            }
            case '/': {
                c = '/';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case 'b': {
                c = '\b';
                break;
            }
            case '\'': {
                c = '\'';
                break;
            }
            case '\"': {
                c = '\"';
                break;
            }
            case '\\': {
                c = '\\';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case 'u': {
                c = this.readUnicodeCharacter();
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'n': {
                c = '\n';
            }
        }
        return c;
    }

    private char readUnicodeCharacter() {
        int h1 = this.readHexDigit();
        int h2 = this.readHexDigit();
        int h3 = this.readHexDigit();
        int h4 = this.readHexDigit();
        return (char)(h1 << 12 | h2 << 8 | h3 << 4 | h4);
    }

    private int readHexDigit() {
        char c;
        int col;
        int row;
        block5: {
            int n;
            block3: {
                block4: {
                    block2: {
                        row = this.nextCharRow();
                        col = this.nextCharCol();
                        c = this.nextChar();
                        char c2 = c;
                        if (!this.gd1$1(c2)) break block2;
                        n = c2 - 48;
                        break block3;
                    }
                    char c3 = c;
                    if (!this.gd2$1(c3)) break block4;
                    n = 10 + c3 - 97;
                    break block3;
                }
                char c4 = c;
                if (!this.gd3$1(c4)) break block5;
                n = 10 + c4 - 65;
            }
            return n;
        }
        throw this.lexerError(c, "hex digit", row, col);
    }

    private final boolean gd1$1(char c) {
        return this.isDigit(c);
    }

    private final boolean gd2$1(char c) {
        return 'a' <= c && c <= 'f';
    }

    private final boolean gd3$1(char c) {
        return 'A' <= c && c <= 'F';
    }

    public JsonTokenIterator(Reader reader) {
        this.reader = reader;
        GenTraversableOnce.class.$init$((GenTraversableOnce)this);
        TraversableOnce.class.$init$((TraversableOnce)this);
        Iterator.class.$init$((Iterator)this);
        BufferedIterator.class.$init$((BufferedIterator)this);
        this.isPeeked = false;
        this.nextToken = null;
        this.nextCharRow = 1;
        this.nextCharCol = 1;
    }
}

