package com.rojoma
package simplearm
package object util {
def managed[A: Resource](x: =>A): SimpleArm[A] = new UntransformedSimpleArm(x)

def using[A, RR](r1: =>A)(f: (A) => RR)(implicit ev1: Resource[A]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    f(fr1)
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, RR](r1: =>A, r2: =>B)(f: (A, B) => RR)(implicit ev1: Resource[A], ev2: Resource[B]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      f(fr1, fr2)
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, RR](r1: =>A, r2: =>B, r3: =>C)(f: (A, B, C) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        f(fr1, fr2, fr3)
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D)(f: (A, B, C, D) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          f(fr1, fr2, fr3, fr4)
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E)(f: (A, B, C, D, E) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            f(fr1, fr2, fr3, fr4, fr5)
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F)(f: (A, B, C, D, E, F) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              f(fr1, fr2, fr3, fr4, fr5, fr6)
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G)(f: (A, B, C, D, E, F, G) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                f(fr1, fr2, fr3, fr4, fr5, fr6, fr7)
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H)(f: (A, B, C, D, E, F, G, H) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8)
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I)(f: (A, B, C, D, E, F, G, H, I) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9)
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J)(f: (A, B, C, D, E, F, G, H, I, J) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10)
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K)(f: (A, B, C, D, E, F, G, H, I, J, K) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11)
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L)(f: (A, B, C, D, E, F, G, H, I, J, K, L) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12)
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13)
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, N, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M, r14: =>N)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M, N) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M], ev14: Resource[N]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            val fr14 = r14
                            ev14.open(fr14)
                            val res14 = try {
                              f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13, fr14)
                            } catch {
                              case e: Throwable =>
                                try {
                                  ev14.closeAbnormally(fr14, e)
                                } catch { case secondaryException: Exception =>
                                  ev14.handleSecondaryException(e, secondaryException)
                                }
                                throw e
                            }
                            ev14.close(fr14)
                            res14
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M, r14: =>N, r15: =>O)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M], ev14: Resource[N], ev15: Resource[O]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            val fr14 = r14
                            ev14.open(fr14)
                            val res14 = try {
                              val fr15 = r15
                              ev15.open(fr15)
                              val res15 = try {
                                f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13, fr14, fr15)
                              } catch {
                                case e: Throwable =>
                                  try {
                                    ev15.closeAbnormally(fr15, e)
                                  } catch { case secondaryException: Exception =>
                                    ev15.handleSecondaryException(e, secondaryException)
                                  }
                                  throw e
                              }
                              ev15.close(fr15)
                              res15
                            } catch {
                              case e: Throwable =>
                                try {
                                  ev14.closeAbnormally(fr14, e)
                                } catch { case secondaryException: Exception =>
                                  ev14.handleSecondaryException(e, secondaryException)
                                }
                                throw e
                            }
                            ev14.close(fr14)
                            res14
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M, r14: =>N, r15: =>O, r16: =>P)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M], ev14: Resource[N], ev15: Resource[O], ev16: Resource[P]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            val fr14 = r14
                            ev14.open(fr14)
                            val res14 = try {
                              val fr15 = r15
                              ev15.open(fr15)
                              val res15 = try {
                                val fr16 = r16
                                ev16.open(fr16)
                                val res16 = try {
                                  f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13, fr14, fr15, fr16)
                                } catch {
                                  case e: Throwable =>
                                    try {
                                      ev16.closeAbnormally(fr16, e)
                                    } catch { case secondaryException: Exception =>
                                      ev16.handleSecondaryException(e, secondaryException)
                                    }
                                    throw e
                                }
                                ev16.close(fr16)
                                res16
                              } catch {
                                case e: Throwable =>
                                  try {
                                    ev15.closeAbnormally(fr15, e)
                                  } catch { case secondaryException: Exception =>
                                    ev15.handleSecondaryException(e, secondaryException)
                                  }
                                  throw e
                              }
                              ev15.close(fr15)
                              res15
                            } catch {
                              case e: Throwable =>
                                try {
                                  ev14.closeAbnormally(fr14, e)
                                } catch { case secondaryException: Exception =>
                                  ev14.handleSecondaryException(e, secondaryException)
                                }
                                throw e
                            }
                            ev14.close(fr14)
                            res14
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M, r14: =>N, r15: =>O, r16: =>P, r17: =>Q)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M], ev14: Resource[N], ev15: Resource[O], ev16: Resource[P], ev17: Resource[Q]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            val fr14 = r14
                            ev14.open(fr14)
                            val res14 = try {
                              val fr15 = r15
                              ev15.open(fr15)
                              val res15 = try {
                                val fr16 = r16
                                ev16.open(fr16)
                                val res16 = try {
                                  val fr17 = r17
                                  ev17.open(fr17)
                                  val res17 = try {
                                    f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13, fr14, fr15, fr16, fr17)
                                  } catch {
                                    case e: Throwable =>
                                      try {
                                        ev17.closeAbnormally(fr17, e)
                                      } catch { case secondaryException: Exception =>
                                        ev17.handleSecondaryException(e, secondaryException)
                                      }
                                      throw e
                                  }
                                  ev17.close(fr17)
                                  res17
                                } catch {
                                  case e: Throwable =>
                                    try {
                                      ev16.closeAbnormally(fr16, e)
                                    } catch { case secondaryException: Exception =>
                                      ev16.handleSecondaryException(e, secondaryException)
                                    }
                                    throw e
                                }
                                ev16.close(fr16)
                                res16
                              } catch {
                                case e: Throwable =>
                                  try {
                                    ev15.closeAbnormally(fr15, e)
                                  } catch { case secondaryException: Exception =>
                                    ev15.handleSecondaryException(e, secondaryException)
                                  }
                                  throw e
                              }
                              ev15.close(fr15)
                              res15
                            } catch {
                              case e: Throwable =>
                                try {
                                  ev14.closeAbnormally(fr14, e)
                                } catch { case secondaryException: Exception =>
                                  ev14.handleSecondaryException(e, secondaryException)
                                }
                                throw e
                            }
                            ev14.close(fr14)
                            res14
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M, r14: =>N, r15: =>O, r16: =>P, r17: =>Q, r18: =>R)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M], ev14: Resource[N], ev15: Resource[O], ev16: Resource[P], ev17: Resource[Q], ev18: Resource[R]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            val fr14 = r14
                            ev14.open(fr14)
                            val res14 = try {
                              val fr15 = r15
                              ev15.open(fr15)
                              val res15 = try {
                                val fr16 = r16
                                ev16.open(fr16)
                                val res16 = try {
                                  val fr17 = r17
                                  ev17.open(fr17)
                                  val res17 = try {
                                    val fr18 = r18
                                    ev18.open(fr18)
                                    val res18 = try {
                                      f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13, fr14, fr15, fr16, fr17, fr18)
                                    } catch {
                                      case e: Throwable =>
                                        try {
                                          ev18.closeAbnormally(fr18, e)
                                        } catch { case secondaryException: Exception =>
                                          ev18.handleSecondaryException(e, secondaryException)
                                        }
                                        throw e
                                    }
                                    ev18.close(fr18)
                                    res18
                                  } catch {
                                    case e: Throwable =>
                                      try {
                                        ev17.closeAbnormally(fr17, e)
                                      } catch { case secondaryException: Exception =>
                                        ev17.handleSecondaryException(e, secondaryException)
                                      }
                                      throw e
                                  }
                                  ev17.close(fr17)
                                  res17
                                } catch {
                                  case e: Throwable =>
                                    try {
                                      ev16.closeAbnormally(fr16, e)
                                    } catch { case secondaryException: Exception =>
                                      ev16.handleSecondaryException(e, secondaryException)
                                    }
                                    throw e
                                }
                                ev16.close(fr16)
                                res16
                              } catch {
                                case e: Throwable =>
                                  try {
                                    ev15.closeAbnormally(fr15, e)
                                  } catch { case secondaryException: Exception =>
                                    ev15.handleSecondaryException(e, secondaryException)
                                  }
                                  throw e
                              }
                              ev15.close(fr15)
                              res15
                            } catch {
                              case e: Throwable =>
                                try {
                                  ev14.closeAbnormally(fr14, e)
                                } catch { case secondaryException: Exception =>
                                  ev14.handleSecondaryException(e, secondaryException)
                                }
                                throw e
                            }
                            ev14.close(fr14)
                            res14
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M, r14: =>N, r15: =>O, r16: =>P, r17: =>Q, r18: =>R, r19: =>S)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M], ev14: Resource[N], ev15: Resource[O], ev16: Resource[P], ev17: Resource[Q], ev18: Resource[R], ev19: Resource[S]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            val fr14 = r14
                            ev14.open(fr14)
                            val res14 = try {
                              val fr15 = r15
                              ev15.open(fr15)
                              val res15 = try {
                                val fr16 = r16
                                ev16.open(fr16)
                                val res16 = try {
                                  val fr17 = r17
                                  ev17.open(fr17)
                                  val res17 = try {
                                    val fr18 = r18
                                    ev18.open(fr18)
                                    val res18 = try {
                                      val fr19 = r19
                                      ev19.open(fr19)
                                      val res19 = try {
                                        f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13, fr14, fr15, fr16, fr17, fr18, fr19)
                                      } catch {
                                        case e: Throwable =>
                                          try {
                                            ev19.closeAbnormally(fr19, e)
                                          } catch { case secondaryException: Exception =>
                                            ev19.handleSecondaryException(e, secondaryException)
                                          }
                                          throw e
                                      }
                                      ev19.close(fr19)
                                      res19
                                    } catch {
                                      case e: Throwable =>
                                        try {
                                          ev18.closeAbnormally(fr18, e)
                                        } catch { case secondaryException: Exception =>
                                          ev18.handleSecondaryException(e, secondaryException)
                                        }
                                        throw e
                                    }
                                    ev18.close(fr18)
                                    res18
                                  } catch {
                                    case e: Throwable =>
                                      try {
                                        ev17.closeAbnormally(fr17, e)
                                      } catch { case secondaryException: Exception =>
                                        ev17.handleSecondaryException(e, secondaryException)
                                      }
                                      throw e
                                  }
                                  ev17.close(fr17)
                                  res17
                                } catch {
                                  case e: Throwable =>
                                    try {
                                      ev16.closeAbnormally(fr16, e)
                                    } catch { case secondaryException: Exception =>
                                      ev16.handleSecondaryException(e, secondaryException)
                                    }
                                    throw e
                                }
                                ev16.close(fr16)
                                res16
                              } catch {
                                case e: Throwable =>
                                  try {
                                    ev15.closeAbnormally(fr15, e)
                                  } catch { case secondaryException: Exception =>
                                    ev15.handleSecondaryException(e, secondaryException)
                                  }
                                  throw e
                              }
                              ev15.close(fr15)
                              res15
                            } catch {
                              case e: Throwable =>
                                try {
                                  ev14.closeAbnormally(fr14, e)
                                } catch { case secondaryException: Exception =>
                                  ev14.handleSecondaryException(e, secondaryException)
                                }
                                throw e
                            }
                            ev14.close(fr14)
                            res14
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M, r14: =>N, r15: =>O, r16: =>P, r17: =>Q, r18: =>R, r19: =>S, r20: =>T)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M], ev14: Resource[N], ev15: Resource[O], ev16: Resource[P], ev17: Resource[Q], ev18: Resource[R], ev19: Resource[S], ev20: Resource[T]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            val fr14 = r14
                            ev14.open(fr14)
                            val res14 = try {
                              val fr15 = r15
                              ev15.open(fr15)
                              val res15 = try {
                                val fr16 = r16
                                ev16.open(fr16)
                                val res16 = try {
                                  val fr17 = r17
                                  ev17.open(fr17)
                                  val res17 = try {
                                    val fr18 = r18
                                    ev18.open(fr18)
                                    val res18 = try {
                                      val fr19 = r19
                                      ev19.open(fr19)
                                      val res19 = try {
                                        val fr20 = r20
                                        ev20.open(fr20)
                                        val res20 = try {
                                          f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13, fr14, fr15, fr16, fr17, fr18, fr19, fr20)
                                        } catch {
                                          case e: Throwable =>
                                            try {
                                              ev20.closeAbnormally(fr20, e)
                                            } catch { case secondaryException: Exception =>
                                              ev20.handleSecondaryException(e, secondaryException)
                                            }
                                            throw e
                                        }
                                        ev20.close(fr20)
                                        res20
                                      } catch {
                                        case e: Throwable =>
                                          try {
                                            ev19.closeAbnormally(fr19, e)
                                          } catch { case secondaryException: Exception =>
                                            ev19.handleSecondaryException(e, secondaryException)
                                          }
                                          throw e
                                      }
                                      ev19.close(fr19)
                                      res19
                                    } catch {
                                      case e: Throwable =>
                                        try {
                                          ev18.closeAbnormally(fr18, e)
                                        } catch { case secondaryException: Exception =>
                                          ev18.handleSecondaryException(e, secondaryException)
                                        }
                                        throw e
                                    }
                                    ev18.close(fr18)
                                    res18
                                  } catch {
                                    case e: Throwable =>
                                      try {
                                        ev17.closeAbnormally(fr17, e)
                                      } catch { case secondaryException: Exception =>
                                        ev17.handleSecondaryException(e, secondaryException)
                                      }
                                      throw e
                                  }
                                  ev17.close(fr17)
                                  res17
                                } catch {
                                  case e: Throwable =>
                                    try {
                                      ev16.closeAbnormally(fr16, e)
                                    } catch { case secondaryException: Exception =>
                                      ev16.handleSecondaryException(e, secondaryException)
                                    }
                                    throw e
                                }
                                ev16.close(fr16)
                                res16
                              } catch {
                                case e: Throwable =>
                                  try {
                                    ev15.closeAbnormally(fr15, e)
                                  } catch { case secondaryException: Exception =>
                                    ev15.handleSecondaryException(e, secondaryException)
                                  }
                                  throw e
                              }
                              ev15.close(fr15)
                              res15
                            } catch {
                              case e: Throwable =>
                                try {
                                  ev14.closeAbnormally(fr14, e)
                                } catch { case secondaryException: Exception =>
                                  ev14.handleSecondaryException(e, secondaryException)
                                }
                                throw e
                            }
                            ev14.close(fr14)
                            res14
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M, r14: =>N, r15: =>O, r16: =>P, r17: =>Q, r18: =>R, r19: =>S, r20: =>T, r21: =>U)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M], ev14: Resource[N], ev15: Resource[O], ev16: Resource[P], ev17: Resource[Q], ev18: Resource[R], ev19: Resource[S], ev20: Resource[T], ev21: Resource[U]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            val fr14 = r14
                            ev14.open(fr14)
                            val res14 = try {
                              val fr15 = r15
                              ev15.open(fr15)
                              val res15 = try {
                                val fr16 = r16
                                ev16.open(fr16)
                                val res16 = try {
                                  val fr17 = r17
                                  ev17.open(fr17)
                                  val res17 = try {
                                    val fr18 = r18
                                    ev18.open(fr18)
                                    val res18 = try {
                                      val fr19 = r19
                                      ev19.open(fr19)
                                      val res19 = try {
                                        val fr20 = r20
                                        ev20.open(fr20)
                                        val res20 = try {
                                          val fr21 = r21
                                          ev21.open(fr21)
                                          val res21 = try {
                                            f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13, fr14, fr15, fr16, fr17, fr18, fr19, fr20, fr21)
                                          } catch {
                                            case e: Throwable =>
                                              try {
                                                ev21.closeAbnormally(fr21, e)
                                              } catch { case secondaryException: Exception =>
                                                ev21.handleSecondaryException(e, secondaryException)
                                              }
                                              throw e
                                          }
                                          ev21.close(fr21)
                                          res21
                                        } catch {
                                          case e: Throwable =>
                                            try {
                                              ev20.closeAbnormally(fr20, e)
                                            } catch { case secondaryException: Exception =>
                                              ev20.handleSecondaryException(e, secondaryException)
                                            }
                                            throw e
                                        }
                                        ev20.close(fr20)
                                        res20
                                      } catch {
                                        case e: Throwable =>
                                          try {
                                            ev19.closeAbnormally(fr19, e)
                                          } catch { case secondaryException: Exception =>
                                            ev19.handleSecondaryException(e, secondaryException)
                                          }
                                          throw e
                                      }
                                      ev19.close(fr19)
                                      res19
                                    } catch {
                                      case e: Throwable =>
                                        try {
                                          ev18.closeAbnormally(fr18, e)
                                        } catch { case secondaryException: Exception =>
                                          ev18.handleSecondaryException(e, secondaryException)
                                        }
                                        throw e
                                    }
                                    ev18.close(fr18)
                                    res18
                                  } catch {
                                    case e: Throwable =>
                                      try {
                                        ev17.closeAbnormally(fr17, e)
                                      } catch { case secondaryException: Exception =>
                                        ev17.handleSecondaryException(e, secondaryException)
                                      }
                                      throw e
                                  }
                                  ev17.close(fr17)
                                  res17
                                } catch {
                                  case e: Throwable =>
                                    try {
                                      ev16.closeAbnormally(fr16, e)
                                    } catch { case secondaryException: Exception =>
                                      ev16.handleSecondaryException(e, secondaryException)
                                    }
                                    throw e
                                }
                                ev16.close(fr16)
                                res16
                              } catch {
                                case e: Throwable =>
                                  try {
                                    ev15.closeAbnormally(fr15, e)
                                  } catch { case secondaryException: Exception =>
                                    ev15.handleSecondaryException(e, secondaryException)
                                  }
                                  throw e
                              }
                              ev15.close(fr15)
                              res15
                            } catch {
                              case e: Throwable =>
                                try {
                                  ev14.closeAbnormally(fr14, e)
                                } catch { case secondaryException: Exception =>
                                  ev14.handleSecondaryException(e, secondaryException)
                                }
                                throw e
                            }
                            ev14.close(fr14)
                            res14
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

def using[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, RR](r1: =>A, r2: =>B, r3: =>C, r4: =>D, r5: =>E, r6: =>F, r7: =>G, r8: =>H, r9: =>I, r10: =>J, r11: =>K, r12: =>L, r13: =>M, r14: =>N, r15: =>O, r16: =>P, r17: =>Q, r18: =>R, r19: =>S, r20: =>T, r21: =>U, r22: =>V)(f: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V) => RR)(implicit ev1: Resource[A], ev2: Resource[B], ev3: Resource[C], ev4: Resource[D], ev5: Resource[E], ev6: Resource[F], ev7: Resource[G], ev8: Resource[H], ev9: Resource[I], ev10: Resource[J], ev11: Resource[K], ev12: Resource[L], ev13: Resource[M], ev14: Resource[N], ev15: Resource[O], ev16: Resource[P], ev17: Resource[Q], ev18: Resource[R], ev19: Resource[S], ev20: Resource[T], ev21: Resource[U], ev22: Resource[V]): RR = {
  val fr1 = r1
  ev1.open(fr1)
  val res1 = try {
    val fr2 = r2
    ev2.open(fr2)
    val res2 = try {
      val fr3 = r3
      ev3.open(fr3)
      val res3 = try {
        val fr4 = r4
        ev4.open(fr4)
        val res4 = try {
          val fr5 = r5
          ev5.open(fr5)
          val res5 = try {
            val fr6 = r6
            ev6.open(fr6)
            val res6 = try {
              val fr7 = r7
              ev7.open(fr7)
              val res7 = try {
                val fr8 = r8
                ev8.open(fr8)
                val res8 = try {
                  val fr9 = r9
                  ev9.open(fr9)
                  val res9 = try {
                    val fr10 = r10
                    ev10.open(fr10)
                    val res10 = try {
                      val fr11 = r11
                      ev11.open(fr11)
                      val res11 = try {
                        val fr12 = r12
                        ev12.open(fr12)
                        val res12 = try {
                          val fr13 = r13
                          ev13.open(fr13)
                          val res13 = try {
                            val fr14 = r14
                            ev14.open(fr14)
                            val res14 = try {
                              val fr15 = r15
                              ev15.open(fr15)
                              val res15 = try {
                                val fr16 = r16
                                ev16.open(fr16)
                                val res16 = try {
                                  val fr17 = r17
                                  ev17.open(fr17)
                                  val res17 = try {
                                    val fr18 = r18
                                    ev18.open(fr18)
                                    val res18 = try {
                                      val fr19 = r19
                                      ev19.open(fr19)
                                      val res19 = try {
                                        val fr20 = r20
                                        ev20.open(fr20)
                                        val res20 = try {
                                          val fr21 = r21
                                          ev21.open(fr21)
                                          val res21 = try {
                                            val fr22 = r22
                                            ev22.open(fr22)
                                            val res22 = try {
                                              f(fr1, fr2, fr3, fr4, fr5, fr6, fr7, fr8, fr9, fr10, fr11, fr12, fr13, fr14, fr15, fr16, fr17, fr18, fr19, fr20, fr21, fr22)
                                            } catch {
                                              case e: Throwable =>
                                                try {
                                                  ev22.closeAbnormally(fr22, e)
                                                } catch { case secondaryException: Exception =>
                                                  ev22.handleSecondaryException(e, secondaryException)
                                                }
                                                throw e
                                            }
                                            ev22.close(fr22)
                                            res22
                                          } catch {
                                            case e: Throwable =>
                                              try {
                                                ev21.closeAbnormally(fr21, e)
                                              } catch { case secondaryException: Exception =>
                                                ev21.handleSecondaryException(e, secondaryException)
                                              }
                                              throw e
                                          }
                                          ev21.close(fr21)
                                          res21
                                        } catch {
                                          case e: Throwable =>
                                            try {
                                              ev20.closeAbnormally(fr20, e)
                                            } catch { case secondaryException: Exception =>
                                              ev20.handleSecondaryException(e, secondaryException)
                                            }
                                            throw e
                                        }
                                        ev20.close(fr20)
                                        res20
                                      } catch {
                                        case e: Throwable =>
                                          try {
                                            ev19.closeAbnormally(fr19, e)
                                          } catch { case secondaryException: Exception =>
                                            ev19.handleSecondaryException(e, secondaryException)
                                          }
                                          throw e
                                      }
                                      ev19.close(fr19)
                                      res19
                                    } catch {
                                      case e: Throwable =>
                                        try {
                                          ev18.closeAbnormally(fr18, e)
                                        } catch { case secondaryException: Exception =>
                                          ev18.handleSecondaryException(e, secondaryException)
                                        }
                                        throw e
                                    }
                                    ev18.close(fr18)
                                    res18
                                  } catch {
                                    case e: Throwable =>
                                      try {
                                        ev17.closeAbnormally(fr17, e)
                                      } catch { case secondaryException: Exception =>
                                        ev17.handleSecondaryException(e, secondaryException)
                                      }
                                      throw e
                                  }
                                  ev17.close(fr17)
                                  res17
                                } catch {
                                  case e: Throwable =>
                                    try {
                                      ev16.closeAbnormally(fr16, e)
                                    } catch { case secondaryException: Exception =>
                                      ev16.handleSecondaryException(e, secondaryException)
                                    }
                                    throw e
                                }
                                ev16.close(fr16)
                                res16
                              } catch {
                                case e: Throwable =>
                                  try {
                                    ev15.closeAbnormally(fr15, e)
                                  } catch { case secondaryException: Exception =>
                                    ev15.handleSecondaryException(e, secondaryException)
                                  }
                                  throw e
                              }
                              ev15.close(fr15)
                              res15
                            } catch {
                              case e: Throwable =>
                                try {
                                  ev14.closeAbnormally(fr14, e)
                                } catch { case secondaryException: Exception =>
                                  ev14.handleSecondaryException(e, secondaryException)
                                }
                                throw e
                            }
                            ev14.close(fr14)
                            res14
                          } catch {
                            case e: Throwable =>
                              try {
                                ev13.closeAbnormally(fr13, e)
                              } catch { case secondaryException: Exception =>
                                ev13.handleSecondaryException(e, secondaryException)
                              }
                              throw e
                          }
                          ev13.close(fr13)
                          res13
                        } catch {
                          case e: Throwable =>
                            try {
                              ev12.closeAbnormally(fr12, e)
                            } catch { case secondaryException: Exception =>
                              ev12.handleSecondaryException(e, secondaryException)
                            }
                            throw e
                        }
                        ev12.close(fr12)
                        res12
                      } catch {
                        case e: Throwable =>
                          try {
                            ev11.closeAbnormally(fr11, e)
                          } catch { case secondaryException: Exception =>
                            ev11.handleSecondaryException(e, secondaryException)
                          }
                          throw e
                      }
                      ev11.close(fr11)
                      res11
                    } catch {
                      case e: Throwable =>
                        try {
                          ev10.closeAbnormally(fr10, e)
                        } catch { case secondaryException: Exception =>
                          ev10.handleSecondaryException(e, secondaryException)
                        }
                        throw e
                    }
                    ev10.close(fr10)
                    res10
                  } catch {
                    case e: Throwable =>
                      try {
                        ev9.closeAbnormally(fr9, e)
                      } catch { case secondaryException: Exception =>
                        ev9.handleSecondaryException(e, secondaryException)
                      }
                      throw e
                  }
                  ev9.close(fr9)
                  res9
                } catch {
                  case e: Throwable =>
                    try {
                      ev8.closeAbnormally(fr8, e)
                    } catch { case secondaryException: Exception =>
                      ev8.handleSecondaryException(e, secondaryException)
                    }
                    throw e
                }
                ev8.close(fr8)
                res8
              } catch {
                case e: Throwable =>
                  try {
                    ev7.closeAbnormally(fr7, e)
                  } catch { case secondaryException: Exception =>
                    ev7.handleSecondaryException(e, secondaryException)
                  }
                  throw e
              }
              ev7.close(fr7)
              res7
            } catch {
              case e: Throwable =>
                try {
                  ev6.closeAbnormally(fr6, e)
                } catch { case secondaryException: Exception =>
                  ev6.handleSecondaryException(e, secondaryException)
                }
                throw e
            }
            ev6.close(fr6)
            res6
          } catch {
            case e: Throwable =>
              try {
                ev5.closeAbnormally(fr5, e)
              } catch { case secondaryException: Exception =>
                ev5.handleSecondaryException(e, secondaryException)
              }
              throw e
          }
          ev5.close(fr5)
          res5
        } catch {
          case e: Throwable =>
            try {
              ev4.closeAbnormally(fr4, e)
            } catch { case secondaryException: Exception =>
              ev4.handleSecondaryException(e, secondaryException)
            }
            throw e
        }
        ev4.close(fr4)
        res4
      } catch {
        case e: Throwable =>
          try {
            ev3.closeAbnormally(fr3, e)
          } catch { case secondaryException: Exception =>
            ev3.handleSecondaryException(e, secondaryException)
          }
          throw e
      }
      ev3.close(fr3)
      res3
    } catch {
      case e: Throwable =>
        try {
          ev2.closeAbnormally(fr2, e)
        } catch { case secondaryException: Exception =>
          ev2.handleSecondaryException(e, secondaryException)
        }
        throw e
    }
    ev2.close(fr2)
    res2
  } catch {
    case e: Throwable =>
      try {
        ev1.closeAbnormally(fr1, e)
      } catch { case secondaryException: Exception =>
        ev1.handleSecondaryException(e, secondaryException)
      }
      throw e
  }
  ev1.close(fr1)
  res1
}

}
