package com.rokt.roktsdk

import android.app.Activity
import android.app.Application
import com.rokt.roktsdk.embedded.Widget
import java.lang.ref.WeakReference

/**
 * ### The main interface to Rokt SDK
 *
 * Use the member methods to interact with the Rokt SDK
 */
@Deprecated("This class is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
object RoktLegacy {

    /**
     * ### Initializes Rokt Widget with Activity
     *
     * Initialize the Rokt SDK prior to using it in any Activity.
     * The recommended way of calling the init method is inside Application class or inside Launcher Activity class.
     *
     * ***Kotlin***
     *
     *  ```
     *  // Replace xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx with your Rokt Tag ID
     *   // Replace y.y with the application version
     *  Rokt.init("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "y.y", this@LauncherActivity)
     *  ```
     *
     * ***Java***
     *
     *  ```
     *  // Replace xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx with your Rokt Tag ID
     *   // Replace y.y with the application version
     *  Rokt.INSTANCE.init("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "y.y", LauncherActivity.this)
     *  ```
     *
     * @param roktTagId the TagID relating to your application
     * @param appVersion version of your application not the SDK
     * @param activity the Activity in which you are calling this method
     */
    @Deprecated("This function is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
    fun init(roktTagId: String, appVersion: String, activity: Activity)

    /**
     * ### Initializes Rokt Widget with Application
     *
     * Initialize the Rokt SDK prior to using it in any Activity.
     * The recommended way of calling the init method is inside Application class or inside Launcher Activity class.
     *
     * ***Kotlin***
     *
     *  ```
     *  // Replace xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx with your Rokt Tag ID
     *  // Replace y.y with the application version
     *  Rokt.init("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "y.y", this@YourApplication)
     *  ```
     *
     * ***Java***
     *
     *  ```
     *  // Replace xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx with your Rokt Tag ID
     *  // Replace y.y with the application version
     *  Rokt.INSTANCE.init("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "y.y", YourApplication.this)
     *  ```
     *
     * @param roktTagId the TagID relating to your application
     * @param appVersion version of your application not the SDK
     * @param application Application object
     */
    @Deprecated("This function is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
    fun init(roktTagId: String, appVersion: String, application: Application)

    /**
     * ### Execute Rokt Widget
     *
     * This is the entry point to display a widget to the consumer.
     *
     * The Rokt widget view displays after a short delay, configurable via the Rokt platform.
     *
     * The SDK provides optional callback events for when the view loads and unloads.
     *
     * Your app dictates which consumer attributes are passed through to Rokt
     *
     * ***Kotlin***
     *
     *  ```
     *  val attributes = hashMapOf(
     *      Pair("email", "j.smith@example.com"),
     *      Pair("firstname", "Jenny"),
     *      Pair("lastname", "Smith"),
     *      Pair("mobile", "(323) 867-5309"),
     *      Pair("postcode", "90210"),
     *      Pair("country", "US"))
     *
     *      // Optional Embedded widget placeholder mapping the placeholder view with placement location configuration
     *      val widget = findViewById<Widget>(R.id.roktWidget)
     *      val placeHolders = hashMapOf(
     *          Pair("RoktEmbedded1", WeakReference(widget))
     *      )
     *
     *  Rokt.execute("RoktExperience",
     *      attributes,
     *      object : Rokt.RoktCallback {
     *          override fun onUnload(reason: Rokt.UnloadReasons) {
     *          }
     *          override fun onLoad() {
     *          }
     *          override fun onShouldHideLoadingIndicator() {
     *          }
     *          override fun onShouldShowLoadingIndicator() {
     *          }
     *      },
     *      placeHolders // optional Embedded widget placement mapping
     *  )
     * ```
     *
     * ***Java***
     *
     * ```
     *  Map<String,String> attributes = new HashMap<String, String>();
     *  attributes.put("email", "j.smith@example.com");
     *  attributes.put("firstname", "Jenny");
     *  attributes.put("lastname", "Smith");
     *  attributes.put("mobile", "(323) 867-5309");
     *  attributes.put("postcode", "90210");
     *  attributes.put("country", "US");
     *
     *  // Optional Embedded widget placeholder mapping the placeholder view with placement location configuration
     *  Widget widget = findViewById(R.id.roktWidget);
     *  Map<String, WeakReference<Widget>> placeHolders = new HashMap<>();
     *  placeHolders.put("RoktEmbedded1", new WeakReference<>(widget));
     *
     *  Rokt.INSTANCE.execute("RoktExperience",
     *      attributes,
     *      new Rokt.RoktCallback() {
     *          @Override
     *          public void onLoad() {
     *          }
     *          @Override
     *          public void onUnload(Rokt.UnloadReasons unloadReasons) {
     *          }
     *          @Override
     *          public void onShouldHideLoadingIndicator() {
     *          }
     *          @Override
     *          public void onShouldShowLoadingIndicator() {
     *          }
     *      },
     *      placeHolders // optional Embedded widget placement mapping
     *   )
     * ```
     *
     * @param viewName the viewname of the widget you are trying to fetch
     * @param attributes list of attributes the host application can pass when fetching the widget for example First/Last Name, etc
     * @param callback callback for load/unload
     * @param placeholders optional. map of embedded widget placements with placement location configuration
     */
    @Deprecated("This function is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
    fun execute(
        viewName: String,
        attributes: Map<String, String>? = null,
        callback: RoktCallback,
        placeholders: Map<String, WeakReference<Widget>>? = null
    )

    /**
     * ### Enable or disable debug logging from the library
     *
     * @param enable enables or disables debug logging
     */
    @Deprecated("This function is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
    fun setLoggingEnabled(enable: Boolean)

    /**
     *
     * ### Optional callback events for when the view loads and unloads.
     *
     */
    @Deprecated("This interface is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
    interface RoktCallback {
        /**
         *
         * onLoad Callback will be triggered immediately when the Rokt Widget displays.
         */
        @Deprecated("This function is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
        fun onLoad()

        /**
         *
         * onUnLoad Callback will be triggered if the Rokt Widget failed to show or it closed.
         */
        @Deprecated("This function is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
        fun onUnload(reason: UnloadReasons)

        /**
         *
         * onShouldShowLoadingIndicator callback will be triggered if Rokt Widget start processing
         */
        @Deprecated("This function is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
        fun onShouldShowLoadingIndicator()

        /**
         *
         * onShouldHideLoadingIndicator callback will be triggered if Rokt Widget end processing
         */
        @Deprecated("This function is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
        fun onShouldHideLoadingIndicator()
    }

    /**
     * ### Reasons for unloading the widget
     */
    @Deprecated("This enum is deprecated and will be removed in a future release. Please use the new Rokt SDK instead.")
    enum class UnloadReasons {
        /**
         * Called when there are no offers to display so the widget does not get loaded in
         */
        NO_OFFERS,
        /**
         * Widget has been rendered and has been completed
         */
        FINISHED,
        /**
         * Operation to fetch widget took too long to resolve
         */
        TIMEOUT,
        /**
         * Some error has regarding the network
         */
        NETWORK_ERROR,
        /**
         * Widget is empty
         */
        NO_WIDGET,
        /**
         * Catch-all for all issues
         */
        UNKNOWN
    }
}
