/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.overlay.lightbox;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0014J\b\u0010\u001c\u001a\u00020\u0012H\u0002J(\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\f2\b\b\u0002\u0010!\u001a\u00020\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/rokt/roktsdk/internal/overlay/lightbox/OverlayLinearLayout;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "applyAllSides", "", "borderPaint", "Landroid/graphics/Paint;", "cornerRadius", "", "path", "Landroid/graphics/Path;", "rectF", "Landroid/graphics/RectF;", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "draw", "onSizeChanged", "w", "", "h", "oldw", "oldh", "resetPath", "setCustomParams", "radius", "borderColor", "borderWidth", "allSides", "legacyroktsdk_devRelease"})
public final class OverlayLinearLayout
extends LinearLayout {
    @Nullable
    private RectF rectF;
    @NotNull
    private final Path path;
    private float cornerRadius;
    @Nullable
    private Paint borderPaint;
    private boolean applyAllSides;

    public OverlayLinearLayout(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.path = new Path();
        this.applyAllSides = true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.rectF = new RectF(0.0f, 0.0f, (float)w, (float)h);
        this.resetPath();
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int save = canvas.save();
        canvas.clipPath(this.path);
        super.draw(canvas);
        Paint paint = this.borderPaint;
        if (paint != null) {
            Paint paint2 = paint;
            boolean bl = false;
            RectF rectF = this.rectF;
            if (rectF != null) {
                RectF rect = rectF;
                boolean bl2 = false;
                canvas.drawRoundRect(rect, this.cornerRadius, this.cornerRadius, paint2);
            }
        }
        canvas.restoreToCount(save);
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int save = canvas.save();
        canvas.clipPath(this.path);
        super.dispatchDraw(canvas);
        canvas.restoreToCount(save);
    }

    private final void resetPath() {
        this.path.reset();
        RectF rectF = this.rectF;
        if (rectF != null) {
            float[] fArray;
            float[] fArray2;
            RectF rect = rectF;
            boolean bl = false;
            if (this.applyAllSides) {
                fArray2 = new float[]{this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius};
                fArray = fArray2;
            } else {
                fArray2 = new float[]{this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, 0.0f, 0.0f, 0.0f, 0.0f};
                fArray = fArray2;
            }
            float[] corners = fArray;
            this.path.addRoundRect(rect, corners, Path.Direction.CW);
        }
        this.path.close();
    }

    /*
     * WARNING - void declaration
     */
    public final void setCustomParams(float radius, int borderColor, float borderWidth, boolean allSides) {
        void $this$setCustomParams_u24lambda_u243;
        Paint paint;
        this.cornerRadius = radius;
        this.applyAllSides = allSides;
        Paint paint2 = paint = new Paint(1);
        OverlayLinearLayout overlayLinearLayout = this;
        boolean bl = false;
        $this$setCustomParams_u24lambda_u243.setColor(borderColor);
        $this$setCustomParams_u24lambda_u243.setStyle(Paint.Style.STROKE);
        $this$setCustomParams_u24lambda_u243.setStrokeWidth(borderWidth);
        overlayLinearLayout.borderPaint = paint;
        this.invalidate();
    }

    public static /* synthetic */ void setCustomParams$default(OverlayLinearLayout overlayLinearLayout, float f, int n, float f2, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        overlayLinearLayout.setCustomParams(f, n, f2, bl);
    }
}

