/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.requestutils;

import android.content.Context;
import androidx.annotation.StringRes;
import com.rokt.legacy.roktsdk.R;
import com.rokt.roktsdk.internal.overlay.OverlayActivity;
import com.rokt.roktsdk.internal.requestutils.InitStatus;
import com.rokt.roktsdk.internal.util.Logger;
import com.rokt.roktsdk.internal.widget.ApplicationStateRepository;
import com.rokt.roktsdk.internal.widget.PlacementStateBag;
import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/CloseRequestHandler;", "", "initStatus", "Lcom/rokt/roktsdk/internal/requestutils/InitStatus;", "applicationStateRepository", "Lcom/rokt/roktsdk/internal/widget/ApplicationStateRepository;", "logger", "Lcom/rokt/roktsdk/internal/util/Logger;", "context", "Landroid/content/Context;", "(Lcom/rokt/roktsdk/internal/requestutils/InitStatus;Lcom/rokt/roktsdk/internal/widget/ApplicationStateRepository;Lcom/rokt/roktsdk/internal/util/Logger;Landroid/content/Context;)V", "close", "", "logExternal", "resId", "", "legacyroktsdk_devRelease"})
public final class CloseRequestHandler {
    @NotNull
    private final InitStatus initStatus;
    @NotNull
    private final ApplicationStateRepository applicationStateRepository;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Context context;

    public CloseRequestHandler(@NotNull InitStatus initStatus, @NotNull ApplicationStateRepository applicationStateRepository, @NotNull Logger logger, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)initStatus, (String)"initStatus");
        Intrinsics.checkNotNullParameter((Object)applicationStateRepository, (String)"applicationStateRepository");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.initStatus = initStatus;
        this.applicationStateRepository = applicationStateRepository;
        this.logger = logger;
        this.context = context;
    }

    public final void close() {
        if (!this.initStatus.getInitialised() || this.applicationStateRepository.getCurrentActivity().get() == null) {
            this.logExternal(R.string.rokt_err_init_not_completed);
            return;
        }
        for (PlacementStateBag placement : this.applicationStateRepository.getPlacementStateBags()) {
            Object object = placement.getOverlayReference();
            if (object == null || (object = (OverlayActivity)((Object)((Reference)object).get())) == null) continue;
            ((OverlayActivity)((Object)object)).close$legacyroktsdk_devRelease();
        }
    }

    private final void logExternal(@StringRes int resId) {
        String string2 = this.context.getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(resId)");
        this.logger.log("ROKTSDK", string2);
    }
}

