/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.util;

import android.annotation.SuppressLint;
import android.content.Context;
import com.rokt.legacy.roktsdk.R;
import com.rokt.roktsdk.internal.api.RoktAPI;
import com.rokt.roktsdk.internal.api.models.FontItem;
import com.rokt.roktsdk.internal.api.models.FontStyle;
import com.rokt.roktsdk.internal.requestutils.DiagnosticsRequestHandler;
import com.rokt.roktsdk.internal.requestutils.InitStatus;
import com.rokt.roktsdk.internal.requestutils.SchedulerProvider;
import com.rokt.roktsdk.internal.util.AssetUtil;
import com.rokt.roktsdk.internal.util.Constants;
import com.rokt.roktsdk.internal.util.FontManager;
import com.rokt.roktsdk.internal.util.Logger;
import com.rokt.roktsdk.internal.util.PreferenceUtil;
import com.rokt.roktsdk.internal.util.TimeProvider;
import com.rokt.roktsdk.internal.util.UtilsKt;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\f\u0010$\u001a\u00020\u001c*\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/rokt/roktsdk/internal/util/FontManager;", "", "api", "Lcom/rokt/roktsdk/internal/api/RoktAPI;", "diagnosticsRequestHandler", "Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;", "schedulers", "Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;", "context", "Landroid/content/Context;", "assetUtil", "Lcom/rokt/roktsdk/internal/util/AssetUtil;", "preference", "Lcom/rokt/roktsdk/internal/util/PreferenceUtil;", "timeProvider", "Lcom/rokt/roktsdk/internal/util/TimeProvider;", "logger", "Lcom/rokt/roktsdk/internal/util/Logger;", "initStatus", "Lcom/rokt/roktsdk/internal/requestutils/InitStatus;", "(Lcom/rokt/roktsdk/internal/api/RoktAPI;Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;Landroid/content/Context;Lcom/rokt/roktsdk/internal/util/AssetUtil;Lcom/rokt/roktsdk/internal/util/PreferenceUtil;Lcom/rokt/roktsdk/internal/util/TimeProvider;Lcom/rokt/roktsdk/internal/util/Logger;Lcom/rokt/roktsdk/internal/requestutils/InitStatus;)V", "deleteUnusedFonts", "", "fonts", "", "Lcom/rokt/roktsdk/internal/api/models/FontItem;", "downloadFont", "Lio/reactivex/Observable;", "", "fontItem", "downloadFonts", "isFontCacheExpired", "", "timeStamp", "", "isFontNotCachedAndNotExpired", "getFontKey", "Companion", "legacyroktsdk_devRelease"})
@SourceDebugExtension(value={"SMAP\nFontManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontManager.kt\ncom/rokt/roktsdk/internal/util/FontManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1855#2:129\n1747#2,3:130\n1856#2:134\n1#3:133\n*S KotlinDebug\n*F\n+ 1 FontManager.kt\ncom/rokt/roktsdk/internal/util/FontManager\n*L\n101#1:129\n102#1:130,3\n101#1:134\n*E\n"})
public final class FontManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoktAPI api;
    @NotNull
    private final DiagnosticsRequestHandler diagnosticsRequestHandler;
    @NotNull
    private final SchedulerProvider schedulers;
    @NotNull
    private final Context context;
    @NotNull
    private final AssetUtil assetUtil;
    @NotNull
    private final PreferenceUtil preference;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final Logger logger;
    @NotNull
    private final InitStatus initStatus;
    @NotNull
    private static final String KEY_DOWNLOADED_FONTS = "DownloadedFonts";
    @NotNull
    private static final String KEY_FONT_NAME_SUFFIX = "_name";
    @NotNull
    private static final String KEY_FONT_STYLE_SUFFIX = "_style";
    @NotNull
    private static final String KEY_FONT_TIMESTAMP_SUFFIX = "_timestamp";
    @NotNull
    private static final String TAG = "ROKT_INIT";

    public FontManager(@NotNull RoktAPI api, @NotNull DiagnosticsRequestHandler diagnosticsRequestHandler, @NotNull SchedulerProvider schedulers, @NotNull Context context, @NotNull AssetUtil assetUtil, @NotNull PreferenceUtil preference, @NotNull TimeProvider timeProvider, @NotNull Logger logger, @NotNull InitStatus initStatus) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)diagnosticsRequestHandler, (String)"diagnosticsRequestHandler");
        Intrinsics.checkNotNullParameter((Object)schedulers, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assetUtil, (String)"assetUtil");
        Intrinsics.checkNotNullParameter((Object)preference, (String)"preference");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)initStatus, (String)"initStatus");
        this.api = api;
        this.diagnosticsRequestHandler = diagnosticsRequestHandler;
        this.schedulers = schedulers;
        this.context = context;
        this.assetUtil = assetUtil;
        this.preference = preference;
        this.timeProvider = timeProvider;
        this.logger = logger;
        this.initStatus = initStatus;
    }

    @SuppressLint(value={"CheckResult"})
    public final void downloadFonts(@Nullable List<FontItem> fonts) {
        if (fonts == null) {
            return;
        }
        this.deleteUnusedFonts(fonts);
        Observable.fromIterable((Iterable)fonts).subscribeOn(this.schedulers.io()).observeOn(this.schedulers.io()).filter(arg_0 -> FontManager.downloadFonts$lambda$0((Function1)new Function1<FontItem, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull FontItem p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return FontManager.access$isFontNotCachedAndNotExpired((FontManager)this.receiver, p0);
            }
        }, arg_0)).filter(arg_0 -> FontManager.downloadFonts$lambda$1(downloadFonts.2.INSTANCE, arg_0)).flatMap(arg_0 -> FontManager.downloadFonts$lambda$2((Function1)new Function1<FontItem, Observable<String>>((Object)this){

            @NotNull
            public final Observable<String> invoke(@NotNull FontItem p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return FontManager.access$downloadFont((FontManager)this.receiver, p0);
            }
        }, arg_0)).toList().subscribe(arg_0 -> FontManager.downloadFonts$lambda$3((Function1)new Function1<List<String>, Unit>(this, fonts){
            final /* synthetic */ FontManager this$0;
            final /* synthetic */ List<FontItem> $fonts;
            {
                this.this$0 = $receiver;
                this.$fonts = $fonts;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(List<String> it) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$fonts;
                FontManager fontManager = this.this$0;
                String string2 = "DownloadedFonts";
                PreferenceUtil preferenceUtil = FontManager.access$getPreference$p(this.this$0);
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    FontItem fontItem = (FontItem)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(FontManager.access$getFontKey(fontManager, (FontItem)it2));
                }
                collection = (List)destination$iv$iv;
                preferenceUtil.saveStringSet(string2, CollectionsKt.toSet((Iterable)collection));
            }
        }, arg_0), arg_0 -> FontManager.downloadFonts$lambda$4((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ FontManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Throwable it) {
                FontManager.access$getInitStatus$p(this.this$0).setInitialised(false);
                Logger logger = FontManager.access$getLogger$p(this.this$0);
                String string2 = FontManager.access$getContext$p(this.this$0).getString(R.string.rokt_err_init_failed_font);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026okt_err_init_failed_font)");
                logger.log("ROKTSDK", string2);
            }
        }, arg_0));
    }

    private final boolean isFontNotCachedAndNotExpired(FontItem fontItem) {
        String fontKey = this.getFontKey(fontItem);
        Set downloadedFonts = PreferenceUtil.getStringSet$default(this.preference, KEY_DOWNLOADED_FONTS, null, 2, null);
        if (downloadedFonts.contains(fontKey)) {
            long timeStamp = PreferenceUtil.getLong$default(this.preference, fontKey + KEY_FONT_TIMESTAMP_SUFFIX, 0L, 2, null);
            return this.isFontCacheExpired(timeStamp) || !this.assetUtil.isFileExists(fontItem.getFontName());
        }
        return true;
    }

    private final Observable<String> downloadFont(FontItem fontItem) {
        Observable observable = this.api.getCustomFont(fontItem.getFontUrl()).timeout(30000L, TimeUnit.MILLISECONDS, this.schedulers.computation()).retry((arg_0, arg_1) -> FontManager.downloadFont$lambda$5(downloadFont.1.INSTANCE, arg_0, arg_1)).map(arg_0 -> FontManager.downloadFont$lambda$6((Function1)new Function1<ResponseBody, String>(this, fontItem){
            final /* synthetic */ FontManager this$0;
            final /* synthetic */ FontItem $fontItem;
            {
                this.this$0 = $receiver;
                this.$fontItem = $fontItem;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(@NotNull ResponseBody it) {
                void var2_2;
                FontStyle fontStyle;
                String string2;
                PreferenceUtil preferenceUtil;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (FontManager.access$getAssetUtil$p(this.this$0).saveFilePrivate(this.$fontItem.getFontName(), it.byteStream())) {
                    FontManager.access$getLogger$p(this.this$0).logInternal("ROKT_INIT", "Font file saved " + this.$fontItem.getFontName());
                    String fontKey = FontManager.access$getFontKey(this.this$0, this.$fontItem);
                    FontManager.access$getPreference$p(this.this$0).saveLong(fontKey + "_timestamp", FontManager.access$getTimeProvider$p(this.this$0).getCurrentTimeMillis());
                    FontManager.access$getPreference$p(this.this$0).saveString(fontKey + "_name", this.$fontItem.getFontName());
                    preferenceUtil = FontManager.access$getPreference$p(this.this$0);
                    string2 = fontKey + "_style";
                    fontStyle = this.$fontItem.getFontStyle();
                    if (fontStyle == null) {
                        fontStyle = FontStyle.Normal;
                    }
                } else {
                    throw new RuntimeException("Custom font save error");
                }
                preferenceUtil.saveString(string2, fontStyle.name());
                return var2_2;
            }
        }, arg_0)).doOnError(arg_0 -> FontManager.downloadFont$lambda$7((Function1)new Function1<Throwable, Unit>(this, fontItem){
            final /* synthetic */ FontManager this$0;
            final /* synthetic */ FontItem $fontItem;
            {
                this.this$0 = $receiver;
                this.$fontItem = $fontItem;
                super(1);
            }

            public final void invoke(Throwable it) {
                FontManager.access$getInitStatus$p(this.this$0).setInitialised(false);
                DiagnosticsRequestHandler.postDiagnostics$default(FontManager.access$getDiagnosticsRequestHandler$p(this.this$0), Constants.DiagnosticsErrorType.FONT, "font: " + this.$fontItem.getFontUrl() + ", error: " + it, null, null, null, 28, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"private fun downloadFont\u2026    )\n            }\n    }");
        return observable;
    }

    private final void deleteUnusedFonts(List<FontItem> fonts) {
        Set downloadedFonts = PreferenceUtil.getStringSet$default(this.preference, KEY_DOWNLOADED_FONTS, null, 2, null);
        Iterable $this$forEach$iv = downloadedFonts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String fontKey;
            block5: {
                fontKey = (String)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = fonts;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        FontItem it = (FontItem)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)this.getFontKey(it), (Object)fontKey)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            PreferenceUtil $this$deleteUnusedFonts_u24lambda_u2411_u24lambda_u2410 = this.preference;
            boolean bl4 = false;
            if (PreferenceUtil.getString$default($this$deleteUnusedFonts_u24lambda_u2411_u24lambda_u2410, fontKey + KEY_FONT_NAME_SUFFIX, null, 2, null) != null) {
                String it;
                boolean bl5 = false;
                this.assetUtil.deletePrivateFile(it);
            }
            $this$deleteUnusedFonts_u24lambda_u2411_u24lambda_u2410.removeKey(fontKey + KEY_FONT_NAME_SUFFIX);
            $this$deleteUnusedFonts_u24lambda_u2411_u24lambda_u2410.removeKey(fontKey + KEY_FONT_STYLE_SUFFIX);
            $this$deleteUnusedFonts_u24lambda_u2411_u24lambda_u2410.removeKey(fontKey + KEY_FONT_TIMESTAMP_SUFFIX);
            $this$deleteUnusedFonts_u24lambda_u2411_u24lambda_u2410.saveStringSet(KEY_DOWNLOADED_FONTS, SetsKt.minus((Set)downloadedFonts, (Object)fontKey));
        }
    }

    private final boolean isFontCacheExpired(long timeStamp) {
        return this.timeProvider.getCurrentTimeMillis() - timeStamp > TimeUnit.DAYS.toMillis(7L);
    }

    private final String getFontKey(FontItem $this$getFontKey) {
        String string2 = $this$getFontKey.getFontUrl();
        String string3 = $this$getFontKey.getFontName();
        FontStyle fontStyle = $this$getFontKey.getFontStyle();
        if (fontStyle == null) {
            fontStyle = FontStyle.Normal;
        }
        return UtilsKt.md5(string2 + " " + string3 + " " + fontStyle);
    }

    private static final boolean downloadFonts$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean downloadFonts$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ObservableSource downloadFonts$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ObservableSource)$tmp0.invoke(p0);
    }

    private static final void downloadFonts$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void downloadFonts$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean downloadFont$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final String downloadFont$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void downloadFont$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isFontNotCachedAndNotExpired(FontManager $this, FontItem fontItem) {
        return $this.isFontNotCachedAndNotExpired(fontItem);
    }

    public static final /* synthetic */ Observable access$downloadFont(FontManager $this, FontItem fontItem) {
        return $this.downloadFont(fontItem);
    }

    public static final /* synthetic */ PreferenceUtil access$getPreference$p(FontManager $this) {
        return $this.preference;
    }

    public static final /* synthetic */ String access$getFontKey(FontManager $this, FontItem $receiver) {
        return $this.getFontKey($receiver);
    }

    public static final /* synthetic */ InitStatus access$getInitStatus$p(FontManager $this) {
        return $this.initStatus;
    }

    public static final /* synthetic */ Logger access$getLogger$p(FontManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Context access$getContext$p(FontManager $this) {
        return $this.context;
    }

    public static final /* synthetic */ AssetUtil access$getAssetUtil$p(FontManager $this) {
        return $this.assetUtil;
    }

    public static final /* synthetic */ TimeProvider access$getTimeProvider$p(FontManager $this) {
        return $this.timeProvider;
    }

    public static final /* synthetic */ DiagnosticsRequestHandler access$getDiagnosticsRequestHandler$p(FontManager $this) {
        return $this.diagnosticsRequestHandler;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/rokt/roktsdk/internal/util/FontManager$Companion;", "", "()V", "KEY_DOWNLOADED_FONTS", "", "KEY_FONT_NAME_SUFFIX", "KEY_FONT_STYLE_SUFFIX", "KEY_FONT_TIMESTAMP_SUFFIX", "TAG", "legacyroktsdk_devRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

