/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.rokt.core.di.Component;
import com.rokt.roktsdk.RoktLegacy;
import com.rokt.roktsdk.internal.di.singleton.ApplicationComponent;
import com.rokt.roktsdk.internal.util.Constants;
import com.rokt.roktsdk.internal.util.ImageLoaderKt;
import com.rokt.roktsdk.internal.util.Logger;
import com.rokt.roktsdk.internal.util.UtilsKt;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000C\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0001\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0001\u001a8\u0010\n\u001a\u00020\u000b*\u00020\f2\b\u0010\b\u001a\u0004\u0018\u00010\r2 \u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u00060\u0011j\u0002`\u0012\u0012\u0004\u0012\u00020\u000b0\u000fj\u0002`\u0013H\u0000\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"lifeCycleObserver", "com/rokt/roktsdk/internal/util/ImageLoaderKt$lifeCycleObserver$1", "Lcom/rokt/roktsdk/internal/util/ImageLoaderKt$lifeCycleObserver$1;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "getImageStream", "Lio/reactivex/Single;", "Landroid/graphics/Bitmap;", "url", "Ljava/net/URL;", "loadImageUrl", "", "Landroid/widget/ImageView;", "", "errorHandler", "Lkotlin/Function2;", "Lcom/rokt/roktsdk/internal/util/Constants$DiagnosticsErrorType;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lcom/rokt/roktsdk/internal/util/ErrorHandler;", "legacyroktsdk_devRelease"})
@SourceDebugExtension(value={"SMAP\nImageLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageLoader.kt\ncom/rokt/roktsdk/internal/util/ImageLoaderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class ImageLoaderKt {
    @NotNull
    private static final CompositeDisposable subscriptions = new CompositeDisposable();
    @NotNull
    private static final lifeCycleObserver.1 lifeCycleObserver = new LifecycleObserver(){

        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        public final void onDestroy() {
            ImageLoaderKt.access$getSubscriptions$p().clear();
        }
    };

    public static final void loadImageUrl(@NotNull ImageView $this$loadImageUrl, @Nullable String url, @NotNull Function2<? super Constants.DiagnosticsErrorType, ? super Exception, Unit> errorHandler2) {
        block6: {
            URL uRL;
            Intrinsics.checkNotNullParameter((Object)$this$loadImageUrl, (String)"<this>");
            Intrinsics.checkNotNullParameter(errorHandler2, (String)"errorHandler");
            ApplicationComponent applicationComponent = RoktLegacy.INSTANCE.getAppComponent$legacyroktsdk_devRelease();
            Logger logger = applicationComponent != null ? (Logger)Component.get$default((Component)applicationComponent, Logger.class, null, (int)2, null) : null;
            Context context = $this$loadImageUrl.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Lifecycle lifecycle = UtilsKt.getLifecycle(context);
            if ((lifecycle != null ? lifecycle.getCurrentState() : null) == Lifecycle.State.DESTROYED) {
                Logger logger2 = logger;
                if (logger2 != null) {
                    logger2.logInternal("ImageDownloader", "View destroyed");
                }
                return;
            }
            Logger logger3 = logger;
            if (logger3 != null) {
                logger3.logInternal("ImageDownloader", "Fetching image " + url);
            }
            try {
                uRL = new URL(url);
            }
            catch (Exception e) {
                $this$loadImageUrl.setVisibility(8);
                CharSequence charSequence = url;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    errorHandler2.invoke((Object)Constants.DiagnosticsErrorType.VIEW, (Object)new Exception("IMAGE " + url, e));
                }
                return;
            }
            URL imageURL = uRL;
            subscriptions.add(ImageLoaderKt.getImageStream(imageURL).observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> ImageLoaderKt.loadImageUrl$lambda$0((Function1)new Function1<Bitmap, Unit>($this$loadImageUrl){
                final /* synthetic */ ImageView $this_loadImageUrl;
                {
                    this.$this_loadImageUrl = $receiver;
                    super(1);
                }

                public final void invoke(Bitmap bitmap) {
                    this.$this_loadImageUrl.setAlpha(0.0f);
                    this.$this_loadImageUrl.setVisibility(0);
                    this.$this_loadImageUrl.setImageBitmap(bitmap);
                    this.$this_loadImageUrl.animate().alpha(1.0f).setDuration((long)this.$this_loadImageUrl.getResources().getInteger(0x10E0000)).start();
                }
            }, arg_0), arg_0 -> ImageLoaderKt.loadImageUrl$lambda$1((Function1)new Function1<Throwable, Unit>(logger, errorHandler2, url, $this$loadImageUrl){
                final /* synthetic */ Logger $logger;
                final /* synthetic */ Function2<Constants.DiagnosticsErrorType, Exception, Unit> $errorHandler;
                final /* synthetic */ String $url;
                final /* synthetic */ ImageView $this_loadImageUrl;
                {
                    this.$logger = $logger;
                    this.$errorHandler = $errorHandler;
                    this.$url = $url;
                    this.$this_loadImageUrl = $receiver;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    Logger logger = this.$logger;
                    if (logger != null) {
                        logger.logInternal("ImageDownloader", it.toString());
                    }
                    this.$errorHandler.invoke((Object)((Object)Constants.DiagnosticsErrorType.VIEW), (Object)new Exception("IMAGE " + this.$url, it));
                    this.$this_loadImageUrl.setVisibility(8);
                }
            }, arg_0)));
            Context context2 = $this$loadImageUrl.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            Lifecycle lifecycle2 = UtilsKt.getLifecycle(context2);
            if (lifecycle2 == null) break block6;
            Lifecycle $this$loadImageUrl_u24lambda_u242 = lifecycle2;
            boolean bl = false;
            $this$loadImageUrl_u24lambda_u242.removeObserver((LifecycleObserver)lifeCycleObserver);
            $this$loadImageUrl_u24lambda_u242.addObserver((LifecycleObserver)lifeCycleObserver);
        }
    }

    @VisibleForTesting
    @NotNull
    public static final Single<Bitmap> getImageStream(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Single single = Single.create(arg_0 -> ImageLoaderKt.getImageStream$lambda$5(url, arg_0)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"create<Bitmap> { emitter\u2026scribeOn(Schedulers.io())");
        return single;
    }

    private static final void loadImageUrl$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void loadImageUrl$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getImageStream$lambda$5(URL $url, SingleEmitter emitter) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
            Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
            try {
                Closeable closeable = $url.openStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    if (!(it.available() <= 0x200000)) {
                        boolean bl2 = false;
                        String string2 = "Image size exceeded " + it.available();
                        throw new IllegalStateException(string2.toString());
                    }
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)it);
                    if (!emitter.isDisposed()) {
                        emitter.onSuccess((Object)bitmap);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                if (emitter.isDisposed()) break block9;
                emitter.onError((Throwable)e);
            }
        }
    }

    public static final /* synthetic */ CompositeDisposable access$getSubscriptions$p() {
        return subscriptions;
    }
}

