/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.requestutils;

import android.annotation.SuppressLint;
import com.rokt.roktsdk.internal.api.RoktAPI;
import com.rokt.roktsdk.internal.api.requests.DiagnosticsRequest;
import com.rokt.roktsdk.internal.api.requests.Severity;
import com.rokt.roktsdk.internal.requestutils.DiagnosticsRequestHandler;
import com.rokt.roktsdk.internal.requestutils.SchedulerProvider;
import com.rokt.roktsdk.internal.requestutils.SessionHandler;
import com.rokt.roktsdk.internal.util.Constants;
import com.rokt.roktsdk.internal.util.Logger;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ4\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J:\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;", "", "api", "Lcom/rokt/roktsdk/internal/api/RoktAPI;", "schedulers", "Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;", "requestTimeoutMillis", "", "logger", "Lcom/rokt/roktsdk/internal/util/Logger;", "sessionHandler", "Lcom/rokt/roktsdk/internal/requestutils/SessionHandler;", "(Lcom/rokt/roktsdk/internal/api/RoktAPI;Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;JLcom/rokt/roktsdk/internal/util/Logger;Lcom/rokt/roktsdk/internal/requestutils/SessionHandler;)V", "composeDiagnosticsRequest", "Lcom/rokt/roktsdk/internal/api/requests/DiagnosticsRequest;", "message", "", "callStack", "severity", "Lcom/rokt/roktsdk/internal/api/requests/Severity;", "sessionId", "campaignId", "postDiagnostics", "", "Lcom/rokt/roktsdk/internal/util/Constants$DiagnosticsErrorType;", "Companion", "legacyroktsdk_devRelease"})
@SourceDebugExtension(value={"SMAP\nDiagnosticsRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsRequestHandler.kt\ncom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class DiagnosticsRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoktAPI api;
    @NotNull
    private final SchedulerProvider schedulers;
    private final long requestTimeoutMillis;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SessionHandler sessionHandler;
    @NotNull
    private static final String TAG = "ROKT_DIAGNOSTICS";
    @NotNull
    private static final String DIAG_PREFIX = "[%s]";
    @NotNull
    private static final String SESSION_ID_META_KEY = "sessionId";
    @NotNull
    private static final String CAMPAIGN_ID_META_KEY = "campaignId";

    public DiagnosticsRequestHandler(@NotNull RoktAPI api, @NotNull SchedulerProvider schedulers, long requestTimeoutMillis, @NotNull Logger logger, @NotNull SessionHandler sessionHandler) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)schedulers, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)sessionHandler, (String)"sessionHandler");
        this.api = api;
        this.schedulers = schedulers;
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.logger = logger;
        this.sessionHandler = sessionHandler;
    }

    @SuppressLint(value={"CheckResult"})
    public final void postDiagnostics(@NotNull Constants.DiagnosticsErrorType message, @NotNull String callStack, @NotNull Severity severity, @Nullable String sessionId, @Nullable String campaignId) {
        Intrinsics.checkNotNullParameter((Object)((Object)message), (String)"message");
        Intrinsics.checkNotNullParameter((Object)callStack, (String)"callStack");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        this.logger.logInternal(TAG, "Posting diagnostics: " + message.name() + " " + callStack);
        this.api.postDiagnostics(this.sessionHandler.getSavedSession(), this.composeDiagnosticsRequest(message.name(), callStack, severity, sessionId, campaignId)).timeout(this.requestTimeoutMillis, TimeUnit.MILLISECONDS).retry((arg_0, arg_1) -> DiagnosticsRequestHandler.postDiagnostics$lambda$0(postDiagnostics.1.INSTANCE, arg_0, arg_1)).subscribeOn(this.schedulers.io()).subscribe(() -> DiagnosticsRequestHandler.postDiagnostics$lambda$1(this, message), arg_0 -> DiagnosticsRequestHandler.postDiagnostics$lambda$2((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ DiagnosticsRequestHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Throwable it) {
                DiagnosticsRequestHandler.access$getLogger$p(this.this$0).logInternal("ROKT_DIAGNOSTICS", "Posting diagnostics failed. Reason: " + it);
            }
        }, arg_0));
    }

    public static /* synthetic */ void postDiagnostics$default(DiagnosticsRequestHandler diagnosticsRequestHandler, Constants.DiagnosticsErrorType diagnosticsErrorType, String string2, Severity severity, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            severity = Severity.ERROR;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        diagnosticsRequestHandler.postDiagnostics(diagnosticsErrorType, string2, severity, string3, string4);
    }

    private final DiagnosticsRequest composeDiagnosticsRequest(String message, String callStack, Severity severity, String sessionId, String campaignId) {
        Map additionalInfo = new LinkedHashMap();
        String string2 = sessionId;
        if (string2 != null) {
            String $this$composeDiagnosticsRequest_u24lambda_u243 = string2;
            boolean bl = false;
            additionalInfo.put(SESSION_ID_META_KEY, $this$composeDiagnosticsRequest_u24lambda_u243);
        }
        String string3 = campaignId;
        if (string3 != null) {
            String $this$composeDiagnosticsRequest_u24lambda_u244 = string3;
            boolean bl = false;
            additionalInfo.put(CAMPAIGN_ID_META_KEY, $this$composeDiagnosticsRequest_u24lambda_u244);
        }
        String string4 = DIAG_PREFIX;
        Object[] objectArray = new Object[]{message};
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(this, *args)");
        return new DiagnosticsRequest(string5, callStack, severity, additionalInfo);
    }

    private static final boolean postDiagnostics$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final void postDiagnostics$lambda$1(DiagnosticsRequestHandler this$0, Constants.DiagnosticsErrorType $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$message), (String)"$message");
        this$0.logger.logInternal(TAG, "Diagnostics posted successfully: " + $message);
    }

    private static final void postDiagnostics$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DiagnosticsRequestHandler $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler$Companion;", "", "()V", "CAMPAIGN_ID_META_KEY", "", "DIAG_PREFIX", "SESSION_ID_META_KEY", "TAG", "legacyroktsdk_devRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

