/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.requestutils;

import android.annotation.SuppressLint;
import com.rokt.roktsdk.internal.api.RoktAPI;
import com.rokt.roktsdk.internal.api.models.EventNameValue;
import com.rokt.roktsdk.internal.api.models.EventType;
import com.rokt.roktsdk.internal.api.requests.EventRequest;
import com.rokt.roktsdk.internal.requestutils.DiagnosticsRequestHandler;
import com.rokt.roktsdk.internal.requestutils.EventRequestHandler;
import com.rokt.roktsdk.internal.requestutils.SchedulerProvider;
import com.rokt.roktsdk.internal.requestutils.SessionHandler;
import com.rokt.roktsdk.internal.util.Constants;
import com.rokt.roktsdk.internal.util.DateUtilsKt;
import com.rokt.roktsdk.internal.util.Logger;
import com.rokt.roktsdk.internal.util.UtilsKt;
import io.reactivex.ObservableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ[\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001fJa\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u00162\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/EventRequestHandler;", "", "api", "Lcom/rokt/roktsdk/internal/api/RoktAPI;", "schedulers", "Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;", "requestTimeoutMillis", "", "logger", "Lcom/rokt/roktsdk/internal/util/Logger;", "diagnosticsHandler", "Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;", "sessionHandler", "Lcom/rokt/roktsdk/internal/requestutils/SessionHandler;", "(Lcom/rokt/roktsdk/internal/api/RoktAPI;Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;JLcom/rokt/roktsdk/internal/util/Logger;Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;Lcom/rokt/roktsdk/internal/requestutils/SessionHandler;)V", "eventsQueuePublisher", "Lio/reactivex/subjects/PublishSubject;", "Lcom/rokt/roktsdk/internal/api/requests/EventRequest;", "composeEventRequest", "event", "Lcom/rokt/roktsdk/internal/api/models/EventType;", "sessionId", "", "parentGuid", "token", "timeStamp", "pageInstanceGuid", "extraMetadata", "", "Lcom/rokt/roktsdk/internal/api/models/EventNameValue;", "attributes", "(Lcom/rokt/roktsdk/internal/api/models/EventType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)Lcom/rokt/roktsdk/internal/api/requests/EventRequest;", "postEvent", "", "(Lcom/rokt/roktsdk/internal/api/models/EventType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "processEventQueue", "events", "Companion", "legacyroktsdk_devRelease"})
@SourceDebugExtension(value={"SMAP\nEventRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventRequestHandler.kt\ncom/rokt/roktsdk/internal/requestutils/EventRequestHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class EventRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoktAPI api;
    @NotNull
    private final SchedulerProvider schedulers;
    private final long requestTimeoutMillis;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DiagnosticsRequestHandler diagnosticsHandler;
    @NotNull
    private final SessionHandler sessionHandler;
    @NotNull
    private final PublishSubject<EventRequest> eventsQueuePublisher;
    @NotNull
    private static final String TAG = "ROKT_EVENT";
    @NotNull
    private static final String KEY_CAPTURE_METHOD = "captureMethod";
    @NotNull
    private static final String KEY_CLIENT_TIMESTAMP = "clientTimeStamp";
    @NotNull
    private static final String CLIENT_PROVIDED = "ClientProvided";
    @NotNull
    public static final String KEY_INITIATOR = "initiator";
    @NotNull
    public static final String KEY_PAGE_SIGNAL_LOAD_START = "pageSignalLoadStart";
    @NotNull
    public static final String KEY_PAGE_RENDER_ENGINE = "pageRenderEngine";
    @NotNull
    public static final String KEY_PAGE_SIGNAL_LOAD_COMPLETE = "pageSignalLoadComplete";
    @NotNull
    public static final String CLOSE_BUTTON = "CLOSE_BUTTON";
    @NotNull
    public static final String NAVIGATE_BACK_TO_APP_BUTTON = "NAVIGATE_BACK_TO_APP_BUTTON";
    @NotNull
    public static final String NO_MORE_OFFERS_TO_SHOW = "NO_MORE_OFFERS_TO_SHOW";
    @NotNull
    public static final String COLLAPSED = "COLLAPSED";
    @NotNull
    public static final String END_MESSAGE = "END_MESSAGE";
    @NotNull
    public static final String DISMISSED = "DISMISSED";
    @NotNull
    public static final String PARTNER_TRIGGERED = "PARTNER_TRIGGERED";
    @NotNull
    public static final String NEGATIVE_BUTTON = "NEGATIVE_BUTTON";
    @NotNull
    public static final String PLACEMENTS_RENDER_ENGINE = "Placements";

    public EventRequestHandler(@NotNull RoktAPI api, @NotNull SchedulerProvider schedulers, long requestTimeoutMillis, @NotNull Logger logger, @NotNull DiagnosticsRequestHandler diagnosticsHandler, @NotNull SessionHandler sessionHandler) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)schedulers, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHandler, (String)"diagnosticsHandler");
        Intrinsics.checkNotNullParameter((Object)sessionHandler, (String)"sessionHandler");
        this.api = api;
        this.schedulers = schedulers;
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.logger = logger;
        this.diagnosticsHandler = diagnosticsHandler;
        this.sessionHandler = sessionHandler;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"create()");
        this.eventsQueuePublisher = publishSubject;
        Disposable disposable = this.eventsQueuePublisher.buffer((ObservableSource)this.eventsQueuePublisher.debounce(25L, TimeUnit.MILLISECONDS, this.schedulers.io())).subscribe(arg_0 -> EventRequestHandler._init_$lambda$0((Function1)new Function1<List<EventRequest>, Unit>(this){
            final /* synthetic */ EventRequestHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(List<EventRequest> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                EventRequestHandler.access$processEventQueue(this.this$0, it);
            }
        }, arg_0));
    }

    public final void postEvent(@NotNull EventType event, @NotNull String sessionId, @NotNull String parentGuid, @NotNull String token, @Nullable Long timeStamp, @NotNull String pageInstanceGuid, @NotNull List<EventNameValue> extraMetadata, @NotNull List<EventNameValue> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)parentGuid, (String)"parentGuid");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)pageInstanceGuid, (String)"pageInstanceGuid");
        Intrinsics.checkNotNullParameter(extraMetadata, (String)"extraMetadata");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.eventsQueuePublisher.onNext((Object)this.composeEventRequest(event, sessionId, parentGuid, token, timeStamp, pageInstanceGuid, extraMetadata, attributes));
    }

    public static /* synthetic */ void postEvent$default(EventRequestHandler eventRequestHandler, EventType eventType, String string2, String string3, String string4, Long l, String string5, List list, List list2, int n, Object object) {
        if ((n & 0x10) != 0) {
            l = null;
        }
        if ((n & 0x20) != 0) {
            string5 = "";
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        eventRequestHandler.postEvent(eventType, string2, string3, string4, l, string5, list, list2);
    }

    private final EventRequest composeEventRequest(EventType event, String sessionId, String parentGuid, String token, Long timeStamp, String pageInstanceGuid, List<EventNameValue> extraMetadata, List<EventNameValue> attributes) {
        Date date;
        Long l = timeStamp;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            date = new Date(it);
        } else {
            date = new Date();
        }
        Date dateValue = date;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
        Object[] objectArray = new EventNameValue[2];
        objectArray[0] = new EventNameValue(KEY_CAPTURE_METHOD, CLIENT_PROVIDED);
        String string3 = DateUtilsKt.getRoktDateFormat().format(dateValue);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"roktDateFormat.format(dateValue)");
        objectArray[1] = new EventNameValue(KEY_CLIENT_TIMESTAMP, string3);
        return new EventRequest(sessionId, event, parentGuid, token, pageInstanceGuid, string2, attributes, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)extraMetadata));
    }

    @SuppressLint(value={"CheckResult"})
    private final void processEventQueue(List<EventRequest> events) {
        this.logger.logInternal(TAG, "Posting events: count " + events.size() + " Events: " + events);
        this.api.postEvents(this.sessionHandler.getSavedSession(), events).timeout(this.requestTimeoutMillis, TimeUnit.MILLISECONDS).retry((arg_0, arg_1) -> EventRequestHandler.processEventQueue$lambda$2(processEventQueue.1.INSTANCE, arg_0, arg_1)).subscribeOn(this.schedulers.io()).subscribe(() -> EventRequestHandler.processEventQueue$lambda$3(this, events), arg_0 -> EventRequestHandler.processEventQueue$lambda$4((Function1)new Function1<Throwable, Unit>(this, events){
            final /* synthetic */ EventRequestHandler this$0;
            final /* synthetic */ List<EventRequest> $events;
            {
                this.this$0 = $receiver;
                this.$events = $events;
                super(1);
            }

            public final void invoke(Throwable it) {
                DiagnosticsRequestHandler diagnosticsRequestHandler = EventRequestHandler.access$getDiagnosticsHandler$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                EventRequest eventRequest = (EventRequest)CollectionsKt.firstOrNull(this.$events);
                DiagnosticsRequestHandler.postDiagnostics$default(diagnosticsRequestHandler, Constants.DiagnosticsErrorType.EVENT, UtilsKt.toDiagnosticsString(it), null, eventRequest != null ? eventRequest.getSessionId() : null, null, 20, null);
            }
        }, arg_0));
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean processEventQueue$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final void processEventQueue$lambda$3(EventRequestHandler this$0, List $events) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$events, (String)"$events");
        this$0.logger.logInternal(TAG, "Events posted successfully: count " + $events.size() + " Events: " + $events);
    }

    private static final void processEventQueue$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ DiagnosticsRequestHandler access$getDiagnosticsHandler$p(EventRequestHandler $this) {
        return $this.diagnosticsHandler;
    }

    public static final /* synthetic */ void access$processEventQueue(EventRequestHandler $this, List events) {
        $this.processEventQueue(events);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/EventRequestHandler$Companion;", "", "()V", "CLIENT_PROVIDED", "", "CLOSE_BUTTON", "COLLAPSED", "DISMISSED", "END_MESSAGE", "KEY_CAPTURE_METHOD", "KEY_CLIENT_TIMESTAMP", "KEY_INITIATOR", "KEY_PAGE_RENDER_ENGINE", "KEY_PAGE_SIGNAL_LOAD_COMPLETE", "KEY_PAGE_SIGNAL_LOAD_START", "NAVIGATE_BACK_TO_APP_BUTTON", "NEGATIVE_BUTTON", "NO_MORE_OFFERS_TO_SHOW", "PARTNER_TRIGGERED", "PLACEMENTS_RENDER_ENGINE", "TAG", "legacyroktsdk_devRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

