/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.requestutils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import com.rokt.core.Result;
import com.rokt.core.model.layout.WrappedPlacementExperienceModel;
import com.rokt.legacy.roktsdk.R;
import com.rokt.roktsdk.RoktLegacy;
import com.rokt.roktsdk.RoktLegacyMapperKt;
import com.rokt.roktsdk.WidgetLegacy;
import com.rokt.roktsdk.internal.api.RoktAPI;
import com.rokt.roktsdk.internal.api.models.EventType;
import com.rokt.roktsdk.internal.api.models.Placement;
import com.rokt.roktsdk.internal.api.requests.PlacementRequest;
import com.rokt.roktsdk.internal.api.requests.PrivacyControl;
import com.rokt.roktsdk.internal.api.responses.PlacementResponse;
import com.rokt.roktsdk.internal.overlay.bottomsheet.BottomSheetActivity;
import com.rokt.roktsdk.internal.overlay.fullscreen.FullScreenActivity;
import com.rokt.roktsdk.internal.overlay.lightbox.LightBoxActivity;
import com.rokt.roktsdk.internal.requestutils.DiagnosticsRequestHandler;
import com.rokt.roktsdk.internal.requestutils.EventRequestHandler;
import com.rokt.roktsdk.internal.requestutils.ExecuteRequestHandler;
import com.rokt.roktsdk.internal.requestutils.InitStatus;
import com.rokt.roktsdk.internal.requestutils.PlacementViewCallBack;
import com.rokt.roktsdk.internal.requestutils.SchedulerProvider;
import com.rokt.roktsdk.internal.requestutils.SessionHandler;
import com.rokt.roktsdk.internal.transformer.PlacementTransformer;
import com.rokt.roktsdk.internal.util.Constants;
import com.rokt.roktsdk.internal.util.Logger;
import com.rokt.roktsdk.internal.util.PreferenceUtil;
import com.rokt.roktsdk.internal.util.UtilsKt;
import com.rokt.roktsdk.internal.viewdata.PlacementViewData;
import com.rokt.roktsdk.internal.widget.ApplicationStateRepository;
import com.rokt.roktsdk.internal.widget.ExecuteStateBag;
import com.rokt.roktsdk.internal.widget.PlacementStateBag;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u0000\u0018\u0000 J2\u00020\u0001:\u0002JKBU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016Jh\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u001a\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 \u0018\u00010\u001c2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%H\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010\u001e2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0015\u0010)\u001a\u00020*2\u0006\u0010(\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b+J\u001e\u0010,\u001a\u0004\u0018\u00010-2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001cH\u0002J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0002J \u00100\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0018\u00104\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0012\u00105\u001a\u00020\u00182\b\b\u0001\u00106\u001a\u000207H\u0002J\u001c\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020\u001a2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u001aH\u0002J'\u0010;\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020=2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0001\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020AH\u0001\u00a2\u0006\u0002\bBJ!\u0010C\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001a2\b\u0010D\u001a\u0004\u0018\u00010EH\u0001\u00a2\u0006\u0004\bF\u0010GJ!\u0010H\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001a2\b\u0010D\u001a\u0004\u0018\u00010EH\u0001\u00a2\u0006\u0004\bI\u0010GR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler;", "", "api", "Lcom/rokt/roktsdk/internal/api/RoktAPI;", "schedulers", "Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;", "initStatus", "Lcom/rokt/roktsdk/internal/requestutils/InitStatus;", "applicationStateRepository", "Lcom/rokt/roktsdk/internal/widget/ApplicationStateRepository;", "logger", "Lcom/rokt/roktsdk/internal/util/Logger;", "context", "Landroid/content/Context;", "preferenceUtil", "Lcom/rokt/roktsdk/internal/util/PreferenceUtil;", "diagnosticsHandler", "Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;", "eventRequestHandler", "Lcom/rokt/roktsdk/internal/requestutils/EventRequestHandler;", "sessionHandler", "Lcom/rokt/roktsdk/internal/requestutils/SessionHandler;", "(Lcom/rokt/roktsdk/internal/api/RoktAPI;Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;Lcom/rokt/roktsdk/internal/requestutils/InitStatus;Lcom/rokt/roktsdk/internal/widget/ApplicationStateRepository;Lcom/rokt/roktsdk/internal/util/Logger;Landroid/content/Context;Lcom/rokt/roktsdk/internal/util/PreferenceUtil;Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;Lcom/rokt/roktsdk/internal/requestutils/EventRequestHandler;Lcom/rokt/roktsdk/internal/requestutils/SessionHandler;)V", "execute", "", "viewName", "", "attributes", "", "callback", "Lcom/rokt/roktsdk/RoktLegacy$RoktLegacyCallback;", "placeholders", "Ljava/lang/ref/WeakReference;", "Lcom/rokt/roktsdk/WidgetLegacy;", "eventCallback", "Lcom/rokt/roktsdk/RoktLegacy$RoktLegacyEventCallback;", "experienceModel", "Lcom/rokt/core/Result;", "Lcom/rokt/core/model/layout/WrappedPlacementExperienceModel;", "getCallback", "executeId", "getPlacementViewCallBack", "Lcom/rokt/roktsdk/internal/requestutils/PlacementViewCallBack;", "getPlacementViewCallBack$legacyroktsdk_devRelease", "getPrivacyControls", "Lcom/rokt/roktsdk/internal/api/requests/PrivacyControl;", "handleBottomSheetWidget", "placementId", "handleEmbeddedWidget", "placement", "Lcom/rokt/roktsdk/internal/viewdata/PlacementViewData$Embedded;", "handleFullscreenWidget", "handleLightBoxWidget", "logExternal", "resId", "", "postDiagnostics", "callStack", "sessionId", "processWidgetResponse", "placementResult", "Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult;", "processWidgetResponse$legacyroktsdk_devRelease", "transformPlacementResponse", "response", "Lcom/rokt/roktsdk/internal/api/responses/PlacementResponse;", "transformPlacementResponse$legacyroktsdk_devRelease", "updateEventEndTimestamp", "timestamp", "", "updateEventEndTimestamp$legacyroktsdk_devRelease", "(Ljava/lang/String;Ljava/lang/Long;)V", "updateEventStartTimestamp", "updateEventStartTimestamp$legacyroktsdk_devRelease", "Companion", "PlacementResult", "legacyroktsdk_devRelease"})
@SourceDebugExtension(value={"SMAP\nExecuteRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecuteRequestHandler.kt\ncom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,390:1\n540#2:391\n525#2,6:392\n1603#3,9:398\n1855#3:407\n1856#3:409\n1612#3:410\n1549#3:411\n1620#3,3:412\n1855#3,2:415\n1#4:408\n1#4:417\n*S KotlinDebug\n*F\n+ 1 ExecuteRequestHandler.kt\ncom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler\n*L\n116#1:391\n116#1:392,6\n219#1:398,9\n219#1:407\n219#1:409\n219#1:410\n238#1:411\n238#1:412,3\n287#1:415,2\n219#1:408\n*E\n"})
public final class ExecuteRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoktAPI api;
    @NotNull
    private final SchedulerProvider schedulers;
    @NotNull
    private final InitStatus initStatus;
    @NotNull
    private final ApplicationStateRepository applicationStateRepository;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Context context;
    @NotNull
    private final PreferenceUtil preferenceUtil;
    @NotNull
    private final DiagnosticsRequestHandler diagnosticsHandler;
    @NotNull
    private final EventRequestHandler eventRequestHandler;
    @NotNull
    private final SessionHandler sessionHandler;
    @NotNull
    private static final String noFunctional = "noFunctional";
    @NotNull
    private static final String noTargeting = "noTargeting";
    @NotNull
    private static final String doNotShareOrSell = "doNotShareOrSell";
    @NotNull
    private static final String gpcEnabled = "gpcEnabled";

    public ExecuteRequestHandler(@NotNull RoktAPI api, @NotNull SchedulerProvider schedulers, @NotNull InitStatus initStatus, @NotNull ApplicationStateRepository applicationStateRepository, @NotNull Logger logger, @NotNull Context context, @NotNull PreferenceUtil preferenceUtil, @NotNull DiagnosticsRequestHandler diagnosticsHandler, @NotNull EventRequestHandler eventRequestHandler, @NotNull SessionHandler sessionHandler) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)schedulers, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)initStatus, (String)"initStatus");
        Intrinsics.checkNotNullParameter((Object)applicationStateRepository, (String)"applicationStateRepository");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)preferenceUtil, (String)"preferenceUtil");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHandler, (String)"diagnosticsHandler");
        Intrinsics.checkNotNullParameter((Object)eventRequestHandler, (String)"eventRequestHandler");
        Intrinsics.checkNotNullParameter((Object)sessionHandler, (String)"sessionHandler");
        this.api = api;
        this.schedulers = schedulers;
        this.initStatus = initStatus;
        this.applicationStateRepository = applicationStateRepository;
        this.logger = logger;
        this.context = context;
        this.preferenceUtil = preferenceUtil;
        this.diagnosticsHandler = diagnosticsHandler;
        this.eventRequestHandler = eventRequestHandler;
        this.sessionHandler = sessionHandler;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"CheckResult"})
    public final void execute(@NotNull String viewName, @Nullable Map<String, String> attributes, @Nullable RoktLegacy.RoktLegacyCallback callback, @Nullable Map<String, ? extends WeakReference<WidgetLegacy>> placeholders, @Nullable RoktLegacy.RoktLegacyEventCallback eventCallback, @Nullable Result<WrappedPlacementExperienceModel> experienceModel) {
        Observable observable;
        Map map;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)viewName, (String)"viewName");
        if (!this.initStatus.getInitialised() || this.applicationStateRepository.getCurrentActivity().get() == null) {
            this.logExternal(R.string.rokt_err_init_not_completed);
            if (callback != null) {
                callback.onUnload(RoktLegacy.UnloadReasons.INIT_FAILED);
            }
            return;
        }
        long requestTimeoutMillis = this.preferenceUtil.getLong("clientTimeoutMilliseconds", 9000L);
        long launchDelayMillis = this.preferenceUtil.getLong("defaultLaunchDelayMilliseconds", 0L);
        String executeId2 = String.valueOf(System.currentTimeMillis());
        Object t = this.applicationStateRepository.getCurrentActivity().get();
        Intrinsics.checkNotNull(t);
        WeakReference weakReference = new WeakReference(t);
        Map map3 = attributes;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        this.applicationStateRepository.addExecuteStateBag(executeId2, new ExecuteStateBag(viewName, weakReference, map3, new WeakReference<RoktLegacy.RoktLegacyCallback>(callback), placeholders, 0L, 0L, 0, eventCallback, 224, null));
        long startTime = System.currentTimeMillis();
        PrivacyControl privacyControl = attributes != null ? this.getPrivacyControls(attributes) : null;
        Map map4 = attributes;
        if (map4 != null) {
            void $this$filterNotTo$iv$iv;
            Map $this$filterNot$iv = map4;
            boolean $i$f$filterNot = false;
            Map map5 = $this$filterNot$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                Object[] objectArray = new String[]{noFunctional, noTargeting, doNotShareOrSell, gpcEnabled};
                if (CollectionsKt.listOf((Object[])objectArray).contains(it.getKey())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = map = null;
        }
        if (map2 == null) {
            map = MapsKt.emptyMap();
        }
        Map filterAttributes = map;
        Ref.ObjectRef originalEventStartTimestamp = new Ref.ObjectRef();
        Ref.ObjectRef originalEventEndTimestamp = new Ref.ObjectRef();
        if (experienceModel != null) {
            Observable observable2;
            Result<WrappedPlacementExperienceModel> result = experienceModel;
            if (result instanceof Result.Success) {
                originalEventStartTimestamp.element = ((WrappedPlacementExperienceModel)((Result.Success)experienceModel).getData()).getSignalLoadStartTimestamp();
                originalEventEndTimestamp.element = ((WrappedPlacementExperienceModel)((Result.Success)experienceModel).getData()).getSignalLoadCompleteTimestamp();
                observable2 = Observable.just((Object)RoktLegacyMapperKt.toLegacyPlacement(((WrappedPlacementExperienceModel)((Result.Success)experienceModel).getData()).getPlacementExperienceModel()));
            } else if (result instanceof Result.Error) {
                observable2 = Observable.error((Throwable)((Result.Error)experienceModel).getException());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Observable observable3 = observable2;
            Intrinsics.checkNotNullExpressionValue((Object)observable3, (String)"{\n            when (expe\u2026)\n            }\n        }");
            observable = observable3;
        } else {
            observable = this.api.getPlacements(this.sessionHandler.getValidSession(), new PlacementRequest(viewName, filterAttributes, privacyControl));
        }
        Observable response = observable;
        response.subscribeOn(this.schedulers.io()).timeout(requestTimeoutMillis, TimeUnit.MILLISECONDS).doOnNext(arg_0 -> ExecuteRequestHandler.execute$lambda$1((Function1)new Function1<PlacementResponse, Unit>(this, executeId2, (Ref.ObjectRef<Long>)originalEventEndTimestamp, (Ref.ObjectRef<Long>)originalEventStartTimestamp){
            final /* synthetic */ ExecuteRequestHandler this$0;
            final /* synthetic */ String $executeId;
            final /* synthetic */ Ref.ObjectRef<Long> $originalEventEndTimestamp;
            final /* synthetic */ Ref.ObjectRef<Long> $originalEventStartTimestamp;
            {
                this.this$0 = $receiver;
                this.$executeId = $executeId;
                this.$originalEventEndTimestamp = $originalEventEndTimestamp;
                this.$originalEventStartTimestamp = $originalEventStartTimestamp;
                super(1);
            }

            public final void invoke(PlacementResponse it) {
                this.this$0.updateEventEndTimestamp$legacyroktsdk_devRelease(this.$executeId, (Long)this.$originalEventEndTimestamp.element);
                this.this$0.updateEventStartTimestamp$legacyroktsdk_devRelease(this.$executeId, (Long)this.$originalEventStartTimestamp.element);
            }
        }, arg_0)).map(arg_0 -> ExecuteRequestHandler.execute$lambda$2((Function1)new Function1<PlacementResponse, PlacementResult>((Object)this){

            @NotNull
            public final PlacementResult invoke(@NotNull PlacementResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ExecuteRequestHandler)this.receiver).transformPlacementResponse$legacyroktsdk_devRelease(p0);
            }
        }, arg_0)).delay(arg_0 -> ExecuteRequestHandler.execute$lambda$3((Function1)new Function1<PlacementResult, ObservableSource<Long>>(startTime, launchDelayMillis){
            final /* synthetic */ long $startTime;
            final /* synthetic */ long $launchDelayMillis;
            {
                this.$startTime = $startTime;
                this.$launchDelayMillis = $launchDelayMillis;
                super(1);
            }

            public final ObservableSource<Long> invoke(@NotNull PlacementResult placementResult) {
                Intrinsics.checkNotNullParameter((Object)placementResult, (String)"placementResult");
                long fireDate = this.$startTime + this.$launchDelayMillis;
                long timeDifference = fireDate - System.currentTimeMillis();
                long calculatedDelayValue = 0L;
                if (placementResult instanceof PlacementResult.Success) {
                    long l = ((PlacementResult.Success)placementResult).getLaunchDelayMillis();
                    long l2 = this.$launchDelayMillis;
                    long it = l;
                    boolean bl = false;
                    long elapsedTime = l2 - timeDifference;
                    if (timeDifference < 0L) {
                        elapsedTime = l2 + timeDifference * (long)-1;
                    }
                    if (it > elapsedTime) {
                        calculatedDelayValue = it - elapsedTime;
                    }
                }
                return (ObservableSource)Observable.timer((long)calculatedDelayValue, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }, arg_0)).retry((arg_0, arg_1) -> ExecuteRequestHandler.execute$lambda$4(execute.4.INSTANCE, arg_0, arg_1)).observeOn(this.schedulers.ui()).subscribe(arg_0 -> ExecuteRequestHandler.execute$lambda$5((Function1)new Function1<PlacementResult, Unit>(this, executeId2, eventCallback){
            final /* synthetic */ ExecuteRequestHandler this$0;
            final /* synthetic */ String $executeId;
            final /* synthetic */ RoktLegacy.RoktLegacyEventCallback $eventCallback;
            {
                this.this$0 = $receiver;
                this.$executeId = $executeId;
                this.$eventCallback = $eventCallback;
                super(1);
            }

            public final void invoke(PlacementResult it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.this$0.processWidgetResponse$legacyroktsdk_devRelease(this.$executeId, it, this.$eventCallback);
            }
        }, arg_0), arg_0 -> ExecuteRequestHandler.execute$lambda$6((Function1)new Function1<Throwable, Unit>(this, executeId2, callback){
            final /* synthetic */ ExecuteRequestHandler this$0;
            final /* synthetic */ String $executeId;
            final /* synthetic */ RoktLegacy.RoktLegacyCallback $callback;
            {
                this.this$0 = $receiver;
                this.$executeId = $executeId;
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(Throwable it) {
                block2: {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    ExecuteRequestHandler.postDiagnostics$default(this.this$0, UtilsKt.toDiagnosticsString(it), null, 2, null);
                    RoktLegacy.RoktLegacyCallback roktLegacyCallback = ExecuteRequestHandler.access$getCallback(this.this$0, this.$executeId);
                    if (roktLegacyCallback != null) {
                        roktLegacyCallback.onShouldHideLoadingIndicator();
                    }
                    RoktLegacy.RoktLegacyCallback roktLegacyCallback2 = ExecuteRequestHandler.access$getCallback(this.this$0, this.$executeId);
                    if (roktLegacyCallback2 != null) {
                        roktLegacyCallback2.onUnload(RoktLegacy.UnloadReasons.UNKNOWN);
                    }
                    RoktLegacy.RoktLegacyCallback roktLegacyCallback3 = this.$callback;
                    if (roktLegacyCallback3 == null) break block2;
                    RoktLegacy.RoktLegacyCallback.DefaultImpls.onPlacementFailure$default(roktLegacyCallback3, null, 1, null);
                }
            }
        }, arg_0));
    }

    public static /* synthetic */ void execute$default(ExecuteRequestHandler executeRequestHandler, String string2, Map map, RoktLegacy.RoktLegacyCallback roktLegacyCallback, Map map2, RoktLegacy.RoktLegacyEventCallback roktLegacyEventCallback, Result result, int n, Object object) {
        if ((n & 0x20) != 0) {
            result = null;
        }
        executeRequestHandler.execute(string2, map, roktLegacyCallback, map2, roktLegacyEventCallback, (Result<WrappedPlacementExperienceModel>)result);
    }

    private final PrivacyControl getPrivacyControls(Map<String, String> attributes) {
        PrivacyControl privacyControl;
        Object[] objectArray = new String[]{noFunctional, noTargeting, doNotShareOrSell, gpcEnabled};
        Set intersectionAttributes = CollectionsKt.intersect((Iterable)CollectionsKt.listOf((Object[])objectArray), (Iterable)attributes.keySet());
        if (!((Collection)intersectionAttributes).isEmpty()) {
            String string2 = attributes.get(noFunctional);
            String string3 = attributes.get(noTargeting);
            String string4 = attributes.get(doNotShareOrSell);
            String string5 = attributes.get(gpcEnabled);
            privacyControl = new PrivacyControl(string2 != null ? StringsKt.toBooleanStrictOrNull((String)string2) : null, string3 != null ? StringsKt.toBooleanStrictOrNull((String)string3) : null, string4 != null ? StringsKt.toBooleanStrictOrNull((String)string4) : null, string5 != null ? StringsKt.toBooleanStrictOrNull((String)string5) : null);
        } else {
            privacyControl = null;
        }
        return privacyControl;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=2)
    @NotNull
    public final PlacementResult transformPlacementResponse$legacyroktsdk_devRelease(@NotNull PlacementResponse response) {
        PlacementResult placementResult;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.getPlacements().isEmpty()) {
            placementResult = new PlacementResult.Empty(response.getSessionId(), response.getToken(), response.getPlacementContext().getPageInstanceGuid(), response.getPlacementContext().getToken());
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = response.getPlacements();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PlacementViewData it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Placement it = (Placement)element$iv$iv;
                boolean bl2 = false;
                if (new PlacementTransformer(it, response.getSessionId(), response.getToken(), response.getPlacementContext().getPageInstanceGuid(), this.diagnosticsHandler).transformPlacement() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List placementViewDataList = (List)destination$iv$iv;
            if (placementViewDataList.isEmpty()) {
                placementResult = new PlacementResult.ParseFailed(response.getSessionId(), response.getToken(), response.getPlacementContext().getPageInstanceGuid(), response.getPlacementContext().getToken());
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = placementViewDataList;
                boolean $i$f$map = false;
                $this$forEach$iv$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PlacementViewData bl = (PlacementViewData)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(it.getLaunchDelayMilliseconds());
                }
                Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
                long launchDelayMillis = l != null ? l : 0L;
                placementResult = new PlacementResult.Success(placementViewDataList, response.getSessionId(), response.getToken(), response.getPlacementContext().getPageInstanceGuid(), response.getPlacementContext().getToken(), launchDelayMillis);
            }
        }
        return placementResult;
    }

    @VisibleForTesting(otherwise=2)
    public final void processWidgetResponse$legacyroktsdk_devRelease(@NotNull String executeId2, @NotNull PlacementResult placementResult, @Nullable RoktLegacy.RoktLegacyEventCallback eventCallback) {
        Intrinsics.checkNotNullParameter((Object)executeId2, (String)"executeId");
        Intrinsics.checkNotNullParameter((Object)placementResult, (String)"placementResult");
        RoktLegacy.RoktLegacyCallback roktLegacyCallback = this.getCallback(executeId2);
        if (roktLegacyCallback != null) {
            roktLegacyCallback.onShouldHideLoadingIndicator();
        }
        ExecuteStateBag executeStateBag = this.applicationStateRepository.getExecuteStateBag(executeId2);
        Long eventStartTimeStamp = executeStateBag != null ? Long.valueOf(executeStateBag.getEventStartTimestamp()) : null;
        ExecuteStateBag executeStateBag2 = this.applicationStateRepository.getExecuteStateBag(executeId2);
        Long eventEndTimeStamp = executeStateBag2 != null ? Long.valueOf(executeStateBag2.getEventEndTimeStamp()) : null;
        String sessionId = placementResult.getSessionId();
        String token = placementResult.getPageInstanceToken();
        String parentGuid = placementResult.getPageInstanceGuid();
        this.sessionHandler.updateSession(sessionId);
        EventRequestHandler.postEvent$default(this.eventRequestHandler, EventType.SignalInitialize, sessionId, parentGuid, token, eventStartTimeStamp, null, null, null, 224, null);
        EventRequestHandler.postEvent$default(this.eventRequestHandler, EventType.SignalLoadStart, sessionId, parentGuid, token, eventStartTimeStamp, null, null, null, 224, null);
        EventRequestHandler.postEvent$default(this.eventRequestHandler, EventType.SignalLoadComplete, sessionId, parentGuid, token, eventEndTimeStamp, null, null, null, 224, null);
        if (placementResult instanceof PlacementResult.ParseFailed) {
            this.postDiagnostics("Parsing failed!", sessionId);
            RoktLegacy.RoktLegacyCallback roktLegacyCallback2 = this.getCallback(executeId2);
            if (roktLegacyCallback2 != null) {
                roktLegacyCallback2.onUnload(RoktLegacy.UnloadReasons.NO_OFFERS);
            }
            RoktLegacy.RoktLegacyCallback roktLegacyCallback3 = this.getCallback(executeId2);
            if (roktLegacyCallback3 != null) {
                RoktLegacy.RoktLegacyCallback.DefaultImpls.onPlacementFailure$default(roktLegacyCallback3, null, 1, null);
            }
            this.logExternal(R.string.rokt_err_no_offers);
            return;
        }
        if (placementResult instanceof PlacementResult.Empty) {
            RoktLegacy.RoktLegacyCallback roktLegacyCallback4 = this.getCallback(executeId2);
            if (roktLegacyCallback4 != null) {
                roktLegacyCallback4.onUnload(RoktLegacy.UnloadReasons.NO_WIDGET);
            }
            RoktLegacy.RoktLegacyCallback roktLegacyCallback5 = this.getCallback(executeId2);
            if (roktLegacyCallback5 != null) {
                RoktLegacy.RoktLegacyCallback.DefaultImpls.onPlacementFailure$default(roktLegacyCallback5, null, 1, null);
            }
            this.logExternal(R.string.rokt_err_no_widget);
            return;
        }
        PlacementViewCallBack viewCallback = this.getPlacementViewCallBack$legacyroktsdk_devRelease(executeId2);
        Iterable $this$forEach$iv = ((PlacementResult.Success)placementResult).getPlacementList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlacementViewData placement = (PlacementViewData)element$iv;
            boolean bl = false;
            this.applicationStateRepository.addPlacementStateBag(placement.getInstanceGuid(), new PlacementStateBag(placement, viewCallback, eventCallback, eventStartTimeStamp, eventEndTimeStamp, null, 32, null));
            EventRequestHandler.postEvent$default(this.eventRequestHandler, EventType.SignalLoadStart, sessionId, placement.getInstanceGuid(), placement.getToken(), null, null, null, null, 240, null);
            PlacementViewData placementViewData = placement;
            if (placementViewData instanceof PlacementViewData.Overlay) {
                this.handleLightBoxWidget(placement.getInstanceGuid(), executeId2);
                continue;
            }
            if (placementViewData instanceof PlacementViewData.LightBox) {
                this.handleFullscreenWidget(placement.getInstanceGuid(), executeId2);
                continue;
            }
            if (placementViewData instanceof PlacementViewData.Embedded) {
                this.handleEmbeddedWidget(executeId2, placement.getInstanceGuid(), (PlacementViewData.Embedded)placement);
                continue;
            }
            if (!(placementViewData instanceof PlacementViewData.BottomSheet)) continue;
            this.handleBottomSheetWidget(placement.getInstanceGuid(), executeId2);
        }
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final PlacementViewCallBack getPlacementViewCallBack$legacyroktsdk_devRelease(@NotNull String executeId2) {
        Intrinsics.checkNotNullParameter((Object)executeId2, (String)"executeId");
        return new PlacementViewCallBack(this, executeId2){
            final /* synthetic */ ExecuteRequestHandler this$0;
            final /* synthetic */ String $executeId;
            {
                this.this$0 = $receiver;
                this.$executeId = $executeId;
            }

            public void onLoad() {
                block2: {
                    ExecuteStateBag executeStateBag = ExecuteRequestHandler.access$getApplicationStateRepository$p(this.this$0).getExecuteStateBag(this.$executeId);
                    boolean bl = executeStateBag != null ? executeStateBag.getLoadedPlacements() == 0 : false;
                    if (bl) {
                        RoktLegacy.RoktLegacyCallback roktLegacyCallback = ExecuteRequestHandler.access$getCallback(this.this$0, this.$executeId);
                        if (roktLegacyCallback != null) {
                            roktLegacyCallback.onLoad();
                        }
                    }
                    ExecuteStateBag executeStateBag2 = ExecuteRequestHandler.access$getApplicationStateRepository$p(this.this$0).getExecuteStateBag(this.$executeId);
                    if (executeStateBag2 == null) break block2;
                    ExecuteStateBag it = executeStateBag2;
                    boolean bl2 = false;
                    int n = it.getLoadedPlacements();
                    it.setLoadedPlacements(n + 1);
                }
            }

            public void onUnload() {
                block2: {
                    ExecuteStateBag executeStateBag = ExecuteRequestHandler.access$getApplicationStateRepository$p(this.this$0).getExecuteStateBag(this.$executeId);
                    if (executeStateBag != null) {
                        ExecuteStateBag it = executeStateBag;
                        boolean bl = false;
                        int n = it.getLoadedPlacements();
                        it.setLoadedPlacements(n + -1);
                    }
                    ExecuteStateBag executeStateBag2 = ExecuteRequestHandler.access$getApplicationStateRepository$p(this.this$0).getExecuteStateBag(this.$executeId);
                    boolean bl = executeStateBag2 != null ? executeStateBag2.getLoadedPlacements() == 0 : false;
                    if (!bl) break block2;
                    RoktLegacy.RoktLegacyCallback roktLegacyCallback = ExecuteRequestHandler.access$getCallback(this.this$0, this.$executeId);
                    if (roktLegacyCallback != null) {
                        roktLegacyCallback.onUnload(RoktLegacy.UnloadReasons.FINISHED);
                    }
                }
            }
        };
    }

    @VisibleForTesting(otherwise=2)
    public final void updateEventStartTimestamp$legacyroktsdk_devRelease(@NotNull String executeId2, @Nullable Long timestamp) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)executeId2, (String)"executeId");
            Long l = timestamp;
            if (l == null) break block1;
            long it = ((Number)l).longValue();
            boolean bl = false;
            ExecuteStateBag executeStateBag = this.applicationStateRepository.getExecuteStateBag(executeId2);
            if (executeStateBag != null) {
                executeStateBag.setEventStartTimestamp(it);
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    public final void updateEventEndTimestamp$legacyroktsdk_devRelease(@NotNull String executeId2, @Nullable Long timestamp) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)executeId2, (String)"executeId");
            Long l = timestamp;
            if (l == null) break block1;
            long it = ((Number)l).longValue();
            boolean bl = false;
            ExecuteStateBag executeStateBag = this.applicationStateRepository.getExecuteStateBag(executeId2);
            if (executeStateBag != null) {
                executeStateBag.setEventEndTimeStamp(it);
            }
        }
    }

    private final void handleFullscreenWidget(String placementId, String executeId2) {
        block0: {
            Activity activity = (Activity)this.applicationStateRepository.getCurrentActivity().get();
            if (activity == null) break block0;
            Activity it = activity;
            boolean bl = false;
            FullScreenActivity.Companion.startActivity(it, placementId, executeId2);
        }
    }

    private final void handleEmbeddedWidget(String executeId2, String placementId, PlacementViewData.Embedded placement) {
        Map<String, WeakReference<WidgetLegacy>> map;
        WeakReference<WidgetLegacy> targetView;
        ExecuteStateBag executeStateBag = this.applicationStateRepository.getExecuteStateBag(executeId2);
        WeakReference<WidgetLegacy> weakReference = targetView = executeStateBag != null && (map = executeStateBag.getPlaceholders()) != null ? map.get(placement.getTargetElement()) : null;
        if (targetView != null) {
            WidgetLegacy widgetLegacy = (WidgetLegacy)((Object)targetView.get());
            if (widgetLegacy != null) {
                widgetLegacy.populateWidget$legacyroktsdk_devRelease(placementId, executeId2);
            }
        } else {
            RoktLegacy.RoktLegacyCallback roktLegacyCallback = this.getCallback(executeId2);
            if (roktLegacyCallback != null) {
                roktLegacyCallback.onUnload(RoktLegacy.UnloadReasons.NO_OFFERS);
            }
            RoktLegacy.RoktLegacyCallback roktLegacyCallback2 = this.getCallback(executeId2);
            if (roktLegacyCallback2 != null) {
                roktLegacyCallback2.onPlacementFailure(placementId);
            }
            this.logExternal(R.string.rokt_err_no_matching_placeholder);
            this.postDiagnostics("No matching embedded placeholder", placement.getSessionId());
        }
    }

    private final void handleLightBoxWidget(String placementId, String executeId2) {
        block0: {
            Activity activity = (Activity)this.applicationStateRepository.getCurrentActivity().get();
            if (activity == null) break block0;
            Activity it = activity;
            boolean bl = false;
            LightBoxActivity.Companion.startActivity(it, placementId, executeId2);
        }
    }

    private final void handleBottomSheetWidget(String placementId, String executeId2) {
        block0: {
            Activity activity = (Activity)this.applicationStateRepository.getCurrentActivity().get();
            if (activity == null) break block0;
            Activity it = activity;
            boolean bl = false;
            BottomSheetActivity.Companion.startActivity(it, placementId, executeId2);
        }
    }

    private final void postDiagnostics(String callStack, String sessionId) {
        DiagnosticsRequestHandler.postDiagnostics$default(this.diagnosticsHandler, Constants.DiagnosticsErrorType.EXECUTE, callStack, null, sessionId, null, 20, null);
    }

    static /* synthetic */ void postDiagnostics$default(ExecuteRequestHandler executeRequestHandler, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        executeRequestHandler.postDiagnostics(string2, string3);
    }

    private final void logExternal(@StringRes int resId) {
        String string2 = this.context.getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(resId)");
        this.logger.log("ROKTSDK", string2);
    }

    private final RoktLegacy.RoktLegacyCallback getCallback(String executeId2) {
        Object object = this.applicationStateRepository.getExecuteStateBag(executeId2);
        return object != null && (object = ((ExecuteStateBag)object).getCallback()) != null ? (RoktLegacy.RoktLegacyCallback)((Reference)object).get() : null;
    }

    private static final void execute$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final PlacementResult execute$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PlacementResult)$tmp0.invoke(p0);
    }

    private static final ObservableSource execute$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ObservableSource)$tmp0.invoke(p0);
    }

    private static final boolean execute$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final void execute$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void execute$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ RoktLegacy.RoktLegacyCallback access$getCallback(ExecuteRequestHandler $this, String executeId2) {
        return $this.getCallback(executeId2);
    }

    public static final /* synthetic */ ApplicationStateRepository access$getApplicationStateRepository$p(ExecuteRequestHandler $this) {
        return $this.applicationStateRepository;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$Companion;", "", "()V", "doNotShareOrSell", "", "gpcEnabled", "noFunctional", "noTargeting", "legacyroktsdk_devRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult;", "", "sessionId", "", "token", "pageInstanceGuid", "pageInstanceToken", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPageInstanceGuid", "()Ljava/lang/String;", "getPageInstanceToken", "getSessionId", "getToken", "Empty", "ParseFailed", "Success", "Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult$Empty;", "Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult$ParseFailed;", "Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult$Success;", "legacyroktsdk_devRelease"})
    public static abstract class PlacementResult {
        @NotNull
        private final String sessionId;
        @NotNull
        private final String token;
        @NotNull
        private final String pageInstanceGuid;
        @NotNull
        private final String pageInstanceToken;

        private PlacementResult(String sessionId, String token, String pageInstanceGuid, String pageInstanceToken) {
            this.sessionId = sessionId;
            this.token = token;
            this.pageInstanceGuid = pageInstanceGuid;
            this.pageInstanceToken = pageInstanceToken;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        @NotNull
        public final String getPageInstanceGuid() {
            return this.pageInstanceGuid;
        }

        @NotNull
        public final String getPageInstanceToken() {
            return this.pageInstanceToken;
        }

        public /* synthetic */ PlacementResult(String sessionId, String token, String pageInstanceGuid, String pageInstanceToken, DefaultConstructorMarker $constructor_marker) {
            this(sessionId, token, pageInstanceGuid, pageInstanceToken);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult$Empty;", "Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult;", "sessionId", "", "token", "pageInstanceGuid", "pageInstanceToken", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "legacyroktsdk_devRelease"})
        public static final class Empty
        extends PlacementResult {
            public Empty(@NotNull String sessionId, @NotNull String token, @NotNull String pageInstanceGuid, @NotNull String pageInstanceToken) {
                Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                Intrinsics.checkNotNullParameter((Object)pageInstanceGuid, (String)"pageInstanceGuid");
                Intrinsics.checkNotNullParameter((Object)pageInstanceToken, (String)"pageInstanceToken");
                super(sessionId, token, pageInstanceGuid, pageInstanceToken, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult$ParseFailed;", "Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult;", "sessionId", "", "token", "pageInstanceGuid", "pageInstanceToken", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "legacyroktsdk_devRelease"})
        public static final class ParseFailed
        extends PlacementResult {
            public ParseFailed(@NotNull String sessionId, @NotNull String token, @NotNull String pageInstanceGuid, @NotNull String pageInstanceToken) {
                Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                Intrinsics.checkNotNullParameter((Object)pageInstanceGuid, (String)"pageInstanceGuid");
                Intrinsics.checkNotNullParameter((Object)pageInstanceToken, (String)"pageInstanceToken");
                super(sessionId, token, pageInstanceGuid, pageInstanceToken, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult$Success;", "Lcom/rokt/roktsdk/internal/requestutils/ExecuteRequestHandler$PlacementResult;", "placementList", "", "Lcom/rokt/roktsdk/internal/viewdata/PlacementViewData;", "sessionId", "", "token", "pageInstanceGuid", "pageInstanceToken", "launchDelayMillis", "", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)V", "getLaunchDelayMillis", "()J", "getPlacementList", "()Ljava/util/List;", "legacyroktsdk_devRelease"})
        public static final class Success
        extends PlacementResult {
            @NotNull
            private final List<PlacementViewData> placementList;
            private final long launchDelayMillis;

            public Success(@NotNull List<? extends PlacementViewData> placementList, @NotNull String sessionId, @NotNull String token, @NotNull String pageInstanceGuid, @NotNull String pageInstanceToken, long launchDelayMillis) {
                Intrinsics.checkNotNullParameter(placementList, (String)"placementList");
                Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                Intrinsics.checkNotNullParameter((Object)pageInstanceGuid, (String)"pageInstanceGuid");
                Intrinsics.checkNotNullParameter((Object)pageInstanceToken, (String)"pageInstanceToken");
                super(sessionId, token, pageInstanceGuid, pageInstanceToken, null);
                this.placementList = placementList;
                this.launchDelayMillis = launchDelayMillis;
            }

            @NotNull
            public final List<PlacementViewData> getPlacementList() {
                return this.placementList;
            }

            public final long getLaunchDelayMillis() {
                return this.launchDelayMillis;
            }
        }
    }
}

