/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.requestutils;

import android.annotation.SuppressLint;
import android.content.Context;
import com.rokt.legacy.roktsdk.R;
import com.rokt.roktsdk.internal.api.RoktAPI;
import com.rokt.roktsdk.internal.api.responses.init.InitResponse;
import com.rokt.roktsdk.internal.requestutils.DiagnosticsRequestHandler;
import com.rokt.roktsdk.internal.requestutils.InitRequestHandler;
import com.rokt.roktsdk.internal.requestutils.InitStatus;
import com.rokt.roktsdk.internal.requestutils.SchedulerProvider;
import com.rokt.roktsdk.internal.util.Constants;
import com.rokt.roktsdk.internal.util.FontManager;
import com.rokt.roktsdk.internal.util.Logger;
import com.rokt.roktsdk.internal.util.PreferenceUtil;
import com.rokt.roktsdk.internal.util.UtilsKt;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.plugins.RxJavaPlugins;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/InitRequestHandler;", "", "api", "Lcom/rokt/roktsdk/internal/api/RoktAPI;", "schedulers", "Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;", "preference", "Lcom/rokt/roktsdk/internal/util/PreferenceUtil;", "logger", "Lcom/rokt/roktsdk/internal/util/Logger;", "context", "Landroid/content/Context;", "diagnosticsRequestHandler", "Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;", "fontManager", "Lcom/rokt/roktsdk/internal/util/FontManager;", "initStatus", "Lcom/rokt/roktsdk/internal/requestutils/InitStatus;", "(Lcom/rokt/roktsdk/internal/api/RoktAPI;Lcom/rokt/roktsdk/internal/requestutils/SchedulerProvider;Lcom/rokt/roktsdk/internal/util/PreferenceUtil;Lcom/rokt/roktsdk/internal/util/Logger;Landroid/content/Context;Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;Lcom/rokt/roktsdk/internal/util/FontManager;Lcom/rokt/roktsdk/internal/requestutils/InitStatus;)V", "checkHost", "", "init", "", "initRxErrorHandler", "Companion", "legacyroktsdk_devRelease"})
public final class InitRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoktAPI api;
    @NotNull
    private final SchedulerProvider schedulers;
    @NotNull
    private final PreferenceUtil preference;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Context context;
    @NotNull
    private final DiagnosticsRequestHandler diagnosticsRequestHandler;
    @NotNull
    private final FontManager fontManager;
    @NotNull
    private final InitStatus initStatus;
    @NotNull
    private static final String TAG = "ROKT_INIT";
    private static final long DEFAULT_SESSION_TIMEOUT = 1800000L;

    public InitRequestHandler(@NotNull RoktAPI api, @NotNull SchedulerProvider schedulers, @NotNull PreferenceUtil preference, @NotNull Logger logger, @NotNull Context context, @NotNull DiagnosticsRequestHandler diagnosticsRequestHandler, @NotNull FontManager fontManager, @NotNull InitStatus initStatus) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)schedulers, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)preference, (String)"preference");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)diagnosticsRequestHandler, (String)"diagnosticsRequestHandler");
        Intrinsics.checkNotNullParameter((Object)fontManager, (String)"fontManager");
        Intrinsics.checkNotNullParameter((Object)initStatus, (String)"initStatus");
        this.api = api;
        this.schedulers = schedulers;
        this.preference = preference;
        this.logger = logger;
        this.context = context;
        this.diagnosticsRequestHandler = diagnosticsRequestHandler;
        this.fontManager = fontManager;
        this.initStatus = initStatus;
    }

    @SuppressLint(value={"CheckResult"})
    public final void init() {
        this.logger.logInternal(TAG, "Init request");
        Observable.fromCallable(() -> InitRequestHandler.init$lambda$0(this)).observeOn(this.schedulers.io()).subscribeOn(this.schedulers.io()).filter(arg_0 -> InitRequestHandler.init$lambda$1(init.2.INSTANCE, arg_0)).subscribe(arg_0 -> InitRequestHandler.init$lambda$2((Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ InitRequestHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Boolean it) {
                InitRequestHandler.access$initRxErrorHandler(this.this$0);
                InitRequestHandler.access$getApi$p(this.this$0).init().timeout(9000L, TimeUnit.MILLISECONDS, InitRequestHandler.access$getSchedulers$p(this.this$0).computation()).retry((arg_0, arg_1) -> init.3.invoke$lambda$0(init.1.INSTANCE, arg_0, arg_1)).subscribeOn(InitRequestHandler.access$getSchedulers$p(this.this$0).io()).subscribe(arg_0 -> init.3.invoke$lambda$1((Function1)new Function1<InitResponse, Unit>(this.this$0){
                    final /* synthetic */ InitRequestHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(InitResponse it) {
                        InitRequestHandler.access$getPreference$p(this.this$0).saveLong("clientTimeoutMilliseconds", it.getClientTimeoutMilliseconds());
                        InitRequestHandler.access$getPreference$p(this.this$0).saveLong("defaultLaunchDelayMilliseconds", it.getDefaultLaunchDelayMilliseconds());
                        Integer n = it.getClientSessionTimeoutMilliseconds();
                        InitRequestHandler.access$getPreference$p(this.this$0).saveLong("defaultSessionTimeoutMilliseconds", n != null ? (long)n.intValue() : 1800000L);
                        InitRequestHandler.access$getInitStatus$p(this.this$0).setInitialised(true);
                        InitRequestHandler.access$getFontManager$p(this.this$0).downloadFonts(it.getFonts());
                    }
                }, arg_0), arg_0 -> init.3.invoke$lambda$2((Function1)new Function1<Throwable, Unit>(this.this$0){
                    final /* synthetic */ InitRequestHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(Throwable it) {
                        InitRequestHandler.access$getInitStatus$p(this.this$0).setInitialised(false);
                        DiagnosticsRequestHandler diagnosticsRequestHandler = InitRequestHandler.access$getDiagnosticsRequestHandler$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        DiagnosticsRequestHandler.postDiagnostics$default(diagnosticsRequestHandler, Constants.DiagnosticsErrorType.INIT, UtilsKt.toDiagnosticsString(it), null, null, null, 28, null);
                        Logger logger = InitRequestHandler.access$getLogger$p(this.this$0);
                        String string2 = InitRequestHandler.access$getContext$p(this.this$0).getString(R.string.rokt_err_init_failed);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.rokt_err_init_failed)");
                        logger.log("ROKTSDK", string2);
                    }
                }, arg_0));
            }

            private static final boolean invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0, p1);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private final void initRxErrorHandler() {
        Consumer errorHandler2 = RxJavaPlugins.getErrorHandler();
        if (errorHandler2 == null) {
            RxJavaPlugins.setErrorHandler(arg_0 -> InitRequestHandler.initRxErrorHandler$lambda$3(initRxErrorHandler.1.INSTANCE, arg_0));
        }
    }

    private final boolean checkHost() {
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName("mobile-api.rokt.com");
            Intrinsics.checkNotNullExpressionValue((Object)inetAddressArray, (String)"getAllByName(Constants.ROKT_HOST)");
            List host = ArraysKt.toList((Object[])inetAddressArray);
            this.logger.logInternal(TAG, host.toString());
        }
        catch (UnknownHostException e) {
            this.logger.logInternal(TAG, e.toString());
            return false;
        }
        return true;
    }

    private static final Boolean init$lambda$0(InitRequestHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.checkHost();
    }

    private static final boolean init$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void init$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void initRxErrorHandler$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$initRxErrorHandler(InitRequestHandler $this) {
        $this.initRxErrorHandler();
    }

    public static final /* synthetic */ RoktAPI access$getApi$p(InitRequestHandler $this) {
        return $this.api;
    }

    public static final /* synthetic */ SchedulerProvider access$getSchedulers$p(InitRequestHandler $this) {
        return $this.schedulers;
    }

    public static final /* synthetic */ PreferenceUtil access$getPreference$p(InitRequestHandler $this) {
        return $this.preference;
    }

    public static final /* synthetic */ InitStatus access$getInitStatus$p(InitRequestHandler $this) {
        return $this.initStatus;
    }

    public static final /* synthetic */ FontManager access$getFontManager$p(InitRequestHandler $this) {
        return $this.fontManager;
    }

    public static final /* synthetic */ DiagnosticsRequestHandler access$getDiagnosticsRequestHandler$p(InitRequestHandler $this) {
        return $this.diagnosticsRequestHandler;
    }

    public static final /* synthetic */ Logger access$getLogger$p(InitRequestHandler $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Context access$getContext$p(InitRequestHandler $this) {
        return $this.context;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/InitRequestHandler$Companion;", "", "()V", "DEFAULT_SESSION_TIMEOUT", "", "TAG", "", "legacyroktsdk_devRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

