/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.util;

import android.content.Context;
import com.rokt.roktsdk.internal.util.AssetUtilKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/rokt/roktsdk/internal/util/AssetUtil;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "deletePrivateFile", "", "name", "", "getString", "assetName", "isFileExists", "", "saveFilePrivate", "input", "Ljava/io/InputStream;", "legacyroktsdk_devRelease"})
public final class AssetUtil {
    @NotNull
    private final Context context;

    public AssetUtil(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getString(@NotNull String assetName) {
        Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
        InputStream inputStream = this.context.getAssets().open(assetName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(assetName)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveFilePrivate(@NotNull String name, @NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            Closeable closeable = new FileOutputStream(AssetUtilKt.getFilePrivate(this.context, name));
            Throwable throwable = null;
            try {
                long l;
                FileOutputStream outStream = (FileOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = input;
                Throwable throwable2 = null;
                try {
                    InputStream inStream = (InputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo((InputStream)inStream, (OutputStream)outStream, (int)1024);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public final void deletePrivateFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AssetUtilKt.getFilePrivate(this.context, name).delete();
    }

    public final boolean isFileExists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return AssetUtilKt.getFilePrivate(this.context, name).exists();
    }
}

