/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.rokt.roktsdk.internal.customtabs.CustomTabsHelper;
import com.rokt.roktsdk.internal.overlay.OverlayActivity;
import com.rokt.roktsdk.internal.util.Constants;
import com.rokt.roktsdk.internal.util.Logger;
import com.rokt.roktsdk.internal.util.UtilsKt;
import com.rokt.roktsdk.internal.viewmodel.LinkViewModelKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\fJ-\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00072\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012H\u0000\u00a2\u0006\u0002\b\u0013J(\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00072\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012H\u0002J\u0006\u0010\u0016\u001a\u00020\u0011J(\u0010\u0017\u001a\u00020\u00112 \u0010\u0018\u001a\u001c\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u00060\u001bj\u0002`\u001c\u0012\u0004\u0012\u00020\u00110\u0019j\u0002`\u001dJ&\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00072\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012J \u0010 \u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00072\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u0012J(\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/rokt/roktsdk/internal/util/NavigationManager;", "", "activity", "Landroid/app/Activity;", "logger", "Lcom/rokt/roktsdk/internal/util/Logger;", "executeId", "", "(Landroid/app/Activity;Lcom/rokt/roktsdk/internal/util/Logger;Ljava/lang/String;)V", "canOpenInExternalApp", "", "uriString", "canOpenInExternalApp$legacyroktsdk_devRelease", "didHandleDeepLink", "url", "callingActivityResumedListener", "Lkotlin/Function0;", "", "Lcom/rokt/roktsdk/internal/util/CallingActivityResumedListener;", "didHandleDeepLink$legacyroktsdk_devRelease", "onDeepLinkClicked", "deepLink", "onNavigateBackToPartnerApp", "onOfferFinished", "errorHandler", "Lkotlin/Function2;", "Lcom/rokt/roktsdk/internal/util/Constants$DiagnosticsErrorType;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lcom/rokt/roktsdk/internal/util/ErrorHandler;", "onWebBrowserLinkClicked", "link", "onWebLinkClicked", "showUrlInExternalBrowser", "linkIntent", "Landroid/content/Intent;", "Companion", "legacyroktsdk_devRelease"})
public final class NavigationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String executeId;
    @NotNull
    private static final String TAG = "NavigationManager";

    public NavigationManager(@NotNull Activity activity, @NotNull Logger logger, @NotNull String executeId2) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)executeId2, (String)"executeId");
        this.activity = activity;
        this.logger = logger;
        this.executeId = executeId2;
    }

    public final void onOfferFinished(@NotNull Function2<? super Constants.DiagnosticsErrorType, ? super Exception, Unit> errorHandler2) {
        Intrinsics.checkNotNullParameter(errorHandler2, (String)"errorHandler");
        if (this.activity instanceof OverlayActivity) {
            this.activity.finish();
        } else {
            errorHandler2.invoke((Object)Constants.DiagnosticsErrorType.VIEW, (Object)new Exception("NavigationManager:onOfferFinished"));
            this.activity.finish();
        }
    }

    public final void onNavigateBackToPartnerApp() {
        if (this.activity instanceof OverlayActivity) {
            ((OverlayActivity)this.activity).onNavigateBackToPartnerApp$legacyroktsdk_devRelease();
        }
    }

    public final boolean onWebBrowserLinkClicked(@NotNull String link, @Nullable Function0<Unit> callingActivityResumedListener) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intent linkIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        return this.showUrlInExternalBrowser(linkIntent, callingActivityResumedListener);
    }

    public static /* synthetic */ boolean onWebBrowserLinkClicked$default(NavigationManager navigationManager, String string2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        return navigationManager.onWebBrowserLinkClicked(string2, (Function0<Unit>)function0);
    }

    public final boolean onWebLinkClicked(@NotNull String link, @NotNull Function0<Unit> callingActivityResumedListener) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter(callingActivityResumedListener, (String)"callingActivityResumedListener");
        Application.ActivityLifecycleCallbacks callbacks = null;
        callbacks = new Application.ActivityLifecycleCallbacks(this, callingActivityResumedListener){
            final /* synthetic */ NavigationManager this$0;
            final /* synthetic */ Function0<Unit> $callingActivityResumedListener;
            {
                this.this$0 = $receiver;
                this.$callingActivityResumedListener = $callingActivityResumedListener;
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle p1) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle p1) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                if (Intrinsics.areEqual((Object)activity, (Object)NavigationManager.access$getActivity$p(this.this$0))) {
                    this.$callingActivityResumedListener.invoke();
                    activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                }
            }
        };
        this.activity.getApplication().registerActivityLifecycleCallbacks(callbacks);
        Context context = (Context)this.activity;
        Uri uri = Uri.parse((String)link);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(link)");
        if (CustomTabsHelper.INSTANCE.openCustomTab(context, uri)) {
            bl = true;
        } else {
            this.activity.getApplication().unregisterActivityLifecycleCallbacks(callbacks);
            bl = false;
        }
        return bl;
    }

    public final boolean canOpenInExternalApp$legacyroktsdk_devRelease(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uriString));
        return UtilsKt.canOpenInExternalApp(intent, (Context)this.activity);
    }

    public final boolean didHandleDeepLink$legacyroktsdk_devRelease(@NotNull String url, @Nullable Function0<Unit> callingActivityResumedListener) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (LinkViewModelKt.shouldOpenInExternalApp(url) && this.canOpenInExternalApp$legacyroktsdk_devRelease(url)) {
            this.onDeepLinkClicked(url, callingActivityResumedListener);
            return true;
        }
        String string2 = LinkViewModelKt.getFallBackUrl(url);
        if (string2 != null) {
            String fallbackUrl = string2;
            boolean bl = false;
            this.onDeepLinkClicked(fallbackUrl, callingActivityResumedListener);
            return true;
        }
        string2 = LinkViewModelKt.getPlayStoreUrlFromPackage(url);
        if (string2 != null) {
            String playStoreUrl = string2;
            boolean bl = false;
            this.onDeepLinkClicked(playStoreUrl, callingActivityResumedListener);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean didHandleDeepLink$legacyroktsdk_devRelease$default(NavigationManager navigationManager, String string2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        return navigationManager.didHandleDeepLink$legacyroktsdk_devRelease(string2, (Function0<Unit>)function0);
    }

    private final boolean onDeepLinkClicked(String deepLink, Function0<Unit> callingActivityResumedListener) {
        Intent deepLinkIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)deepLink));
        deepLinkIntent.addFlags(0x10000000);
        return this.showUrlInExternalBrowser(deepLinkIntent, callingActivityResumedListener);
    }

    static /* synthetic */ boolean onDeepLinkClicked$default(NavigationManager navigationManager, String string2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        return navigationManager.onDeepLinkClicked(string2, (Function0<Unit>)function0);
    }

    private final boolean showUrlInExternalBrowser(Intent linkIntent, Function0<Unit> callingActivityResumedListener) {
        try {
            if (UtilsKt.canOpenInExternalApp(linkIntent, (Context)this.activity)) {
                if (callingActivityResumedListener != null) {
                    this.activity.getApplication().registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(this, callingActivityResumedListener){
                        final /* synthetic */ NavigationManager this$0;
                        final /* synthetic */ Function0<Unit> $callingActivityResumedListener;
                        {
                            this.this$0 = $receiver;
                            this.$callingActivityResumedListener = $callingActivityResumedListener;
                        }

                        public void onActivityPaused(@NotNull Activity activity) {
                            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                        }

                        public void onActivityStarted(@NotNull Activity activity) {
                            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                        }

                        public void onActivityDestroyed(@NotNull Activity activity) {
                            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                        }

                        public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                            Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                        }

                        public void onActivityStopped(@NotNull Activity activity) {
                            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                        }

                        public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                        }

                        public void onActivityResumed(@NotNull Activity activity) {
                            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                            if (Intrinsics.areEqual((Object)activity, (Object)NavigationManager.access$getActivity$p(this.this$0))) {
                                this.$callingActivityResumedListener.invoke();
                                activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                            }
                        }
                    });
                }
                this.activity.startActivity(linkIntent);
                return true;
            }
        }
        catch (Exception e) {
            this.logger.logInternal(TAG, UtilsKt.toDiagnosticsString(e));
        }
        this.logger.logInternal(TAG, "Unable to open link " + linkIntent);
        return false;
    }

    static /* synthetic */ boolean showUrlInExternalBrowser$default(NavigationManager navigationManager, Intent intent, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        return navigationManager.showUrlInExternalBrowser(intent, (Function0<Unit>)function0);
    }

    public static final /* synthetic */ Activity access$getActivity$p(NavigationManager $this) {
        return $this.activity;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/rokt/roktsdk/internal/util/NavigationManager$Companion;", "", "()V", "TAG", "", "legacyroktsdk_devRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

