/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.viewmodel;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import androidx.lifecycle.MutableLiveData;
import com.rokt.roktsdk.internal.requestutils.DiagnosticsRequestHandler;
import com.rokt.roktsdk.internal.util.Constants;
import com.rokt.roktsdk.internal.util.NavigationManager;
import com.rokt.roktsdk.internal.util.UtilsKt;
import com.rokt.roktsdk.internal.viewdata.LinkLaunchViewData;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0007J\u0016\u0010!\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0007J\u000e\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0016J\u0016\u0010%\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0007R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/rokt/roktsdk/internal/viewmodel/LinkViewModel;", "", "navigationManager", "Lcom/rokt/roktsdk/internal/util/NavigationManager;", "diagnosticsRequestHandler", "Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;", "sessionId", "", "(Lcom/rokt/roktsdk/internal/util/NavigationManager;Lcom/rokt/roktsdk/internal/requestutils/DiagnosticsRequestHandler;Ljava/lang/String;)V", "errorHandler", "Lkotlin/Function2;", "Lcom/rokt/roktsdk/internal/util/Constants$DiagnosticsErrorType;", "", "", "getErrorHandler", "()Lkotlin/jvm/functions/Function2;", "linkUrl", "getLinkUrl", "()Ljava/lang/String;", "linkUrl$delegate", "Lkotlin/Lazy;", "linkViewData", "Lcom/rokt/roktsdk/internal/viewdata/LinkLaunchViewData;", "loadingStatusLiveData", "Landroidx/lifecycle/MutableLiveData;", "", "getLoadingStatusLiveData", "()Landroidx/lifecycle/MutableLiveData;", "copyToClipboard", "context", "Landroid/content/Context;", "text", "getErrorDetails", "openLinkInExternalBrowser", "uriString", "setViewData", "viewData", "share", "contentUri", "shouldOverrideUrlLoading", "url", "legacyroktsdk_devRelease"})
public final class LinkViewModel {
    @NotNull
    private final NavigationManager navigationManager;
    @NotNull
    private final String sessionId;
    @NotNull
    private final Lazy linkUrl$delegate;
    @NotNull
    private final MutableLiveData<Boolean> loadingStatusLiveData;
    private LinkLaunchViewData linkViewData;
    @NotNull
    private final Function2<Constants.DiagnosticsErrorType, Throwable, Unit> errorHandler;

    /*
     * WARNING - void declaration
     */
    public LinkViewModel(@NotNull NavigationManager navigationManager, @NotNull DiagnosticsRequestHandler diagnosticsRequestHandler, @NotNull String sessionId) {
        void $this$loadingStatusLiveData_u24lambda_u240;
        MutableLiveData mutableLiveData;
        Intrinsics.checkNotNullParameter((Object)navigationManager, (String)"navigationManager");
        Intrinsics.checkNotNullParameter((Object)diagnosticsRequestHandler, (String)"diagnosticsRequestHandler");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.navigationManager = navigationManager;
        this.sessionId = sessionId;
        this.linkUrl$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ LinkViewModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                LinkLaunchViewData linkLaunchViewData = LinkViewModel.access$getLinkViewData$p(this.this$0);
                if (linkLaunchViewData == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"linkViewData");
                    linkLaunchViewData = null;
                }
                return linkLaunchViewData.getLink();
            }
        }));
        MutableLiveData mutableLiveData2 = mutableLiveData = new MutableLiveData();
        LinkViewModel linkViewModel = this;
        boolean bl = false;
        $this$loadingStatusLiveData_u24lambda_u240.setValue((Object)true);
        linkViewModel.loadingStatusLiveData = mutableLiveData;
        this.errorHandler = (Function2)new Function2<Constants.DiagnosticsErrorType, Throwable, Unit>(diagnosticsRequestHandler, this){
            final /* synthetic */ DiagnosticsRequestHandler $diagnosticsRequestHandler;
            final /* synthetic */ LinkViewModel this$0;
            {
                this.$diagnosticsRequestHandler = $diagnosticsRequestHandler;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Constants.DiagnosticsErrorType message, @NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)((Object)message), (String)"message");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                DiagnosticsRequestHandler.postDiagnostics$default(this.$diagnosticsRequestHandler, message, exception.toString(), null, LinkViewModel.access$getSessionId$p(this.this$0), null, 20, null);
            }
        };
    }

    @NotNull
    public final String getLinkUrl() {
        Lazy lazy = this.linkUrl$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<Boolean> getLoadingStatusLiveData() {
        return this.loadingStatusLiveData;
    }

    public final void setViewData(@NotNull LinkLaunchViewData viewData) {
        Intrinsics.checkNotNullParameter((Object)viewData, (String)"viewData");
        this.linkViewData = viewData;
    }

    @NotNull
    public final Function2<Constants.DiagnosticsErrorType, Throwable, Unit> getErrorHandler() {
        return this.errorHandler;
    }

    @NotNull
    public final String getErrorDetails() {
        String string2 = this.getLinkUrl();
        LinkLaunchViewData linkLaunchViewData = this.linkViewData;
        if (linkLaunchViewData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"linkViewData");
            linkLaunchViewData = null;
        }
        return "OriginalUrl: " + string2 + " ,text: " + linkLaunchViewData.getTitleViewData().getText();
    }

    public final void copyToClipboard(@NotNull Context context, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = context.getSystemService("clipboard");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData clipData = ClipData.newPlainText((CharSequence)"uri", (CharSequence)text);
        Intrinsics.checkNotNullExpressionValue((Object)clipData, (String)"newPlainText(\"uri\", text)");
        ClipData clip = clipData;
        clipboard.setPrimaryClip(clip);
    }

    public final void openLinkInExternalBrowser(@NotNull Context context, @NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        Intent intent = Intent.parseUri((String)uriString, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"parseUri(uriString, Intent.URI_INTENT_SCHEME)");
        Intent newIntent = intent;
        if (UtilsKt.canOpenInExternalApp(newIntent, context)) {
            context.startActivity(newIntent);
        }
    }

    public final void share(@NotNull Context context, @NotNull String contentUri) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
        Intent $this$share_u24lambda_u241 = intent = new Intent();
        boolean bl = false;
        $this$share_u24lambda_u241.setAction("android.intent.action.SEND");
        $this$share_u24lambda_u241.putExtra("android.intent.extra.TEXT", contentUri);
        $this$share_u24lambda_u241.setType("text/html");
        Intent share = Intent.createChooser((Intent)intent, null);
        context.startActivity(share);
    }

    public final boolean shouldOverrideUrlLoading(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return NavigationManager.didHandleDeepLink$legacyroktsdk_devRelease$default(this.navigationManager, url, null, 2, null) || UtilsKt.isDeepLink(url);
    }

    public static final /* synthetic */ LinkLaunchViewData access$getLinkViewData$p(LinkViewModel $this) {
        return $this.linkViewData;
    }

    public static final /* synthetic */ String access$getSessionId$p(LinkViewModel $this) {
        return $this.sessionId;
    }
}

