/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.viewmodel;

import android.net.Uri;
import com.rokt.roktsdk.internal.util.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0003*\u00020\u0003H\u0000\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u0007H\u0000\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0003*\u00020\u0003H\u0002\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\u0003*\u00020\u0003H\u0000\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\u0003H\u0002\u00a8\u0006\r"}, d2={"shouldOpenInExternalApp", "", "url", "", "convertToPlayStoreUrl", "getFallBackUrl", "getHostName", "Landroid/net/Uri;", "getPackageName", "getPlayStoreUrlFromPackage", "substringOrNull", "substring", "toNullIfEmpty", "legacyroktsdk_devRelease"})
public final class LinkViewModelKt {
    public static final boolean shouldOpenInExternalApp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return UtilsKt.isPlayStoreLink(url) || UtilsKt.isDeepLink(url);
    }

    @Nullable
    public static final String getFallBackUrl(@NotNull String $this$getFallBackUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$getFallBackUrl, (String)"<this>");
        return LinkViewModelKt.substringOrNull($this$getFallBackUrl, "browser_fallback_url=");
    }

    private static final String toNullIfEmpty(String $this$toNullIfEmpty) {
        return ((CharSequence)$this$toNullIfEmpty).length() == 0 || StringsKt.isBlank((CharSequence)$this$toNullIfEmpty) ? null : $this$toNullIfEmpty;
    }

    private static final String substringOrNull(String $this$substringOrNull, String substring) {
        if (StringsKt.contains$default((CharSequence)$this$substringOrNull, (CharSequence)substring, (boolean)false, (int)2, null)) {
            return LinkViewModelKt.toNullIfEmpty(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)$this$substringOrNull, (String)substring, null, (int)2, null), (String)";", null, (int)2, null));
        }
        return null;
    }

    private static final String getPackageName(String $this$getPackageName) {
        return LinkViewModelKt.substringOrNull($this$getPackageName, "package=");
    }

    @Nullable
    public static final String getPlayStoreUrlFromPackage(@NotNull String $this$getPlayStoreUrlFromPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$getPlayStoreUrlFromPackage, (String)"<this>");
        String string2 = LinkViewModelKt.getPackageName($this$getPlayStoreUrlFromPackage);
        return string2 != null ? LinkViewModelKt.convertToPlayStoreUrl(string2) : null;
    }

    private static final String convertToPlayStoreUrl(String $this$convertToPlayStoreUrl) {
        return "https://play.google.com/store/apps/details?id=" + $this$convertToPlayStoreUrl;
    }

    @Nullable
    public static final String getHostName(@NotNull Uri $this$getHostName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getHostName, (String)"<this>");
        if ($this$getHostName.getHost() == null) {
            return null;
        }
        if (StringsKt.startsWith$default((String)String.valueOf($this$getHostName.getHost()), (String)"www.", (boolean)false, (int)2, null)) {
            String string3 = String.valueOf($this$getHostName.getHost()).substring(4);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string2 = $this$getHostName.getHost();
        }
        return string2;
    }
}

