/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.ViewCompat;
import com.rokt.legacy.roktsdk.R;
import com.rokt.roktsdk.internal.util.BindingAdaptersKt;
import com.rokt.roktsdk.internal.util.Constants;
import com.rokt.roktsdk.internal.util.ImageLoaderKt;
import com.rokt.roktsdk.internal.util.UtilsKt;
import com.rokt.roktsdk.internal.viewdata.BoundingBox;
import com.rokt.roktsdk.internal.viewdata.CreativeTitleImageAlignment;
import com.rokt.roktsdk.internal.viewdata.CreativeTitleImageArrangement;
import com.rokt.roktsdk.internal.viewdata.TextViewData;
import com.rokt.roktsdk.internal.viewdata.TitleImageViewData;
import com.rokt.roktsdk.internal.viewmodel.OfferViewModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J2\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2 \u0010#\u001a\u001c\u0012\u0004\u0012\u00020%\u0012\b\u0012\u00060&j\u0002`'\u0012\u0004\u0012\u00020\u001d0$j\u0002`(H\u0002J2\u0010)\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2 \u0010#\u001a\u001c\u0012\u0004\u0012\u00020%\u0012\b\u0012\u00060&j\u0002`'\u0012\u0004\u0012\u00020\u001d0$j\u0002`(H\u0003J\u0012\u0010*\u001a\u00020\u001d2\b\b\u0001\u0010+\u001a\u00020,H\u0002J:\u0010-\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2 \u0010#\u001a\u001c\u0012\u0004\u0012\u00020%\u0012\b\u0012\u00060&j\u0002`'\u0012\u0004\u0012\u00020\u001d0$j\u0002`(2\b\b\u0002\u0010.\u001a\u00020/J2\u00100\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2 \u0010#\u001a\u001c\u0012\u0004\u0012\u00020%\u0012\b\u0012\u00060&j\u0002`'\u0012\u0004\u0012\u00020\u001d0$j\u0002`(H\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012\u00a8\u00061"}, d2={"Lcom/rokt/roktsdk/internal/views/CreativeLayoutView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "offerContainer", "Landroid/widget/LinearLayout;", "getOfferContainer", "()Landroid/widget/LinearLayout;", "setOfferContainer", "(Landroid/widget/LinearLayout;)V", "offerCopy", "Landroid/widget/TextView;", "getOfferCopy", "()Landroid/widget/TextView;", "setOfferCopy", "(Landroid/widget/TextView;)V", "offerImage", "Landroid/widget/ImageView;", "getOfferImage", "()Landroid/widget/ImageView;", "setOfferImage", "(Landroid/widget/ImageView;)V", "offerTitle", "getOfferTitle", "setOfferTitle", "applyAlignment", "", "creativeTitleImageAlignment", "Lcom/rokt/roktsdk/internal/viewdata/CreativeTitleImageAlignment;", "bindHorizontalArrangementData", "offerViewModel", "Lcom/rokt/roktsdk/internal/viewmodel/OfferViewModel;", "errorHandler", "Lkotlin/Function2;", "Lcom/rokt/roktsdk/internal/util/Constants$DiagnosticsErrorType;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lcom/rokt/roktsdk/internal/util/ErrorHandler;", "bindVerticalArrangementData", "initViews", "layoutRes", "", "setCreativeLayoutViewModel", "isEmbedded", "", "setupOfferImageContent", "legacyroktsdk_devRelease"})
@SourceDebugExtension(value={"SMAP\nCreativeLayoutView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreativeLayoutView.kt\ncom/rokt/roktsdk/internal/views/CreativeLayoutView\n+ 2 View.kt\nandroidx/core/view/ViewKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n68#2,4:255\n40#2:259\n56#2:260\n75#2:261\n68#2,4:262\n40#2:266\n56#2:267\n75#2:268\n1#3:269\n*S KotlinDebug\n*F\n+ 1 CreativeLayoutView.kt\ncom/rokt/roktsdk/internal/views/CreativeLayoutView\n*L\n62#1:255,4\n62#1:259\n62#1:260\n62#1:261\n70#1:262,4\n70#1:266\n70#1:267\n70#1:268\n*E\n"})
public final class CreativeLayoutView
extends ConstraintLayout {
    public ImageView offerImage;
    public TextView offerTitle;
    public TextView offerCopy;
    public LinearLayout offerContainer;

    public CreativeLayoutView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
    }

    @NotNull
    public final ImageView getOfferImage() {
        ImageView imageView = this.offerImage;
        if (imageView != null) {
            return imageView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"offerImage");
        return null;
    }

    public final void setOfferImage(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
        this.offerImage = imageView;
    }

    @NotNull
    public final TextView getOfferTitle() {
        TextView textView = this.offerTitle;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"offerTitle");
        return null;
    }

    public final void setOfferTitle(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.offerTitle = textView;
    }

    @NotNull
    public final TextView getOfferCopy() {
        TextView textView = this.offerCopy;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"offerCopy");
        return null;
    }

    public final void setOfferCopy(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.offerCopy = textView;
    }

    @NotNull
    public final LinearLayout getOfferContainer() {
        LinearLayout linearLayout = this.offerContainer;
        if (linearLayout != null) {
            return linearLayout;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"offerContainer");
        return null;
    }

    public final void setOfferContainer(@NotNull LinearLayout linearLayout) {
        Intrinsics.checkNotNullParameter((Object)linearLayout, (String)"<set-?>");
        this.offerContainer = linearLayout;
    }

    public final void setCreativeLayoutViewModel(@NotNull OfferViewModel offerViewModel, @NotNull Function2<? super Constants.DiagnosticsErrorType, ? super Exception, Unit> errorHandler2, boolean isEmbedded) {
        Intrinsics.checkNotNullParameter((Object)((Object)offerViewModel), (String)"offerViewModel");
        Intrinsics.checkNotNullParameter(errorHandler2, (String)"errorHandler");
        TitleImageViewData titleImageViewData = offerViewModel.getCreativeTitleImageViewData();
        switch (WhenMappings.$EnumSwitchMapping$0[titleImageViewData.getCreativeTitleImageArrangement().ordinal()]) {
            case 1: {
                this.initViews(isEmbedded ? R.layout.rokt_v_creative_title_bottom_embedded_offer : R.layout.rokt_v_creative_title_bottom_offer);
                this.bindVerticalArrangementData(offerViewModel, errorHandler2);
                break;
            }
            case 2: {
                this.initViews(R.layout.rokt_v_creative_title_start_offer);
                this.bindHorizontalArrangementData(offerViewModel, errorHandler2);
                View $this$doOnLayout$iv = (View)this;
                boolean $i$f$doOnLayout = false;
                if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
                    View it = $this$doOnLayout$iv;
                    boolean bl = false;
                    this.applyAlignment(titleImageViewData.getCreativeTitleImageAlignment());
                    break;
                }
                View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
                boolean $i$f$doOnNextLayout = false;
                $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this, titleImageViewData){
                    final /* synthetic */ CreativeLayoutView this$0;
                    final /* synthetic */ TitleImageViewData $titleImageViewData$inlined;
                    {
                        this.this$0 = creativeLayoutView;
                        this.$titleImageViewData$inlined = titleImageViewData;
                    }

                    public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                        View it = view;
                        boolean bl = false;
                        View it2 = it;
                        boolean bl2 = false;
                        CreativeLayoutView.access$applyAlignment(this.this$0, this.$titleImageViewData$inlined.getCreativeTitleImageAlignment());
                    }
                });
                break;
            }
            case 3: {
                this.initViews(R.layout.rokt_v_creative_title_end_offer);
                this.bindHorizontalArrangementData(offerViewModel, errorHandler2);
                View $this$doOnLayout$iv = (View)this;
                boolean $i$f$doOnLayout = false;
                if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
                    View it = $this$doOnLayout$iv;
                    boolean bl = false;
                    this.applyAlignment(titleImageViewData.getCreativeTitleImageAlignment());
                    break;
                }
                View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
                boolean $i$f$doOnNextLayout = false;
                $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this, titleImageViewData){
                    final /* synthetic */ CreativeLayoutView this$0;
                    final /* synthetic */ TitleImageViewData $titleImageViewData$inlined;
                    {
                        this.this$0 = creativeLayoutView;
                        this.$titleImageViewData$inlined = titleImageViewData;
                    }

                    public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                        View it = view;
                        boolean bl = false;
                        View it2 = it;
                        boolean bl2 = false;
                        CreativeLayoutView.access$applyAlignment(this.this$0, this.$titleImageViewData$inlined.getCreativeTitleImageAlignment());
                    }
                });
            }
        }
    }

    public static /* synthetic */ void setCreativeLayoutViewModel$default(CreativeLayoutView creativeLayoutView, OfferViewModel offerViewModel, Function2 function2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        creativeLayoutView.setCreativeLayoutViewModel(offerViewModel, (Function2<? super Constants.DiagnosticsErrorType, ? super Exception, Unit>)function2, bl);
    }

    private final void initViews(@LayoutRes int layoutRes) {
        this.removeAllViews();
        View.inflate((Context)this.getContext(), (int)layoutRes, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.offer_image);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.offer_image)");
        this.setOfferImage((ImageView)view);
        View view2 = this.findViewById(R.id.offer_title);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.offer_title)");
        this.setOfferTitle((TextView)view2);
        View view3 = this.findViewById(R.id.offer_content);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.offer_content)");
        this.setOfferCopy((TextView)view3);
        View view4 = this.findViewById(R.id.offerContainer);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.offerContainer)");
        this.setOfferContainer((LinearLayout)view4);
    }

    @SuppressLint(value={"WrongConstant"})
    private final void bindVerticalArrangementData(OfferViewModel offerViewModel, Function2<? super Constants.DiagnosticsErrorType, ? super Exception, Unit> errorHandler2) {
        TextViewData textViewData;
        boolean isInlineCopyWithHeading = offerViewModel.isInLineCopyWithHeading();
        LinearLayout $this$bindVerticalArrangementData_u24lambda_u242 = this.getOfferContainer();
        boolean bl = false;
        BindingAdaptersKt.setBackgroundColorMap((View)$this$bindVerticalArrangementData_u24lambda_u242, offerViewModel.getOfferContentBackgroundColor(), errorHandler2);
        BindingAdaptersKt.setPaddingDp((View)$this$bindVerticalArrangementData_u24lambda_u242, offerViewModel.getOfferPadding());
        if (!isInlineCopyWithHeading) {
            Unit unit;
            TextView $this$bindVerticalArrangementData_u24lambda_u245 = this.getOfferTitle();
            boolean bl2 = false;
            TextViewData textViewData2 = offerViewModel.getTitleContent();
            if (textViewData2 != null) {
                TextViewData textViewData3 = textViewData2;
                boolean bl3 = false;
                $this$bindVerticalArrangementData_u24lambda_u245.setVisibility(0);
                BindingAdaptersKt.setOfferContent($this$bindVerticalArrangementData_u24lambda_u245, textViewData3, errorHandler2);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                TextView $this$bindVerticalArrangementData_u24lambda_u245_u24lambda_u244 = $this$bindVerticalArrangementData_u24lambda_u245;
                boolean bl4 = false;
                $this$bindVerticalArrangementData_u24lambda_u245_u24lambda_u244.setVisibility(8);
            }
        }
        TextView $this$bindVerticalArrangementData_u24lambda_u247 = this.getOfferCopy();
        boolean bl5 = false;
        TextViewData textViewData4 = textViewData = isInlineCopyWithHeading ? offerViewModel.getOfferContent() : offerViewModel.getCopyContent();
        if (textViewData4 != null) {
            TextViewData viewData = textViewData4;
            boolean bl6 = false;
            BindingAdaptersKt.setOfferContent($this$bindVerticalArrangementData_u24lambda_u247, viewData, errorHandler2);
            if (offerViewModel.hasOfferButton()) {
                BindingAdaptersKt.addTermsAndConditionAndPPButtons($this$bindVerticalArrangementData_u24lambda_u247, offerViewModel.getOfferButtons(), offerViewModel.getLinkClickHandler());
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            $this$bindVerticalArrangementData_u24lambda_u247.setBreakStrategy(0);
        }
        this.setupOfferImageContent(offerViewModel, errorHandler2);
    }

    private final void bindHorizontalArrangementData(OfferViewModel offerViewModel, Function2<? super Constants.DiagnosticsErrorType, ? super Exception, Unit> errorHandler2) {
        Unit unit;
        this.setupOfferImageContent(offerViewModel, errorHandler2);
        TextViewData textViewData = offerViewModel.getTitleContent();
        if (textViewData != null) {
            TextViewData textViewData2 = textViewData;
            boolean bl = false;
            this.getOfferTitle().setVisibility(0);
            BindingAdaptersKt.setOfferContent(this.getOfferTitle(), textViewData2, errorHandler2);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            CreativeLayoutView $this$bindHorizontalArrangementData_u24lambda_u249 = this;
            boolean bl = false;
            $this$bindHorizontalArrangementData_u24lambda_u249.getOfferTitle().setVisibility(8);
        }
        TextView $this$bindHorizontalArrangementData_u24lambda_u2412 = this.getOfferCopy();
        boolean bl = false;
        if (offerViewModel.hasOfferButton()) {
            TextViewData textViewData3 = offerViewModel.getCopyContent();
            if (textViewData3 != null) {
                TextViewData textViewData4 = textViewData3;
                boolean bl2 = false;
                BindingAdaptersKt.setOfferContent($this$bindHorizontalArrangementData_u24lambda_u2412, textViewData4, errorHandler2);
            }
            BindingAdaptersKt.addTermsAndConditionAndPPButtons($this$bindHorizontalArrangementData_u24lambda_u2412, offerViewModel.getOfferButtons(), offerViewModel.getLinkClickHandler());
        } else {
            TextViewData textViewData5 = offerViewModel.getCopyContent();
            if (textViewData5 != null) {
                TextViewData textViewData6 = textViewData5;
                boolean bl3 = false;
                BindingAdaptersKt.setTextViewData$default($this$bindHorizontalArrangementData_u24lambda_u2412, textViewData6, errorHandler2, null, 4, null);
            }
        }
        BindingAdaptersKt.setBackgroundColorMap((View)$this$bindHorizontalArrangementData_u24lambda_u2412, offerViewModel.getOfferContentBackgroundColor(), errorHandler2);
        BindingAdaptersKt.setPaddingDp((View)$this$bindHorizontalArrangementData_u24lambda_u2412, offerViewModel.getOfferPadding());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setupOfferImageContent(OfferViewModel offerViewModel, Function2<? super Constants.DiagnosticsErrorType, ? super Exception, Unit> errorHandler2) {
        block9: {
            block8: {
                Boolean hideOnDark = offerViewModel.shouldHideOnDark();
                if (Intrinsics.areEqual((Object)hideOnDark, (Object)false)) break block8;
                if (!Intrinsics.areEqual((Object)hideOnDark, (Object)true)) break block9;
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                if (UtilsKt.isDarkModeActive(context)) break block9;
            }
            ImageView $this$setupOfferImageContent_u24lambda_u2419 = this.getOfferImage();
            boolean bl = false;
            Integer n = offerViewModel.getOfferImageMaxHeight();
            if (n != null) {
                int height = ((Number)n).intValue();
                boolean bl2 = false;
                Context context = $this$setupOfferImageContent_u24lambda_u2419.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                $this$setupOfferImageContent_u24lambda_u2419.setMaxHeight(UtilsKt.dpToPx(height, context));
            }
            Integer n2 = offerViewModel.getOfferImageMaxWidth();
            if (n2 != null) {
                int width = ((Number)n2).intValue();
                boolean bl3 = false;
                Context context = $this$setupOfferImageContent_u24lambda_u2419.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                $this$setupOfferImageContent_u24lambda_u2419.setMaxWidth(UtilsKt.dpToPx(width, context));
            }
            ViewGroup.LayoutParams params = $this$setupOfferImageContent_u24lambda_u2419.getLayoutParams();
            Integer n3 = offerViewModel.getOfferImageHeight();
            if (n3 != null) {
                int height = ((Number)n3).intValue();
                boolean bl4 = false;
                Context context = $this$setupOfferImageContent_u24lambda_u2419.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                params.height = UtilsKt.dpToPx(height, context);
            }
            Integer n4 = offerViewModel.getOfferImageWidth();
            if (n4 != null) {
                int width = ((Number)n4).intValue();
                boolean bl5 = false;
                Context context = $this$setupOfferImageContent_u24lambda_u2419.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                params.width = UtilsKt.dpToPx(width, context);
            }
            $this$setupOfferImageContent_u24lambda_u2419.setLayoutParams(params);
            ImageView.ScaleType scaleType = offerViewModel.getOfferImageScaleType();
            if (scaleType != null) {
                ImageView.ScaleType type = scaleType;
                boolean bl6 = false;
                $this$setupOfferImageContent_u24lambda_u2419.setScaleType(type);
            }
            BoundingBox boundingBox = offerViewModel.getOfferImageMargin();
            if (boundingBox != null) {
                BoundingBox it = boundingBox;
                boolean bl7 = false;
                BindingAdaptersKt.setMarginDp((View)$this$setupOfferImageContent_u24lambda_u2419, it);
            }
            ImageLoaderKt.loadImageUrl($this$setupOfferImageContent_u24lambda_u2419, offerViewModel.getOfferImageUrl(), errorHandler2);
            return;
        }
        this.getOfferImage().setVisibility(8);
    }

    private final void applyAlignment(CreativeTitleImageAlignment creativeTitleImageAlignment) {
        int imageSize = this.getOfferImage().getMeasuredHeight();
        int textSize = this.getOfferTitle().getMeasuredHeight();
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintLayout)this);
        switch (WhenMappings.$EnumSwitchMapping$1[creativeTitleImageAlignment.ordinal()]) {
            case 1: {
                constraintSet.clear(this.getOfferTitle().getId(), 4);
                break;
            }
            case 2: {
                if (textSize <= imageSize) break;
                constraintSet.connect(this.getOfferTitle().getId(), 3, 0, 3);
                constraintSet.clear(this.getOfferTitle().getId(), 4);
                constraintSet.connect(this.getOfferImage().getId(), 3, this.getOfferTitle().getId(), 3);
                constraintSet.connect(this.getOfferImage().getId(), 4, this.getOfferTitle().getId(), 4);
                break;
            }
            case 3: {
                if (imageSize > textSize) {
                    constraintSet.clear(this.getOfferTitle().getId(), 3);
                    break;
                }
                constraintSet.clear(this.getOfferImage().getId(), 3);
                constraintSet.connect(this.getOfferTitle().getId(), 4, R.id.titleImageBarrier, 3);
                constraintSet.connect(this.getOfferImage().getId(), 4, this.getOfferTitle().getId(), 4);
            }
        }
        constraintSet.applyTo((ConstraintLayout)this);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CreativeTitleImageArrangement.values().length];
            try {
                nArray[CreativeTitleImageArrangement.Bottom.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CreativeTitleImageArrangement.Start.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CreativeTitleImageArrangement.End.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CreativeTitleImageAlignment.values().length];
            try {
                nArray[CreativeTitleImageAlignment.Top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CreativeTitleImageAlignment.Center.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CreativeTitleImageAlignment.Bottom.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

