/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.customtabs;

import android.content.Context;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.core.content.ContextCompat;
import com.rokt.legacy.roktsdk.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/rokt/roktsdk/internal/customtabs/CustomTabsHelper;", "", "()V", "openCustomTab", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "legacyroktsdk_devRelease"})
public final class CustomTabsHelper {
    @NotNull
    public static final CustomTabsHelper INSTANCE = new CustomTabsHelper();

    private CustomTabsHelper() {
    }

    public final boolean openCustomTab(@NotNull Context context, @NotNull Uri uri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        int darkBackgroundColour = ContextCompat.getColor((Context)context, (int)R.color.rokt_default_background_colour_dark_mode);
        CustomTabColorSchemeParams customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setToolbarColor(darkBackgroundColour).setNavigationBarColor(darkBackgroundColour).build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams, (String)"Builder()\n            .s\u2026our)\n            .build()");
        CustomTabColorSchemeParams darkParams = customTabColorSchemeParams;
        int lightBackgroundColour = ContextCompat.getColor((Context)context, (int)R.color.rokt_default_background_colour_light_mode);
        CustomTabColorSchemeParams customTabColorSchemeParams2 = new CustomTabColorSchemeParams.Builder().setToolbarColor(lightBackgroundColour).setNavigationBarColor(lightBackgroundColour).build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams2, (String)"Builder()\n            .s\u2026our)\n            .build()");
        CustomTabColorSchemeParams lightParams = customTabColorSchemeParams2;
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder().setColorScheme(0).setColorSchemeParams(2, darkParams).setDefaultColorSchemeParams(lightParams);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder()\n            .s\u2026SchemeParams(lightParams)");
        CustomTabsIntent.Builder customTabsIntentBuilder = builder;
        CustomTabsIntent customTabsIntent = customTabsIntentBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"customTabsIntentBuilder.build()");
        CustomTabsIntent customTabsIntent2 = customTabsIntent;
        try {
            customTabsIntent2.launchUrl(context, uri);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }
}

