/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.requestutils;

import com.rokt.roktsdk.internal.util.PreferenceUtil;
import com.rokt.roktsdk.internal.util.TimeProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\b\u0010\f\u001a\u0004\u0018\u00010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/rokt/roktsdk/internal/requestutils/SessionHandler;", "", "preferenceUtil", "Lcom/rokt/roktsdk/internal/util/PreferenceUtil;", "timeProvider", "Lcom/rokt/roktsdk/internal/util/TimeProvider;", "(Lcom/rokt/roktsdk/internal/util/PreferenceUtil;Lcom/rokt/roktsdk/internal/util/TimeProvider;)V", "currentSession", "", "sessionExpirationTime", "", "getSavedSession", "getValidSession", "isSessionActive", "", "updateLastSeen", "", "updateSession", "session", "legacyroktsdk_devRelease"})
public final class SessionHandler {
    @NotNull
    private final PreferenceUtil preferenceUtil;
    @NotNull
    private final TimeProvider timeProvider;
    @Nullable
    private String currentSession;
    private long sessionExpirationTime;

    public SessionHandler(@NotNull PreferenceUtil preferenceUtil, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)preferenceUtil, (String)"preferenceUtil");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.preferenceUtil = preferenceUtil;
        this.timeProvider = timeProvider;
        this.sessionExpirationTime = Long.MIN_VALUE;
    }

    @Nullable
    public final String getSavedSession() {
        if (this.isSessionActive()) {
            this.updateLastSeen();
        }
        return this.currentSession;
    }

    @Nullable
    public final String getValidSession() {
        String string2;
        if (this.isSessionActive()) {
            this.updateLastSeen();
            string2 = this.currentSession;
        } else {
            string2 = null;
        }
        return string2;
    }

    private final boolean isSessionActive() {
        return this.timeProvider.getCurrentTimeMillis() < this.sessionExpirationTime;
    }

    public final void updateSession(@NotNull String session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.currentSession = session;
        this.updateLastSeen();
    }

    public final void updateLastSeen() {
        this.sessionExpirationTime = this.timeProvider.getCurrentTimeMillis() + PreferenceUtil.getLong$default(this.preferenceUtil, "defaultSessionTimeoutMilliseconds", 0L, 2, null);
    }
}

