/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.internal.util;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import androidx.annotation.ColorInt;
import com.rokt.core.di.Component;
import com.rokt.roktsdk.RoktLegacy;
import com.rokt.roktsdk.internal.di.singleton.ApplicationComponent;
import com.rokt.roktsdk.internal.util.UtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\n\u0010\u000b\u001a\u00020\u0004*\u00020\u0004\u00a8\u0006\f"}, d2={"Lcom/rokt/roktsdk/internal/util/Utils;", "", "()V", "getDeviceName", "", "parseColorSafely", "", "colorMap", "", "context", "Landroid/content/Context;", "stripNonAscii", "legacyroktsdk_devRelease"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/rokt/roktsdk/internal/util/Utils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,308:1\n429#2:309\n502#2,5:310\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/rokt/roktsdk/internal/util/Utils\n*L\n57#1:309\n57#1:310,5\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @Nullable
    public final String getDeviceName() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
        Intrinsics.checkNotNullExpressionValue((Object)manufacturer, (String)"manufacturer");
        return StringsKt.startsWith$default((String)model, (String)manufacturer, (boolean)false, (int)2, null) ? StringsKt.capitalize((String)model) : StringsKt.capitalize((String)manufacturer) + " " + model;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String stripNonAscii(@NotNull String $this$stripNonAscii) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$stripNonAscii, (String)"<this>");
        String $this$filter$iv = $this$stripNonAscii;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            char c = it;
            boolean bl2 = '\u0000' <= c ? c < '\u0080' : false;
            if (!bl2) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filterTo(StringBuilder(), predicate).toString()");
        return string2;
    }

    @ColorInt
    public final int parseColorSafely(@Nullable Map<Integer, String> colorMap, @Nullable Context context) {
        String string2;
        Context context2 = context;
        boolean bl = context2 != null ? UtilsKt.isDarkModeActive(context2) : false;
        if (bl) {
            Map<Integer, String> map = colorMap;
            string2 = map != null ? map.get(1) : null;
        } else {
            Map<Integer, String> map = colorMap;
            string2 = map != null ? map.get(0) : null;
        }
        String colorString = string2;
        CharSequence charSequence = colorString;
        if (!(charSequence == null || charSequence.length() == 0)) {
            try {
                return Color.parseColor((String)colorString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static /* synthetic */ int parseColorSafely$default(Utils utils, Map map, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            ApplicationComponent applicationComponent = RoktLegacy.INSTANCE.getAppComponent$legacyroktsdk_devRelease();
            context = applicationComponent != null ? (Context)Component.get$default((Component)applicationComponent, Context.class, null, (int)2, null) : null;
        }
        return utils.parseColorSafely(map, context);
    }
}

