/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk;

import android.content.Context;
import android.os.Handler;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.rokt.roktsdk.ApplicationStateRepository;
import com.rokt.roktsdk.PartnerDataInfo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/rokt/roktsdk/ExecuteLifeCycleObserver;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "context", "Landroid/content/Context;", "applicationStateRepository", "Lcom/rokt/roktsdk/ApplicationStateRepository;", "partnerInfo", "Lcom/rokt/roktsdk/PartnerDataInfo;", "processLifecycle", "Landroidx/lifecycle/Lifecycle;", "lifecycle", "(Landroid/content/Context;Lcom/rokt/roktsdk/ApplicationStateRepository;Lcom/rokt/roktsdk/PartnerDataInfo;Landroidx/lifecycle/Lifecycle;Landroidx/lifecycle/Lifecycle;)V", "getApplicationStateRepository", "()Lcom/rokt/roktsdk/ApplicationStateRepository;", "getContext", "()Landroid/content/Context;", "getLifecycle", "()Landroidx/lifecycle/Lifecycle;", "getPartnerInfo", "()Lcom/rokt/roktsdk/PartnerDataInfo;", "getProcessLifecycle", "observe", "", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "roktsdk_devRelease"})
public final class ExecuteLifeCycleObserver
implements DefaultLifecycleObserver {
    @NotNull
    private final Context context;
    @NotNull
    private final ApplicationStateRepository applicationStateRepository;
    @NotNull
    private final PartnerDataInfo partnerInfo;
    @NotNull
    private final Lifecycle processLifecycle;
    @Nullable
    private final Lifecycle lifecycle;

    public ExecuteLifeCycleObserver(@NotNull Context context, @NotNull ApplicationStateRepository applicationStateRepository, @NotNull PartnerDataInfo partnerInfo, @NotNull Lifecycle processLifecycle, @Nullable Lifecycle lifecycle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)applicationStateRepository, (String)"applicationStateRepository");
        Intrinsics.checkNotNullParameter((Object)partnerInfo, (String)"partnerInfo");
        Intrinsics.checkNotNullParameter((Object)processLifecycle, (String)"processLifecycle");
        this.context = context;
        this.applicationStateRepository = applicationStateRepository;
        this.partnerInfo = partnerInfo;
        this.processLifecycle = processLifecycle;
        this.lifecycle = lifecycle;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final ApplicationStateRepository getApplicationStateRepository() {
        return this.applicationStateRepository;
    }

    @NotNull
    public final PartnerDataInfo getPartnerInfo() {
        return this.partnerInfo;
    }

    @NotNull
    public final Lifecycle getProcessLifecycle() {
        return this.processLifecycle;
    }

    @Nullable
    public final Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public final void observe() {
        new Handler(this.context.getMainLooper()).post(() -> ExecuteLifeCycleObserver.observe$lambda$0(this));
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onDestroy(owner);
        String string = this.partnerInfo.getTimeStampedViewName();
        if (string == null) {
            string = "";
        }
        this.applicationStateRepository.removeEventListeners(string);
    }

    private static final void observe$lambda$0(ExecuteLifeCycleObserver this$0) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Lifecycle lifecycle = this$0.lifecycle;
        if (lifecycle != null) {
            lifecycle.addObserver((LifecycleObserver)this$0);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            this$0.processLifecycle.addObserver((LifecycleObserver)this$0);
        }
    }
}

