/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk;

import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import com.rokt.core.utilities.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\u0006\u0010\u0006\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcom/rokt/roktsdk/RoktBuildConfig;", "", "()V", "getDeviceManufacturer", "", "getDeviceModel", "getDeviceName", "getVersionRelease", "roktsdk_devRelease"})
@StabilityInferred(parameters=0)
public final class RoktBuildConfig {
    @NotNull
    public static final RoktBuildConfig INSTANCE = new RoktBuildConfig();
    public static final int $stable;

    private RoktBuildConfig() {
    }

    @NotNull
    public final String getVersionRelease() {
        String string = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RELEASE");
        return string;
    }

    @NotNull
    public final String getDeviceName() {
        String manufacturer = this.getDeviceManufacturer();
        String model = this.getDeviceModel();
        return StringsKt.startsWith$default((String)model, (String)manufacturer, (boolean)false, (int)2, null) ? Utils.INSTANCE.safeCapitalize(model) : Utils.INSTANCE.safeCapitalize(manufacturer) + " " + model;
    }

    private final String getDeviceModel() {
        String string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        return string;
    }

    private final String getDeviceManufacturer() {
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
        return string;
    }
}

