/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktsdk.ui.views;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"COMPONENT_CUTOFF_THRESHOLD_RATIO", "", "isEffectivelyVisible", "", "Landroid/view/View;", "isLayoutMisSized", "isViewCutOff", "measureUnspecifiedAndLayout", "", "roktsdk_devRelease"})
@SourceDebugExtension(value={"SMAP\nViewUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewUtils.kt\ncom/rokt/roktsdk/ui/views/ViewUtilsKt\n+ 2 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,45:1\n255#2:46\n*S KotlinDebug\n*F\n+ 1 ViewUtils.kt\ncom/rokt/roktsdk/ui/views/ViewUtilsKt\n*L\n8#1:46\n*E\n"})
public final class ViewUtilsKt {
    private static final float COMPONENT_CUTOFF_THRESHOLD_RATIO = 1.0f;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyVisible(@NotNull View $this$isEffectivelyVisible) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyVisible, (String)"<this>");
        View $this$isVisible$iv = $this$isEffectivelyVisible;
        boolean $i$f$isVisible = false;
        if ($this$isVisible$iv.getVisibility() != 0) return false;
        boolean bl = true;
        if (!bl) return false;
        if ($this$isEffectivelyVisible.getAlpha() != 1.0f) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        ViewParent viewParent = $this$isEffectivelyVisible.getParent();
        if (!(viewParent instanceof View)) return true;
        View view = (View)viewParent;
        if (view == null) return true;
        boolean bl3 = ViewUtilsKt.isEffectivelyVisible(view);
        if (!bl3) return false;
        return true;
    }

    public static final boolean isLayoutMisSized(@NotNull View $this$isLayoutMisSized) {
        Intrinsics.checkNotNullParameter((Object)$this$isLayoutMisSized, (String)"<this>");
        ViewUtilsKt.measureUnspecifiedAndLayout($this$isLayoutMisSized);
        Rect visibleRect = new Rect();
        $this$isLayoutMisSized.getLocalVisibleRect(visibleRect);
        return $this$isLayoutMisSized.getMeasuredHeight() != visibleRect.height() || $this$isLayoutMisSized.getMeasuredWidth() != visibleRect.width();
    }

    private static final void measureUnspecifiedAndLayout(View $this$measureUnspecifiedAndLayout) {
        $this$measureUnspecifiedAndLayout.measure(View.MeasureSpec.makeMeasureSpec((int)$this$measureUnspecifiedAndLayout.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)$this$measureUnspecifiedAndLayout.getMeasuredHeight(), (int)0));
        $this$measureUnspecifiedAndLayout.layout($this$measureUnspecifiedAndLayout.getLeft(), $this$measureUnspecifiedAndLayout.getTop(), $this$measureUnspecifiedAndLayout.getRight(), $this$measureUnspecifiedAndLayout.getBottom());
    }

    public static final boolean isViewCutOff(@NotNull View $this$isViewCutOff) {
        Intrinsics.checkNotNullParameter((Object)$this$isViewCutOff, (String)"<this>");
        if (!$this$isViewCutOff.isAttachedToWindow()) {
            return false;
        }
        Rect drawingRect = new Rect();
        $this$isViewCutOff.getDrawingRect(drawingRect);
        float totalArea = drawingRect.height() * drawingRect.width();
        if (totalArea == 0.0f) {
            return false;
        }
        Rect localRect = new Rect();
        boolean localVisible = $this$isViewCutOff.getLocalVisibleRect(localRect);
        if (!localVisible) {
            return false;
        }
        int visibleArea = localRect.height() * localRect.width();
        return (float)visibleArea / totalArea < 1.0f;
    }
}

