/*
 * Decompiled with CFR 0.152.
 */
package com.rokt.roktux.imagehandler;

import android.content.Context;
import android.net.Uri;
import androidx.compose.runtime.internal.StabilityInferred;
import coil.ImageLoader;
import coil.decode.DataSource;
import coil.decode.ImageSource;
import coil.decode.ImageSources;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.request.Options;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\f"}, d2={"Lcom/rokt/roktux/imagehandler/DataUriFetcher;", "Lcoil/fetch/Fetcher;", "data", "Landroid/net/Uri;", "options", "Lcoil/request/Options;", "(Landroid/net/Uri;Lcoil/request/Options;)V", "fetch", "Lcoil/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "Factory", "roktux_release"})
@StabilityInferred(parameters=0)
public final class DataUriFetcher
implements Fetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Uri data;
    @NotNull
    private final Options options;
    public static final int $stable = 8;
    @NotNull
    private static final String[] SUPPORTED_FORMATS;

    public DataUriFetcher(@NotNull Uri data, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.data = data;
        this.options = options;
    }

    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        ByteString base64Data;
        String string = this.data.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.toString()");
        ByteString byteString = base64Data = ByteString.Companion.decodeBase64(StringsKt.substringAfter$default((String)string, (char)',', null, (int)2, null));
        ByteArrayInputStream stream = new ByteArrayInputStream((byte[])(byteString != null ? byteString.toByteArray() : null));
        ImageSource imageSource = ImageSources.create((BufferedSource)Okio.buffer((Source)Okio.source((InputStream)stream)), (Context)this.options.getContext(), null);
        DataSource dataSource = DataSource.MEMORY;
        String string2 = DataUriFetcher.Companion.getMimeType(this.data);
        return new SourceResult(imageSource, string2, dataSource);
    }

    static {
        String[] stringArray = new String[]{"image/png", "image/jpg", "image/jpeg", "image/svg+xml"};
        SUPPORTED_FORMATS = stringArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/rokt/roktux/imagehandler/DataUriFetcher$Companion;", "", "()V", "SUPPORTED_FORMATS", "", "", "[Ljava/lang/String;", "getMimeType", "Landroid/net/Uri;", "roktux_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String getMimeType(Uri $this$getMimeType) {
            String string = $this$getMimeType.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.toString()");
            return StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)string, (char)':', null, (int)2, null), (char)';', null, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/rokt/roktux/imagehandler/DataUriFetcher$Factory;", "Lcoil/fetch/Fetcher$Factory;", "Landroid/net/Uri;", "()V", "create", "Lcoil/fetch/Fetcher;", "data", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isFormatSupported", "", "mimeType", "", "isSupportedDataUri", "roktux_release"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        public static final int $stable;

        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
            return this.isSupportedDataUri(data) ? (Fetcher)new DataUriFetcher(data, options) : null;
        }

        private final boolean isSupportedDataUri(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"data") && this.isFormatSupported(Companion.getMimeType(data));
        }

        private final boolean isFormatSupported(String mimeType) {
            return ArraysKt.contains((Object[])SUPPORTED_FORMATS, (Object)mimeType);
        }
    }
}

