/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.Client;
import com.rollbar.api.payload.data.Level;
import com.rollbar.api.payload.data.Notifier;
import com.rollbar.api.payload.data.Person;
import com.rollbar.api.payload.data.Request;
import com.rollbar.api.payload.data.Server;
import com.rollbar.api.payload.data.body.Body;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Data
implements JsonSerializable {
    private final String environment;
    private final Body body;
    private final Level level;
    private final Long timestamp;
    private final String codeVersion;
    private final String platform;
    private final String language;
    private final String framework;
    private final String context;
    private final Request request;
    private final Person person;
    private final Server server;
    private final Client client;
    private final Map<String, Object> custom;
    private final String fingerprint;
    private final String title;
    private final String uuid;
    private final Notifier notifier;

    private Data(Builder builder) {
        this.environment = builder.environment;
        this.body = builder.body;
        this.level = builder.level;
        this.timestamp = builder.timestamp;
        this.codeVersion = builder.codeVersion;
        this.platform = builder.platform;
        this.language = builder.language;
        this.framework = builder.framework;
        this.context = builder.context;
        this.request = builder.request;
        this.person = builder.person;
        this.server = builder.server;
        this.client = builder.client;
        this.custom = builder.custom != null ? builder.custom : null;
        this.fingerprint = builder.fingerprint;
        this.title = builder.title;
        this.uuid = builder.uuid;
        this.notifier = builder.notifier;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public Body getBody() {
        return this.body;
    }

    public Level getLevel() {
        return this.level;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getCodeVersion() {
        return this.codeVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getFramework() {
        return this.framework;
    }

    public String getContext() {
        return this.context;
    }

    public Request getRequest() {
        return this.request;
    }

    public Person getPerson() {
        return this.person;
    }

    public Client getClient() {
        return this.client;
    }

    public Server getServer() {
        return this.server;
    }

    public Map<String, Object> getCustom() {
        return this.custom;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.environment != null) {
            values.put("environment", this.environment);
        }
        if (this.body != null) {
            values.put("body", this.body);
        }
        if (this.level != null) {
            values.put("level", this.level.asJson());
        }
        if (this.timestamp != null) {
            values.put("timestamp", this.timestamp);
        }
        if (this.codeVersion != null) {
            values.put("code_version", this.codeVersion);
        }
        if (this.platform != null) {
            values.put("platform", this.platform);
        }
        if (this.language != null) {
            values.put("language", this.language);
        }
        if (this.framework != null) {
            values.put("framework", this.framework);
        }
        if (this.context != null) {
            values.put("context", this.context);
        }
        if (this.request != null) {
            values.put("request", this.request);
        }
        if (this.person != null) {
            values.put("person", this.person);
        }
        if (this.server != null) {
            values.put("server", this.server);
        }
        if (this.client != null) {
            values.put("client", this.client);
        }
        if (this.custom != null) {
            values.put("custom", this.custom);
        }
        if (this.fingerprint != null) {
            values.put("fingerprint", this.fingerprint);
        }
        if (this.title != null) {
            values.put("title", this.title);
        }
        if (this.uuid != null) {
            values.put("uuid", this.uuid);
        }
        if (this.notifier != null) {
            values.put("notifier", this.notifier);
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data = (Data)o;
        return Objects.equals(this.environment, data.environment) && Objects.equals(this.body, data.body) && this.level == data.level && Objects.equals(this.timestamp, data.timestamp) && Objects.equals(this.codeVersion, data.codeVersion) && Objects.equals(this.platform, data.platform) && Objects.equals(this.language, data.language) && Objects.equals(this.framework, data.framework) && Objects.equals(this.context, data.context) && Objects.equals(this.request, data.request) && Objects.equals(this.person, data.person) && Objects.equals(this.server, data.server) && Objects.equals(this.client, data.client) && Objects.equals(this.custom, data.custom) && Objects.equals(this.fingerprint, data.fingerprint) && Objects.equals(this.title, data.title) && Objects.equals(this.uuid, data.uuid) && Objects.equals(this.notifier, data.notifier);
    }

    public int hashCode() {
        return Objects.hash(this.environment, this.body, this.level, this.timestamp, this.codeVersion, this.platform, this.language, this.framework, this.context, this.request, this.person, this.server, this.client, this.custom, this.fingerprint, this.title, this.uuid, this.notifier);
    }

    public String toString() {
        return "Data{environment='" + this.environment + '\'' + ", body=" + this.body + ", level=" + this.level + ", timestamp=" + this.timestamp + ", codeVersion='" + this.codeVersion + '\'' + ", platform='" + this.platform + '\'' + ", language='" + this.language + '\'' + ", framework='" + this.framework + '\'' + ", context='" + this.context + '\'' + ", request=" + this.request + ", person=" + this.person + ", server=" + this.server + ", client=" + this.client + ", custom=" + this.custom + ", fingerprint='" + this.fingerprint + '\'' + ", title='" + this.title + '\'' + ", uuid='" + this.uuid + '\'' + ", notifier=" + this.notifier + '}';
    }

    public static final class Builder {
        private String environment;
        private Body body;
        private Level level;
        private Long timestamp;
        private String codeVersion;
        private String platform;
        private String language;
        private String framework;
        private String context;
        private Request request;
        private Person person;
        private Server server;
        private Client client;
        private Map<String, Object> custom;
        private String fingerprint;
        private String title;
        private String uuid;
        private Notifier notifier;

        public Builder() {
        }

        public Builder(Data data) {
            this.environment = data.environment;
            this.body = data.body;
            this.level = data.level;
            this.timestamp = data.timestamp;
            this.codeVersion = data.codeVersion;
            this.platform = data.platform;
            this.language = data.language;
            this.framework = data.framework;
            this.context = data.context;
            this.request = data.request;
            this.person = data.person;
            this.server = data.server;
            this.client = data.client;
            this.custom = data.custom;
            this.fingerprint = data.fingerprint;
            this.title = data.title;
            this.uuid = data.uuid;
            this.notifier = data.notifier;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder body(Body body) {
            this.body = body;
            return this;
        }

        public Builder level(String level) {
            this.level = Level.valueOf(level);
            return this;
        }

        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        public Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder codeVersion(String codeVersion) {
            this.codeVersion = codeVersion;
            return this;
        }

        public Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder person(Person person) {
            this.person = person;
            return this;
        }

        public Builder server(Server server) {
            this.server = server;
            return this;
        }

        public Builder client(Client client) {
            this.client = client;
            return this;
        }

        public Builder custom(Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder notifier(Notifier notifier) {
            this.notifier = notifier;
            return this;
        }

        public Data build() {
            return new Data(this);
        }
    }
}

