/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data.body;

import com.rollbar.api.json.JsonSerializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CodeContext
implements JsonSerializable {
    private final List<String> pre;
    private final List<String> post;

    private CodeContext(Builder builder) {
        this.pre = builder.pre != null ? Collections.unmodifiableList(builder.pre) : null;
        this.post = builder.post != null ? Collections.unmodifiableList(builder.post) : null;
    }

    public List<String> getPre() {
        return this.pre;
    }

    public List<String> getPost() {
        return this.post;
    }

    @Override
    public Object asJson() {
        HashMap<String, List<String>> values = new HashMap<String, List<String>>();
        if (this.pre != null) {
            values.put("pre", this.pre);
        }
        if (this.post != null) {
            values.put("post", this.post);
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeContext that = (CodeContext)o;
        if (this.pre != null ? !this.pre.equals(that.pre) : that.pre != null) {
            return false;
        }
        return this.post != null ? this.post.equals(that.post) : that.post == null;
    }

    public int hashCode() {
        int result = this.pre != null ? this.pre.hashCode() : 0;
        result = 31 * result + (this.post != null ? this.post.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CodeContext{pre=" + this.pre + ", post=" + this.post + '}';
    }

    public static final class Builder {
        private List<String> pre;
        private List<String> post;

        public Builder() {
        }

        public Builder(CodeContext codeContext) {
            this.pre = codeContext.pre;
            this.post = codeContext.post;
        }

        public Builder pre(List<String> pre) {
            this.pre = pre;
            return this;
        }

        public Builder post(List<String> post) {
            this.post = post;
            return this;
        }

        public CodeContext build() {
            return new CodeContext(this);
        }
    }
}

