/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.Data;
import java.util.HashMap;
import java.util.Map;

public class Payload
implements JsonSerializable {
    private final String accessToken;
    private final Data data;
    public final String json;

    private Payload(Builder builder) {
        this.accessToken = builder.accessToken;
        this.data = builder.data;
        this.json = null;
    }

    public Payload(String json) {
        this.accessToken = null;
        this.data = null;
        this.json = json;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Data getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payload data = (Payload)o;
        if (this.accessToken != null ? !this.accessToken.equals(data.accessToken) : data.accessToken != null) {
            return false;
        }
        return this.data != null ? this.data.equals(data.data) : data.data == null;
    }

    public int hashCode() {
        int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Payload{accessToken='" + this.accessToken + '\'' + ", data=" + this.data + '}';
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.accessToken != null) {
            values.put("access_token", this.accessToken);
        }
        if (this.data != null) {
            values.put("data", this.data);
        }
        return values;
    }

    public static class Builder {
        private String accessToken;
        private Data data;

        public Builder() {
        }

        public Builder(Payload payload) {
            this.accessToken = payload.accessToken;
            this.data = payload.data;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder data(Data data) {
            this.data = data;
            return this;
        }

        public Payload build() {
            return new Payload(this);
        }
    }
}

