/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.Client;
import com.rollbar.api.payload.data.Level;
import com.rollbar.api.payload.data.Notifier;
import com.rollbar.api.payload.data.Person;
import com.rollbar.api.payload.data.Request;
import com.rollbar.api.payload.data.Server;
import com.rollbar.api.payload.data.body.Body;
import java.util.HashMap;
import java.util.Map;

public class Data
implements JsonSerializable {
    private final String environment;
    private final Body body;
    private final Level level;
    private final Long timestamp;
    private final String codeVersion;
    private final String platform;
    private final String language;
    private final String framework;
    private final String context;
    private final Request request;
    private final Person person;
    private final Server server;
    private final Client client;
    private final Map<String, Object> custom;
    private final String fingerprint;
    private final String title;
    private final String uuid;
    private final boolean isUncaught;
    private final Notifier notifier;

    private Data(Builder builder) {
        this.environment = builder.environment;
        this.body = builder.body;
        this.level = builder.level;
        this.timestamp = builder.timestamp;
        this.codeVersion = builder.codeVersion;
        this.platform = builder.platform;
        this.language = builder.language;
        this.framework = builder.framework;
        this.context = builder.context;
        this.request = builder.request;
        this.person = builder.person;
        this.server = builder.server;
        this.client = builder.client;
        this.custom = builder.custom != null ? builder.custom : null;
        this.fingerprint = builder.fingerprint;
        this.title = builder.title;
        this.uuid = builder.uuid;
        this.isUncaught = builder.isUncaught;
        this.notifier = builder.notifier;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public Body getBody() {
        return this.body;
    }

    public Level getLevel() {
        return this.level;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getCodeVersion() {
        return this.codeVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getFramework() {
        return this.framework;
    }

    public String getContext() {
        return this.context;
    }

    public Request getRequest() {
        return this.request;
    }

    public Person getPerson() {
        return this.person;
    }

    public Client getClient() {
        return this.client;
    }

    public Server getServer() {
        return this.server;
    }

    public Map<String, Object> getCustom() {
        return this.custom;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isUncaught() {
        return this.isUncaught;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.environment != null) {
            values.put("environment", this.environment);
        }
        if (this.body != null) {
            values.put("body", this.body);
        }
        if (this.level != null) {
            values.put("level", this.level.asJson());
        }
        if (this.timestamp != null) {
            double timestampSecs = (double)this.timestamp.longValue() / 1000.0;
            values.put("timestamp", timestampSecs);
        }
        if (this.codeVersion != null) {
            values.put("code_version", this.codeVersion);
        }
        if (this.platform != null) {
            values.put("platform", this.platform);
        }
        if (this.language != null) {
            values.put("language", this.language);
        }
        if (this.framework != null) {
            values.put("framework", this.framework);
        }
        if (this.context != null) {
            values.put("context", this.context);
        }
        if (this.request != null) {
            values.put("request", this.request);
        }
        if (this.person != null) {
            values.put("person", this.person);
        }
        if (this.server != null) {
            values.put("server", this.server);
        }
        if (this.client != null) {
            values.put("client", this.client);
        }
        if (this.custom != null) {
            values.put("custom", this.custom);
        }
        if (this.fingerprint != null) {
            values.put("fingerprint", this.fingerprint);
        }
        if (this.title != null) {
            values.put("title", this.title);
        }
        if (this.uuid != null) {
            values.put("uuid", this.uuid);
        }
        if (this.notifier != null) {
            values.put("notifier", this.notifier);
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data = (Data)o;
        if (this.isUncaught != data.isUncaught) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(data.environment) : data.environment != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(data.body) : data.body != null) {
            return false;
        }
        if (this.level != data.level) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(data.timestamp) : data.timestamp != null) {
            return false;
        }
        if (this.codeVersion != null ? !this.codeVersion.equals(data.codeVersion) : data.codeVersion != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(data.platform) : data.platform != null) {
            return false;
        }
        if (this.language != null ? !this.language.equals(data.language) : data.language != null) {
            return false;
        }
        if (this.framework != null ? !this.framework.equals(data.framework) : data.framework != null) {
            return false;
        }
        if (this.context != null ? !this.context.equals(data.context) : data.context != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(data.request) : data.request != null) {
            return false;
        }
        if (this.person != null ? !this.person.equals(data.person) : data.person != null) {
            return false;
        }
        if (this.server != null ? !this.server.equals(data.server) : data.server != null) {
            return false;
        }
        if (this.client != null ? !this.client.equals(data.client) : data.client != null) {
            return false;
        }
        if (this.custom != null ? !this.custom.equals(data.custom) : data.custom != null) {
            return false;
        }
        if (this.fingerprint != null ? !this.fingerprint.equals(data.fingerprint) : data.fingerprint != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(data.title) : data.title != null) {
            return false;
        }
        if (this.uuid != null ? !this.uuid.equals(data.uuid) : data.uuid != null) {
            return false;
        }
        return this.notifier != null ? this.notifier.equals(data.notifier) : data.notifier == null;
    }

    public int hashCode() {
        int result = this.environment != null ? this.environment.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.codeVersion != null ? this.codeVersion.hashCode() : 0);
        result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.framework != null ? this.framework.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 31 * result + (this.request != null ? this.request.hashCode() : 0);
        result = 31 * result + (this.person != null ? this.person.hashCode() : 0);
        result = 31 * result + (this.server != null ? this.server.hashCode() : 0);
        result = 31 * result + (this.client != null ? this.client.hashCode() : 0);
        result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
        result = 31 * result + (this.fingerprint != null ? this.fingerprint.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.uuid != null ? this.uuid.hashCode() : 0);
        result = 31 * result + (this.isUncaught ? 1 : 0);
        result = 31 * result + (this.notifier != null ? this.notifier.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Data{environment='" + this.environment + '\'' + ", body=" + this.body + ", level=" + this.level + ", timestamp=" + this.timestamp + ", codeVersion='" + this.codeVersion + '\'' + ", platform='" + this.platform + '\'' + ", language='" + this.language + '\'' + ", framework='" + this.framework + '\'' + ", context='" + this.context + '\'' + ", request=" + this.request + ", person=" + this.person + ", server=" + this.server + ", client=" + this.client + ", custom=" + this.custom + ", fingerprint='" + this.fingerprint + '\'' + ", title='" + this.title + '\'' + ", uuid='" + this.uuid + '\'' + ", isUncaught='" + this.isUncaught + '\'' + ", notifier=" + this.notifier + '}';
    }

    public static final class Builder {
        private String environment;
        private Body body;
        private Level level;
        private Long timestamp;
        private String codeVersion;
        private String platform;
        private String language;
        private String framework;
        private String context;
        private Request request;
        private Person person;
        private Server server;
        private Client client;
        private Map<String, Object> custom;
        private String fingerprint;
        private String title;
        private String uuid;
        private boolean isUncaught;
        private Notifier notifier;

        public Builder() {
        }

        public Builder(Data data) {
            this.environment = data.environment;
            this.body = data.body;
            this.level = data.level;
            this.timestamp = data.timestamp;
            this.codeVersion = data.codeVersion;
            this.platform = data.platform;
            this.language = data.language;
            this.framework = data.framework;
            this.context = data.context;
            this.request = data.request;
            this.person = data.person;
            this.server = data.server;
            this.client = data.client;
            this.custom = data.custom;
            this.fingerprint = data.fingerprint;
            this.title = data.title;
            this.uuid = data.uuid;
            this.isUncaught = data.isUncaught;
            this.notifier = data.notifier;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder body(Body body) {
            this.body = body;
            return this;
        }

        public Builder level(String level) {
            this.level = Level.valueOf(level);
            return this;
        }

        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        public Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder codeVersion(String codeVersion) {
            this.codeVersion = codeVersion;
            return this;
        }

        public Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder person(Person person) {
            this.person = person;
            return this;
        }

        public Builder server(Server server) {
            this.server = server;
            return this;
        }

        public Builder client(Client client) {
            this.client = client;
            return this;
        }

        public Builder custom(Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder isUncaught(boolean isUncaught) {
            this.isUncaught = isUncaught;
            return this;
        }

        public Builder notifier(Notifier notifier) {
            this.notifier = notifier;
            return this;
        }

        public Data build() {
            return new Data(this);
        }
    }
}

