/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data.body;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.body.CodeContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Frame
implements JsonSerializable {
    private final String filename;
    private final Integer lineNumber;
    private final Integer columnNumber;
    private final String method;
    private final String code;
    private final String className;
    private final CodeContext context;
    private final List<Object> args;
    private final Map<String, Object> keywordArgs;
    private final Map<String, Object> locals;

    private Frame(Builder builder) {
        this.filename = builder.filename;
        this.lineNumber = builder.lineNumber;
        this.columnNumber = builder.columnNumber;
        this.method = builder.method;
        this.code = builder.code;
        this.className = builder.className;
        this.context = builder.context;
        this.args = builder.args != null ? Collections.unmodifiableList(new ArrayList(builder.args)) : null;
        this.keywordArgs = builder.keywordArgs != null ? Collections.unmodifiableMap(new HashMap(builder.keywordArgs)) : null;
        this.locals = builder.locals != null ? Collections.unmodifiableMap(new HashMap(builder.locals)) : null;
    }

    public String getFilename() {
        return this.filename;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public String getMethod() {
        return this.method;
    }

    public String getCode() {
        return this.code;
    }

    public String getClassName() {
        return this.className;
    }

    public CodeContext getContext() {
        return this.context;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public Map<String, Object> getKeywordArgs() {
        return this.keywordArgs;
    }

    public Map<String, Object> getLocals() {
        return this.locals;
    }

    @Override
    public Object asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("filename", this.filename != null ? this.filename : "[unknown]");
        if (this.lineNumber != null) {
            values.put("lineno", this.lineNumber);
        }
        if (this.columnNumber != null) {
            values.put("colno", this.columnNumber);
        }
        if (this.method != null) {
            values.put("method", this.method);
        }
        if (this.code != null) {
            values.put("code", this.code);
        }
        if (this.className != null) {
            values.put("class_name", this.className);
        }
        if (this.context != null) {
            values.put("context", this.context);
        }
        if (this.args != null) {
            values.put("args", this.args);
        }
        if (this.keywordArgs != null) {
            values.put("kwargs", this.keywordArgs);
        }
        if (this.locals != null) {
            values.put("locals", this.locals);
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Frame frame = (Frame)o;
        if (this.filename != null ? !this.filename.equals(frame.filename) : frame.filename != null) {
            return false;
        }
        if (this.lineNumber != null ? !this.lineNumber.equals(frame.lineNumber) : frame.lineNumber != null) {
            return false;
        }
        if (this.columnNumber != null ? !this.columnNumber.equals(frame.columnNumber) : frame.columnNumber != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(frame.method) : frame.method != null) {
            return false;
        }
        if (this.code != null ? !this.code.equals(frame.code) : frame.code != null) {
            return false;
        }
        if (this.className != null ? !this.className.equals(frame.className) : frame.className != null) {
            return false;
        }
        if (this.context != null ? !this.context.equals(frame.context) : frame.context != null) {
            return false;
        }
        if (this.args != null ? !this.args.equals(frame.args) : frame.args != null) {
            return false;
        }
        if (this.keywordArgs != null ? !this.keywordArgs.equals(frame.keywordArgs) : frame.keywordArgs != null) {
            return false;
        }
        return this.locals != null ? this.locals.equals(frame.locals) : frame.locals == null;
    }

    public int hashCode() {
        int result = this.filename != null ? this.filename.hashCode() : 0;
        result = 31 * result + (this.lineNumber != null ? this.lineNumber.hashCode() : 0);
        result = 31 * result + (this.columnNumber != null ? this.columnNumber.hashCode() : 0);
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
        result = 31 * result + (this.keywordArgs != null ? this.keywordArgs.hashCode() : 0);
        result = 31 * result + (this.locals != null ? this.locals.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Frame{filename='" + this.filename + '\'' + ", lineNumber=" + this.lineNumber + ", columnNumber=" + this.columnNumber + ", method='" + this.method + '\'' + ", code='" + this.code + '\'' + ", className='" + this.className + '\'' + ", context=" + this.context + ", args=" + this.args + ", keywordArgs=" + this.keywordArgs + ", locals=" + this.locals + '}';
    }

    public static final class Builder {
        private String filename;
        private Integer lineNumber;
        private Integer columnNumber;
        private String method;
        private String code;
        private String className;
        private CodeContext context;
        private List<Object> args;
        private Map<String, Object> keywordArgs;
        private Map<String, Object> locals;

        public Builder() {
        }

        public Builder(Frame frame) {
            this.filename = frame.filename;
            this.lineNumber = frame.lineNumber;
            this.columnNumber = frame.columnNumber;
            this.method = frame.method;
            this.code = frame.code;
            this.className = frame.className;
            this.context = frame.context;
            this.args = frame.args;
            this.keywordArgs = frame.keywordArgs;
            this.locals = frame.locals;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder columnNumber(Integer columnNumber) {
            this.columnNumber = columnNumber;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder context(CodeContext context) {
            this.context = context;
            return this;
        }

        public Builder args(List<Object> args) {
            this.args = args;
            return this;
        }

        public Builder keywordArgs(Map<String, Object> keywordArgs) {
            this.keywordArgs = keywordArgs;
            return this;
        }

        public Builder locals(Map<String, Object> locals) {
            this.locals = locals;
            return this;
        }

        public Frame build() {
            return new Frame(this);
        }
    }
}

