/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data;

import com.rollbar.api.json.JsonSerializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Client
implements JsonSerializable {
    private static final long serialVersionUID = 1975664872679919021L;
    private final Map<String, Map<String, Object>> data;
    private final Map<String, Object> topLevelData;

    private Client(Builder builder) {
        this.data = Collections.unmodifiableMap(new HashMap(builder.data));
        this.topLevelData = Collections.unmodifiableMap(new HashMap(builder.topLevelData));
    }

    public Map<String, Map<String, Object>> getData() {
        return this.data;
    }

    public Map<String, Object> getTopLevelData() {
        return this.topLevelData;
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.putAll(this.data);
        values.putAll(this.topLevelData);
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        if (this.data != null ? !this.data.equals(client.data) : client.data != null) {
            return false;
        }
        return this.topLevelData != null ? this.topLevelData.equals(client.topLevelData) : client.topLevelData == null;
    }

    public int hashCode() {
        int result = this.data != null ? this.data.hashCode() : 0;
        result = 31 * result + (this.topLevelData != null ? this.topLevelData.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Client{topLevelData='" + this.topLevelData + '\'' + ", data='" + this.data + '\'' + '}';
    }

    public static final class Builder {
        private Map<String, Map<String, Object>> data;
        private Map<String, Object> topLevelData;

        public Builder() {
            this.data = new HashMap<String, Map<String, Object>>();
            this.topLevelData = new HashMap<String, Object>();
        }

        public Builder(Client client) {
            this.data = client.data;
            this.topLevelData = client.topLevelData;
        }

        public Builder addClient(String clientName, String property, Object value) {
            Map<String, Object> values = this.data.get(clientName);
            if (values == null) {
                values = new HashMap<String, Object>();
            }
            values.put(property, value);
            this.data.put(clientName, values);
            return this;
        }

        public Builder addClient(String clientName, Map<String, Object> properties) {
            Map<String, Object> values = this.data.get(clientName);
            if (values == null) {
                values = new HashMap<String, Object>();
            }
            values.putAll(properties);
            this.data.put(clientName, values);
            return this;
        }

        public Builder addTopLevel(String property, Object value) {
            this.topLevelData.put(property, value);
            return this;
        }

        public Client build() {
            return new Client(this);
        }
    }
}

