/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data;

import com.rollbar.api.json.JsonSerializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Person
implements JsonSerializable {
    private static final long serialVersionUID = -1589474813294741393L;
    private final String id;
    private final String username;
    private final String email;
    private final Map<String, Object> metadata;

    private Person(Builder builder) {
        this.id = builder.id;
        this.username = builder.username;
        this.email = builder.email;
        this.metadata = builder.metadata != null ? Collections.unmodifiableMap(new HashMap(builder.metadata)) : null;
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.metadata != null) {
            values.putAll(this.metadata);
        }
        if (this.id != null) {
            values.put("id", this.id);
        }
        if (this.username != null) {
            values.put("username", this.username);
        }
        if (this.email != null) {
            values.put("email", this.email);
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.id != null ? !this.id.equals(person.id) : person.id != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(person.username) : person.username != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(person.metadata) : person.metadata != null) {
            return false;
        }
        return this.email != null ? this.email.equals(person.email) : person.email == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Person{id='" + this.id + '\'' + ", username='" + this.username + '\'' + ", email='" + this.email + '\'' + ", metadata='" + this.metadata + '\'' + '}';
    }

    public static final class Builder {
        private String id;
        private String username;
        private String email;
        private Map<String, Object> metadata;

        public Builder() {
        }

        public Builder(Person person) {
            this.id = person.id;
            this.username = person.username;
            this.email = person.email;
            this.metadata = person.metadata;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Person build() {
            return new Person(this);
        }
    }
}

