/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data;

import com.rollbar.api.json.JsonSerializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Request
implements JsonSerializable {
    private static final long serialVersionUID = 3552594955980476301L;
    private final String url;
    private final String method;
    private final Map<String, String> headers;
    private final Map<String, String> params;
    private final Map<String, List<String>> get;
    private final String queryString;
    private final Map<String, Object> post;
    private final String body;
    private final String userIp;
    private final Map<String, Object> metadata;

    private Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers;
        this.params = builder.params;
        this.get = builder.get;
        this.queryString = builder.queryString;
        this.post = builder.post;
        this.body = builder.body;
        this.userIp = builder.userIp;
        this.metadata = builder.metadata != null ? Collections.unmodifiableMap(new HashMap(builder.metadata)) : null;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, List<String>> getGet() {
        return this.get;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, Object> getPost() {
        return this.post;
    }

    public String getBody() {
        return this.body;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.metadata != null) {
            values.putAll(this.metadata);
        }
        if (this.url != null) {
            values.put("url", this.url);
        }
        if (this.method != null) {
            values.put("method", this.method);
        }
        if (this.headers != null) {
            values.put("headers", this.headers);
        }
        if (this.params != null) {
            values.put("params", this.params);
        }
        if (this.get != null) {
            values.put("get", this.processGetParams(this.get));
        }
        if (this.queryString != null) {
            values.put("query_string", this.queryString);
        }
        if (this.post != null) {
            values.put("post", this.post);
        }
        if (this.body != null) {
            values.put("body", this.body);
        }
        if (this.userIp != null) {
            values.put("user_ip", this.userIp);
        }
        return values;
    }

    private Map<String, Object> processGetParams(Map<String, List<String>> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String k = entry.getKey();
            List<String> v = entry.getValue();
            if (v.size() == 1) {
                result.put(k, v.get(0));
                continue;
            }
            result.put(k, v);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        if (this.url != null ? !this.url.equals(request.url) : request.url != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(request.method) : request.method != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(request.headers) : request.headers != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(request.params) : request.params != null) {
            return false;
        }
        if (this.get != null ? !this.get.equals(request.get) : request.get != null) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(request.queryString) : request.queryString != null) {
            return false;
        }
        if (this.post != null ? !this.post.equals(request.post) : request.post != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(request.body) : request.body != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(request.metadata) : request.metadata != null) {
            return false;
        }
        return this.userIp != null ? this.userIp.equals(request.userIp) : request.userIp == null;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.get != null ? this.get.hashCode() : 0);
        result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
        result = 31 * result + (this.post != null ? this.post.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.userIp != null ? this.userIp.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Request{url='" + this.url + '\'' + ", method='" + this.method + '\'' + ", headers=" + this.headers + ", params=" + this.params + ", get=" + this.get + ", queryString='" + this.queryString + '\'' + ", post=" + this.post + ", body='" + this.body + '\'' + ", userIp='" + this.userIp + '\'' + ", metadata='" + this.metadata + '\'' + '}';
    }

    public static final class Builder {
        private String url;
        private String method;
        private Map<String, String> headers;
        private Map<String, String> params;
        private Map<String, List<String>> get;
        private String queryString;
        private Map<String, Object> post;
        private String body;
        private String userIp;
        private Map<String, Object> metadata;

        public Builder() {
        }

        public Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.headers = request.headers;
            this.params = request.params;
            this.get = request.get;
            this.queryString = request.queryString;
            this.post = request.post;
            this.body = request.body;
            this.userIp = request.userIp;
            this.metadata = request.metadata;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder get(Map<String, List<String>> get) {
            this.get = get;
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder post(Map<String, Object> post) {
            this.post = post;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder userIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }
}

