/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data.body;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.body.BodyContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Message
implements BodyContent,
JsonSerializable {
    private static final long serialVersionUID = 1729529829545820666L;
    private final String body;
    private final Map<String, Object> metadata;

    private Message(Builder builder) {
        this.body = builder.body;
        this.metadata = builder.metadata != null ? Collections.unmodifiableMap(new HashMap(builder.metadata)) : null;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getKeyName() {
        return "message";
    }

    @Override
    public Object asJson() {
        HashMap<String, Object> message = new HashMap<String, Object>();
        if (this.metadata != null) {
            message.putAll(this.metadata);
        }
        message.put("body", this.body);
        return message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        if (this.body != null ? !this.body.equals(message.body) : message.body != null) {
            return false;
        }
        return this.metadata != null ? this.metadata.equals(message.metadata) : message.metadata == null;
    }

    public int hashCode() {
        int result = this.body != null ? this.body.hashCode() : 0;
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Message{body='" + this.body + '\'' + ", metadata='" + this.metadata + '\'' + '}';
    }

    public static final class Builder {
        private String body;
        private Map<String, Object> metadata;

        public Builder() {
        }

        public Builder(Message message) {
            this.body = message.body;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

