/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data.body;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.TelemetryEvent;
import com.rollbar.api.payload.data.body.BodyContent;
import com.rollbar.api.truncation.StringTruncatable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Body
implements JsonSerializable,
StringTruncatable<Body> {
    private static final long serialVersionUID = -2783273957046705016L;
    private final BodyContent bodyContent;
    private final List<TelemetryEvent> telemetryEvents;

    private Body(Builder builder) {
        this.bodyContent = builder.bodyContent;
        this.telemetryEvents = builder.telemetryEvents;
    }

    public BodyContent getContents() {
        return this.bodyContent;
    }

    @Override
    public Object asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.bodyContent != null) {
            values.put(this.bodyContent.getKeyName(), this.bodyContent);
        }
        if (this.telemetryEvents != null) {
            values.put("telemetry", this.telemetryEvents);
        }
        return values;
    }

    @Override
    public Body truncateStrings(int maxSize) {
        if (this.bodyContent != null) {
            return new Builder(this).bodyContent((BodyContent)this.bodyContent.truncateStrings(maxSize)).build();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Body)) {
            return false;
        }
        Body body = (Body)o;
        return Objects.equals(this.bodyContent, body.bodyContent) && Objects.equals(this.telemetryEvents, body.telemetryEvents);
    }

    public int hashCode() {
        return Objects.hash(this.bodyContent, this.telemetryEvents);
    }

    public String toString() {
        return "Body{bodyContent=" + this.bodyContent + ", telemetry=" + this.telemetryEvents + '}';
    }

    public static final class Builder {
        private BodyContent bodyContent;
        private List<TelemetryEvent> telemetryEvents;

        public Builder() {
        }

        public Builder(Body body) {
            this.bodyContent = body.bodyContent;
            this.telemetryEvents = body.telemetryEvents;
        }

        public Builder bodyContent(BodyContent bodyContent) {
            this.bodyContent = bodyContent;
            return this;
        }

        public Builder telemetryEvents(List<TelemetryEvent> telemetryEvents) {
            this.telemetryEvents = telemetryEvents;
            return this;
        }

        public Body build() {
            return new Body(this);
        }
    }
}

