/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.Level;
import com.rollbar.api.payload.data.Source;
import com.rollbar.api.payload.data.TelemetryType;
import com.rollbar.api.truncation.StringTruncatable;
import com.rollbar.api.truncation.TruncationHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TelemetryEvent
implements JsonSerializable,
StringTruncatable<TelemetryEvent> {
    private final TelemetryType type;
    private final Level level;
    private final Long timestamp;
    private final Map<String, String> body;
    private final Source source;
    private static final long serialVersionUID = 2843361810242481727L;

    public TelemetryEvent(TelemetryType telemetryType, Level level, Long timestamp, Source source, Map<String, String> body) {
        this.type = telemetryType;
        this.timestamp = timestamp;
        this.level = level;
        this.source = source;
        this.body = new HashMap<String, String>(body);
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("type", this.type.asJson());
        values.put("level", this.level.asJson());
        values.put("source", this.source.asJson());
        values.put("timestamp_ms", this.timestamp);
        values.put("body", this.body);
        return values;
    }

    @Override
    public TelemetryEvent truncateStrings(int maxLength) {
        return new TelemetryEvent(this.type, this.level, this.timestamp, this.source, TruncationHelper.truncateStringsInStringMap(this.body, maxLength));
    }

    public String toString() {
        return "TelemetryEvent{type='" + this.type.asJson() + '\'' + ", level='" + this.level.asJson() + '\'' + ", source='" + this.source + '\'' + ", timestamp_ms=" + this.timestamp + ", body=" + this.body + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryEvent that = (TelemetryEvent)o;
        return this.type == that.type && this.level == that.level && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.body, that.body) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.level, this.timestamp, this.body, this.source);
    }
}

