/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data.body;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.TelemetryEvent;
import com.rollbar.api.payload.data.body.BodyContent;
import com.rollbar.api.payload.data.body.RollbarThread;
import com.rollbar.api.truncation.StringTruncatable;
import com.rollbar.api.truncation.TruncationHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Body
implements JsonSerializable,
StringTruncatable<Body> {
    private static final long serialVersionUID = -2783273957046705016L;
    private final BodyContent bodyContent;
    private final List<TelemetryEvent> telemetryEvents;
    private final List<RollbarThread> rollbarThreads;

    private Body(Builder builder) {
        this.bodyContent = builder.bodyContent;
        this.telemetryEvents = builder.telemetryEvents;
        this.rollbarThreads = builder.rollbarThreads;
    }

    public BodyContent getContents() {
        return this.bodyContent;
    }

    public List<RollbarThread> getRollbarThreads() {
        return this.rollbarThreads;
    }

    public List<TelemetryEvent> getTelemetryEvents() {
        return this.telemetryEvents;
    }

    @Override
    public Object asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.bodyContent != null) {
            values.put(this.bodyContent.getKeyName(), this.bodyContent);
        }
        if (this.telemetryEvents != null) {
            values.put("telemetry", this.telemetryEvents);
        }
        if (this.rollbarThreads != null) {
            values.put("threads", this.rollbarThreads);
        }
        return values;
    }

    @Override
    public Body truncateStrings(int maxSize) {
        if (this.bodyContent != null) {
            return new Builder(this).bodyContent((BodyContent)this.bodyContent.truncateStrings(maxSize)).telemetryEvents(TruncationHelper.truncate(this.telemetryEvents, maxSize)).rollbarThreads(TruncationHelper.truncate(this.rollbarThreads, maxSize)).build();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Body)) {
            return false;
        }
        Body body = (Body)o;
        return Objects.equals(this.bodyContent, body.bodyContent) && Objects.equals(this.telemetryEvents, body.telemetryEvents) && Objects.equals(this.rollbarThreads, body.rollbarThreads);
    }

    public int hashCode() {
        return Objects.hash(this.bodyContent, this.telemetryEvents, this.rollbarThreads);
    }

    public String toString() {
        return "Body{bodyContent=" + this.bodyContent + ", telemetry=" + this.telemetryEvents + ", threads=" + this.rollbarThreads + '}';
    }

    public static final class Builder {
        private BodyContent bodyContent;
        private List<TelemetryEvent> telemetryEvents;
        private List<RollbarThread> rollbarThreads;

        public Builder() {
        }

        public Builder(Body body) {
            this.bodyContent = body.bodyContent;
            this.telemetryEvents = body.telemetryEvents;
            this.rollbarThreads = body.rollbarThreads;
        }

        public Builder bodyContent(BodyContent bodyContent) {
            this.bodyContent = bodyContent;
            return this;
        }

        public Builder telemetryEvents(List<TelemetryEvent> telemetryEvents) {
            this.telemetryEvents = telemetryEvents;
            return this;
        }

        public Builder rollbarThreads(List<RollbarThread> rollbarThreads) {
            this.rollbarThreads = rollbarThreads;
            return this;
        }

        public Body build() {
            return new Body(this);
        }
    }
}

