/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data.body;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.body.Group;
import com.rollbar.api.truncation.StringTruncatable;
import java.util.HashMap;
import java.util.Objects;

public class RollbarThread
implements JsonSerializable,
StringTruncatable<RollbarThread> {
    private final String name;
    private final String id;
    private final String priority;
    private final String state;
    private final boolean isMain;
    private final Group group;

    public RollbarThread(Thread thread, Group group) {
        this.name = thread.getName();
        this.id = String.valueOf(thread.getId());
        this.priority = String.valueOf(thread.getPriority());
        this.state = thread.getState().toString();
        this.isMain = this.isMain(thread.getName());
        this.group = group;
    }

    public RollbarThread(String name, String id, String priority, String state, Group group) {
        this.isMain = this.isMain(name);
        this.name = name;
        this.id = id;
        this.priority = priority;
        this.state = state;
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    public String getState() {
        return this.state;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMain() {
        return this.isMain;
    }

    private boolean isMain(String string) {
        return "main".equals(string);
    }

    @Override
    public Object asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("name", this.name);
        values.put("id", this.id);
        values.put("priority", this.priority);
        values.put("state", this.state);
        values.put("is_main", this.isMain);
        values.put("group", this.group);
        return values;
    }

    @Override
    public RollbarThread truncateStrings(int maxLength) {
        return new RollbarThread(this.name, this.id, this.priority, this.state, this.group.truncateStrings(maxLength));
    }

    public String toString() {
        return "RollbarThread{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", priority='" + this.priority + '\'' + ", state='" + this.state + '\'' + ", isMain='" + this.isMain + '\'' + ", group='" + this.group + '}';
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollbarThread that = (RollbarThread)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id) && Objects.equals(this.priority, that.priority) && Objects.equals(this.state, that.state) && Objects.equals(this.isMain, that.isMain) && Objects.equals(this.group, that.group);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.priority, this.state, this.isMain, this.group);
    }

    public static final class Builder {
        private final String name;
        private final String id;
        private final String priority;
        private final String state;
        private Group group;

        public Builder(RollbarThread rollbarThread) {
            this.name = rollbarThread.name;
            this.id = rollbarThread.id;
            this.priority = rollbarThread.priority;
            this.state = rollbarThread.state;
            this.group = rollbarThread.group;
        }

        public Builder group(Group group) {
            this.group = group;
            return this;
        }

        public RollbarThread build() {
            return new RollbarThread(this.name, this.id, this.priority, this.state, this.group);
        }
    }
}

