/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.truncation;

import com.rollbar.api.annotations.Unstable;
import com.rollbar.api.truncation.StringTruncatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Unstable
public class TruncationHelper {
    public static List<String> truncateStringsInList(List<String> values, int maxLength) {
        if (values == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(values.size());
        for (String value : values) {
            result.add(TruncationHelper.truncateString(value, maxLength));
        }
        return result;
    }

    public static <T extends StringTruncatable<T>> List<T> truncate(List<T> values, int maxLength) {
        if (values == null) {
            return null;
        }
        ArrayList<StringTruncatable> result = new ArrayList<StringTruncatable>(values.size());
        for (StringTruncatable value : values) {
            result.add((StringTruncatable)value.truncateStrings(maxLength));
        }
        return result;
    }

    public static List<Object> truncateStringsInObjectList(List<Object> values, int maxLength) {
        if (values == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(values.size());
        for (Object value : values) {
            if (value instanceof String) {
                result.add(TruncationHelper.truncateString((String)value, maxLength));
                continue;
            }
            result.add(value);
        }
        return result;
    }

    public static <T extends StringTruncatable<T>> T truncateStringsInObject(T value, int maxLength) {
        if (value == null) {
            return null;
        }
        return (T)((StringTruncatable)value.truncateStrings(maxLength));
    }

    public static String truncateString(String original, int maxLength) {
        if (original == null || original.length() <= maxLength) {
            return original;
        }
        return original.substring(0, maxLength);
    }

    public static Map<String, List<String>> truncateStringsInStringListMap(Map<String, List<String>> values, int maxLength) {
        if (values == null || values.isEmpty()) {
            return values;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : values.entrySet()) {
            result.put(entry.getKey(), TruncationHelper.truncateStringsInList(entry.getValue(), maxLength));
        }
        return result;
    }

    public static Map<String, String> truncateStringsInStringMap(Map<String, String> values, int maxLength) {
        if (values == null || values.isEmpty()) {
            return values;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            result.put(entry.getKey(), TruncationHelper.truncateString(entry.getValue(), maxLength));
        }
        return result;
    }

    public static Map<String, Map<String, Object>> truncateStringsInNestedMap(Map<String, Map<String, Object>> values, int maxLength) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : values.entrySet()) {
            result.put(entry.getKey(), TruncationHelper.truncateStringsInMap(entry.getValue(), maxLength));
        }
        return result;
    }

    public static Map<String, Object> truncateStringsInMap(Map<String, Object> values, int maxLength) {
        if (values == null || values.isEmpty()) {
            return values;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                value = TruncationHelper.truncateString((String)value, maxLength);
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }
}

