/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.web.provider;

import com.rollbar.api.payload.data.Request;
import com.rollbar.notifier.provider.Provider;
import com.rollbar.web.listener.RollbarRequestListener;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestProvider
implements Provider<Request> {
    private final String userIpHeaderName;
    private final int captureIp;
    public static final String CAPTURE_IP_ANONYMIZE = "anonymize";
    public static final String CAPTURE_IP_NONE = "none";
    private static final int CAPTURE_IP_TYPE_FULL = 0;
    private static final int CAPTURE_IP_TYPE_ANONYMIZE = 1;
    private static final int CAPTURE_IP_TYPE_NONE = 2;

    RequestProvider(Builder builder) {
        this.userIpHeaderName = builder.userIpHeaderName;
        this.captureIp = builder.captureIp != null ? (builder.captureIp.equals(CAPTURE_IP_ANONYMIZE) ? 1 : (builder.captureIp.equals(CAPTURE_IP_NONE) ? 2 : 0)) : 0;
    }

    public Request provide() {
        HttpServletRequest req = RollbarRequestListener.getServletRequest();
        if (req != null) {
            Request request = new Request.Builder().url(RequestProvider.url(req)).method(RequestProvider.method(req)).headers(RequestProvider.headers(req)).get(RequestProvider.getParams(req)).post(RequestProvider.postParams(req)).queryString(RequestProvider.queryString(req)).userIp(this.userIp(req)).build();
            return request;
        }
        return null;
    }

    private String userIp(HttpServletRequest request) {
        String rawIp = this.userIpHeaderName == null || "".equals(this.userIpHeaderName) ? request.getRemoteAddr() : request.getHeader(this.userIpHeaderName);
        if (rawIp == null) {
            return rawIp;
        }
        if (this.captureIp == 0) {
            return rawIp;
        }
        if (this.captureIp == 1) {
            if (rawIp.contains(".")) {
                String[] parts = rawIp.split("\\.");
                if (parts.length < 3) {
                    return rawIp;
                }
                StringBuffer ip = new StringBuffer(parts[0]);
                ip.append(".");
                ip.append(parts[1]);
                ip.append(".");
                ip.append(parts[2]);
                ip.append(".0");
                return ip.toString();
            }
            if (rawIp.contains(":")) {
                String[] parts = rawIp.split(":");
                if (parts.length < 3) {
                    return rawIp;
                }
                StringBuffer ip = new StringBuffer(parts[0]);
                ip.append(":");
                ip.append(parts[1]);
                ip.append(":");
                ip.append(parts[2]);
                ip.append(":0000:0000:0000:0000:0000");
                return ip.toString();
            }
            return rawIp;
        }
        if (this.captureIp == 2) {
            return null;
        }
        return null;
    }

    private static String url(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    private static String method(HttpServletRequest request) {
        return request.getMethod();
    }

    private static Map<String, String> headers(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, request.getHeader(headerName));
        }
        return headers;
    }

    private static Map<String, List<String>> getParams(HttpServletRequest request) {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            return RequestProvider.params(request);
        }
        return null;
    }

    private static Map<String, Object> postParams(HttpServletRequest request) {
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            Map<String, List<String>> params = RequestProvider.params(request);
            HashMap<String, Object> postParams = new HashMap<String, Object>();
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                if (entry.getValue() != null && entry.getValue().size() == 1) {
                    postParams.put(entry.getKey(), entry.getValue().get(0));
                    continue;
                }
                postParams.put(entry.getKey(), entry.getValue());
            }
            return postParams;
        }
        return null;
    }

    private static Map<String, List<String>> params(HttpServletRequest request) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        Map paramNames = request.getParameterMap();
        for (Map.Entry param : paramNames.entrySet()) {
            if (param.getValue() == null || ((String[])param.getValue()).length <= 0) continue;
            params.put((String)param.getKey(), Arrays.asList((String[])param.getValue()));
        }
        return params;
    }

    private static String queryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    public static final class Builder {
        private String userIpHeaderName;
        private String captureIp;

        public Builder userIpHeaderName(String userIpHeaderName) {
            this.userIpHeaderName = userIpHeaderName;
            return this;
        }

        public Builder captureIp(String captureIp) {
            this.captureIp = captureIp;
            return this;
        }

        public RequestProvider build() {
            return new RequestProvider(this);
        }
    }
}

