/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.config;

import com.rollbar.api.payload.data.Client;
import com.rollbar.api.payload.data.Notifier;
import com.rollbar.api.payload.data.Person;
import com.rollbar.api.payload.data.Request;
import com.rollbar.api.payload.data.Server;
import com.rollbar.notifier.config.Config;
import com.rollbar.notifier.filter.Filter;
import com.rollbar.notifier.fingerprint.FingerprintGenerator;
import com.rollbar.notifier.provider.Provider;
import com.rollbar.notifier.provider.notifier.NotifierProvider;
import com.rollbar.notifier.provider.timestamp.TimestampProvider;
import com.rollbar.notifier.sender.Sender;
import com.rollbar.notifier.sender.SyncSender;
import com.rollbar.notifier.transformer.Transformer;
import com.rollbar.notifier.uuid.UuidGenerator;
import java.util.Map;

public class ConfigBuilder {
    private String accessToken;
    private String environment;
    private String codeVersion;
    private String platform;
    private String language;
    private String framework;
    private Provider<String> context;
    private Provider<Request> request;
    private Provider<Person> person;
    private Provider<Server> server;
    private Provider<Client> client;
    private Provider<Map<String, Object>> custom;
    private Provider<Notifier> notifier;
    private Provider<Long> timestamp;
    private Filter filter;
    private Transformer transformer;
    private FingerprintGenerator fingerPrintGenerator;
    private UuidGenerator uuidGenerator;
    private Sender sender;
    private boolean handleUncaughtErrors;

    private ConfigBuilder(String accessToken) {
        this.accessToken = accessToken;
        this.language = "java";
        this.handleUncaughtErrors = true;
    }

    private ConfigBuilder(Config config) {
        this.accessToken = config.accessToken();
        this.environment = config.environment();
        this.codeVersion = config.codeVersion();
        this.platform = config.platform();
        this.language = config.language();
        this.framework = config.framework();
        this.context = config.context();
        this.request = config.request();
        this.person = config.person();
        this.server = config.server();
        this.client = config.client();
        this.custom = config.custom();
        this.notifier = config.notifier();
        this.timestamp = config.timestamp();
        this.filter = config.filter();
        this.transformer = config.transformer();
        this.fingerPrintGenerator = config.fingerPrintGenerator();
        this.uuidGenerator = config.uuidGenerator();
        this.sender = config.sender();
        this.handleUncaughtErrors = config.handleUncaughtErrors();
    }

    public static ConfigBuilder withAccessToken(String accessToken) {
        return new ConfigBuilder(accessToken);
    }

    public static ConfigBuilder withConfig(Config config) {
        return new ConfigBuilder(config);
    }

    public ConfigBuilder accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public ConfigBuilder environment(String environment) {
        this.environment = environment;
        return this;
    }

    public ConfigBuilder codeVersion(String codeVersion) {
        this.codeVersion = codeVersion;
        return this;
    }

    public ConfigBuilder platform(String platform) {
        this.platform = platform;
        return this;
    }

    public ConfigBuilder language(String language) {
        this.language = language;
        return this;
    }

    public ConfigBuilder framework(String framework) {
        this.framework = framework;
        return this;
    }

    public ConfigBuilder context(Provider<String> context) {
        this.context = context;
        return this;
    }

    public ConfigBuilder request(Provider<Request> request) {
        this.request = request;
        return this;
    }

    public ConfigBuilder person(Provider<Person> person) {
        this.person = person;
        return this;
    }

    public ConfigBuilder server(Provider<Server> server) {
        this.server = server;
        return this;
    }

    public ConfigBuilder client(Provider<Client> client) {
        this.client = client;
        return this;
    }

    public ConfigBuilder custom(Provider<Map<String, Object>> custom) {
        this.custom = custom;
        return this;
    }

    public ConfigBuilder notifier(Provider<Notifier> notifier) {
        this.notifier = notifier;
        return this;
    }

    public ConfigBuilder timestamp(Provider<Long> timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ConfigBuilder filter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public ConfigBuilder transformer(Transformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public ConfigBuilder fingerPrintGenerator(FingerprintGenerator fingerPrintGenerator) {
        this.fingerPrintGenerator = fingerPrintGenerator;
        return this;
    }

    public ConfigBuilder uuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
        return this;
    }

    public ConfigBuilder sender(Sender sender) {
        this.sender = sender;
        return this;
    }

    public ConfigBuilder handleUncaughtErrors(boolean handleUncaughtErrors) {
        this.handleUncaughtErrors = handleUncaughtErrors;
        return this;
    }

    public Config build() {
        if (this.notifier == null) {
            this.notifier = new NotifierProvider();
        }
        if (this.sender == null) {
            this.sender = new SyncSender.Builder().accessToken(this.accessToken).build();
        }
        if (this.timestamp == null) {
            this.timestamp = new TimestampProvider();
        }
        return new ConfigImpl(this);
    }

    private static class ConfigImpl
    implements Config {
        private final String accessToken;
        private final String environment;
        private final String codeVersion;
        private final String platform;
        private final String language;
        private final String framework;
        private final Provider<String> context;
        private final Provider<Request> request;
        private final Provider<Person> person;
        private final Provider<Server> server;
        private final Provider<Client> client;
        private final Provider<Map<String, Object>> custom;
        private final Provider<Notifier> notifier;
        private final Provider<Long> timestamp;
        private final Filter filter;
        private final Transformer transformer;
        private final FingerprintGenerator fingerPrintGenerator;
        private final UuidGenerator uuidGenerator;
        private final Sender sender;
        private final boolean handleUncaughtErrors;

        ConfigImpl(ConfigBuilder builder) {
            this.accessToken = builder.accessToken;
            this.environment = builder.environment;
            this.codeVersion = builder.codeVersion;
            this.platform = builder.platform;
            this.language = builder.language;
            this.framework = builder.framework;
            this.context = builder.context;
            this.request = builder.request;
            this.person = builder.person;
            this.server = builder.server;
            this.client = builder.client;
            this.custom = builder.custom;
            this.notifier = builder.notifier;
            this.timestamp = builder.timestamp;
            this.filter = builder.filter;
            this.transformer = builder.transformer;
            this.fingerPrintGenerator = builder.fingerPrintGenerator;
            this.uuidGenerator = builder.uuidGenerator;
            this.sender = builder.sender;
            this.handleUncaughtErrors = builder.handleUncaughtErrors;
        }

        @Override
        public String accessToken() {
            return this.accessToken;
        }

        @Override
        public String environment() {
            return this.environment;
        }

        @Override
        public String codeVersion() {
            return this.codeVersion;
        }

        @Override
        public String platform() {
            return this.platform;
        }

        @Override
        public String language() {
            return this.language;
        }

        @Override
        public String framework() {
            return this.framework;
        }

        @Override
        public Provider<String> context() {
            return this.context;
        }

        @Override
        public Provider<Request> request() {
            return this.request;
        }

        @Override
        public Provider<Person> person() {
            return this.person;
        }

        @Override
        public Provider<Server> server() {
            return this.server;
        }

        @Override
        public Provider<Client> client() {
            return this.client;
        }

        @Override
        public Provider<Map<String, Object>> custom() {
            return this.custom;
        }

        @Override
        public Provider<Notifier> notifier() {
            return this.notifier;
        }

        @Override
        public Provider<Long> timestamp() {
            return this.timestamp;
        }

        @Override
        public Filter filter() {
            return this.filter;
        }

        @Override
        public Transformer transformer() {
            return this.transformer;
        }

        @Override
        public FingerprintGenerator fingerPrintGenerator() {
            return this.fingerPrintGenerator;
        }

        @Override
        public UuidGenerator uuidGenerator() {
            return this.uuidGenerator;
        }

        @Override
        public Sender sender() {
            return this.sender;
        }

        @Override
        public boolean handleUncaughtErrors() {
            return this.handleUncaughtErrors;
        }
    }
}

