/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.sender.queue;

import com.rollbar.api.payload.Payload;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class DiskQueue
extends AbstractQueue<Payload> {
    private static final int UNBOUNDED_QUEUE = 0;
    private static final String QUEUE_FOLDER = ".rollbar-queue";
    private static final String FILENAME_SUFFIX = "payload";
    private static final String FILENAME_NAME_FORMAT = "%s.%s";
    private final File queueFolder;
    private final int maxSize;

    private DiskQueue(Builder builder) {
        this.maxSize = builder.maxSize;
        this.queueFolder = builder.queueFolder;
        if (!this.queueFolder.exists() && !this.queueFolder.mkdirs()) {
            throw new RuntimeException("Could not create folder: " + this.queueFolder);
        }
        if (!this.queueFolder.canRead() || !this.queueFolder.canWrite()) {
            throw new RuntimeException("Not enough permissions folder: " + this.queueFolder);
        }
    }

    @Override
    public Iterator<Payload> iterator() {
        return new PayloadIterator(this.getFiles().iterator());
    }

    @Override
    public int size() {
        return this.getFiles().size();
    }

    @Override
    public boolean offer(Payload payload) {
        if (this.isFull()) {
            return false;
        }
        this.writeToFile(payload);
        return true;
    }

    @Override
    public Payload poll() {
        return this.readFromFile(true);
    }

    @Override
    public Payload peek() {
        return this.readFromFile(false);
    }

    private void writeToFile(Payload payload) {
        File file = new File(this.queueFolder.getAbsolutePath(), DiskQueue.createFilename(payload));
        try (FileOutputStream fileOut = new FileOutputStream(file);
             ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);){
            objectOut.writeObject(payload);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isFull() {
        if (this.maxSize <= 0) {
            return false;
        }
        return this.size() >= this.maxSize;
    }

    private Payload readFromFile(boolean removeFile) {
        File eventFile = this.getFiles().get(0);
        return DiskQueue.read(eventFile, removeFile);
    }

    private List<File> getFiles() {
        File[] files = this.queueFolder.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<File> payloads = new ArrayList<File>();
        for (File file : files) {
            if (!file.getName().endsWith(FILENAME_SUFFIX)) continue;
            payloads.add(file);
        }
        return payloads;
    }

    private static String createFilename(Payload payload) {
        String uuid = payload.getData() != null && payload.getData().getUuid() != null ? payload.getData().getUuid() : UUID.randomUUID().toString();
        return String.format(FILENAME_NAME_FORMAT, uuid, FILENAME_SUFFIX);
    }

    /*
     * Exception decompiling
     */
    private static Payload read(File file, boolean remove) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static final class PayloadIterator
    implements Iterator<Payload> {
        private final Iterator<File> it;

        public PayloadIterator(Iterator<File> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Payload next() {
            return DiskQueue.read(this.it.next(), false);
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    public static final class Builder {
        private File queueFolder;
        private int maxSize = 0;

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder queueFolder(File queueFolder) {
            this.queueFolder = queueFolder;
            return this;
        }

        public DiskQueue build() {
            if (this.queueFolder == null) {
                this.queueFolder = new File(DiskQueue.QUEUE_FOLDER);
            }
            return new DiskQueue(this);
        }
    }
}

