/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.util;

import com.rollbar.api.payload.data.body.Body;
import com.rollbar.api.payload.data.body.BodyContent;
import com.rollbar.api.payload.data.body.ExceptionInfo;
import com.rollbar.api.payload.data.body.Frame;
import com.rollbar.api.payload.data.body.Message;
import com.rollbar.api.payload.data.body.Trace;
import com.rollbar.api.payload.data.body.TraceChain;
import java.util.ArrayList;
import java.util.List;

public class BodyFactory {
    public Body from(Throwable throwable, String description) {
        Body.Builder builder = new Body.Builder();
        if (throwable == null) {
            return builder.bodyContent((BodyContent)BodyFactory.message(description)).build();
        }
        if (throwable.getCause() == null) {
            return builder.bodyContent((BodyContent)BodyFactory.trace(throwable, description)).build();
        }
        return builder.bodyContent((BodyContent)BodyFactory.traceChain(throwable, description)).build();
    }

    private static Message message(String description) {
        return new Message.Builder().body(description).build();
    }

    private static Trace trace(Throwable throwable, String description) {
        return new Trace.Builder().frames(BodyFactory.frames(throwable)).exception(BodyFactory.info(throwable, description)).build();
    }

    private static TraceChain traceChain(Throwable throwable, String description) {
        ArrayList<Trace> chain = new ArrayList<Trace>();
        do {
            chain.add(BodyFactory.trace(throwable, description));
            description = null;
        } while ((throwable = throwable.getCause()) != null);
        return new TraceChain.Builder().traces(chain).build();
    }

    private static List<Frame> frames(Throwable throwable) {
        StackTraceElement[] elements = throwable.getStackTrace();
        ArrayList<Frame> result = new ArrayList<Frame>();
        for (int i = elements.length - 1; i >= 0; --i) {
            result.add(BodyFactory.frame(elements[i]));
        }
        return result;
    }

    private static ExceptionInfo info(Throwable throwable, String description) {
        String className = throwable.getClass().getName();
        String message = throwable.getMessage();
        return new ExceptionInfo.Builder().className(className).message(message).description(description).build();
    }

    private static Frame frame(StackTraceElement element) {
        String filename = element.getFileName();
        Integer lineNumber = element.getLineNumber();
        String method = element.getMethodName();
        String className = element.getClassName();
        return new Frame.Builder().filename(filename).lineNumber(lineNumber).method(method).className(className).build();
    }
}

