/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier;

import com.rollbar.api.payload.Payload;
import com.rollbar.api.payload.data.Data;
import com.rollbar.api.payload.data.Level;
import com.rollbar.jvmti.ThrowableCache;
import com.rollbar.notifier.config.Config;
import com.rollbar.notifier.config.ConfigBuilder;
import com.rollbar.notifier.config.ConfigProvider;
import com.rollbar.notifier.uncaughtexception.RollbarUncaughtExceptionHandler;
import com.rollbar.notifier.util.BodyFactory;
import com.rollbar.notifier.util.ObjectsUtils;
import com.rollbar.notifier.wrapper.RollbarThrowableWrapper;
import com.rollbar.notifier.wrapper.ThrowableWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rollbar {
    private static Logger LOGGER = LoggerFactory.getLogger(Rollbar.class);
    private static volatile Rollbar notifier;
    private Config config;
    private final ReadWriteLock configReadWriteLock = new ReentrantReadWriteLock();
    private final Lock configReadLock = this.configReadWriteLock.readLock();
    private final Lock configWriteLock = this.configReadWriteLock.writeLock();
    private BodyFactory bodyFactory;

    public Rollbar(Config config) {
        this(config, new BodyFactory());
    }

    Rollbar(Config config, BodyFactory bodyFactory) {
        this.config = config;
        this.bodyFactory = bodyFactory;
        if (config.handleUncaughtErrors()) {
            this.handleUncaughtErrors();
        }
        this.processAppPackages(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Rollbar init(Config config) {
        if (notifier != null) return notifier;
        Class<Rollbar> clazz = Rollbar.class;
        synchronized (Rollbar.class) {
            if (notifier != null) return notifier;
            notifier = new Rollbar(config);
            LOGGER.debug("Rollbar managed notifier created.");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return notifier;
        }
    }

    public void handleUncaughtErrors() {
        this.handleUncaughtErrors(Thread.currentThread());
    }

    public void handleUncaughtErrors(Thread thread) {
        ObjectsUtils.requireNonNull(thread, "thread");
        LOGGER.debug("Handling uncaught errors for thread: {}.", (Object)thread);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        thread.setUncaughtExceptionHandler(new RollbarUncaughtExceptionHandler(this, uncaughtExceptionHandler));
    }

    public void configure(ConfigProvider configProvider) {
        ConfigBuilder builder;
        this.configReadLock.lock();
        try {
            builder = ConfigBuilder.withConfig(this.config);
        }
        finally {
            this.configReadLock.unlock();
        }
        Config newConfig = configProvider.provide(builder);
        this.configure(newConfig);
    }

    public void configure(Config config) {
        LOGGER.debug("Reloading configuration.");
        this.configWriteLock.lock();
        try {
            this.config = config;
            this.processAppPackages(config);
        }
        finally {
            this.configWriteLock.unlock();
        }
    }

    public Config config() {
        return this.config;
    }

    private void processAppPackages(Config config) {
        for (String appPackage : config.appPackages()) {
            ThrowableCache.addAppPackage(appPackage);
        }
    }

    public void critical(Throwable error) {
        this.critical(error, null, null);
    }

    public void critical(Throwable error, String description) {
        this.critical(error, null, description);
    }

    public void critical(Throwable error, Map<String, Object> custom) {
        this.critical(error, custom, null);
    }

    public void critical(String message) {
        this.critical(null, null, message);
    }

    public void critical(String message, Map<String, Object> custom) {
        this.critical(null, custom, message);
    }

    public void critical(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.CRITICAL);
    }

    public void error(Throwable error) {
        this.error(error, null, null);
    }

    public void error(Throwable error, String description) {
        this.error(error, null, description);
    }

    public void error(Throwable error, Map<String, Object> custom) {
        this.error(error, custom, null);
    }

    public void error(String message) {
        this.error(null, null, message);
    }

    public void error(String message, Map<String, Object> custom) {
        this.error(null, custom, message);
    }

    public void error(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.ERROR);
    }

    public void warning(Throwable error) {
        this.warning(error, null, null);
    }

    public void warning(Throwable error, String description) {
        this.warning(error, null, description);
    }

    public void warning(Throwable error, Map<String, Object> custom) {
        this.warning(error, custom, null);
    }

    public void warning(String message) {
        this.warning(null, null, message);
    }

    public void warning(String message, Map<String, Object> custom) {
        this.warning(null, custom, message);
    }

    public void warning(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.WARNING);
    }

    public void info(Throwable error) {
        this.info(error, null, null);
    }

    public void info(Throwable error, String description) {
        this.info(error, null, description);
    }

    public void info(Throwable error, Map<String, Object> custom) {
        this.info(error, custom, null);
    }

    public void info(String message) {
        this.info(null, null, message);
    }

    public void info(String message, Map<String, Object> custom) {
        this.info(null, custom, message);
    }

    public void info(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.INFO);
    }

    public void debug(Throwable error) {
        this.debug(error, null, null);
    }

    public void debug(Throwable error, String description) {
        this.debug(error, null, description);
    }

    public void debug(Throwable error, Map<String, Object> custom) {
        this.debug(error, custom, null);
    }

    public void debug(String message) {
        this.debug(null, null, message);
    }

    public void debug(String message, Map<String, Object> custom) {
        this.debug(null, custom, message);
    }

    public void debug(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.DEBUG);
    }

    public void log(Throwable error) {
        this.log(error, null, null, null);
    }

    public void log(Throwable error, String description) {
        this.log(error, null, description, null);
    }

    public void log(Throwable error, Map<String, Object> custom) {
        this.log(error, custom, null, null);
    }

    public void log(Throwable error, Map<String, Object> custom, Level level) {
        this.log(error, custom, null, level);
    }

    public void log(Throwable error, Level level) {
        this.log(error, null, null, level);
    }

    public void log(Throwable error, String description, Level level) {
        this.log(error, null, description, level);
    }

    public void log(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, null);
    }

    public void log(String message) {
        this.log(null, null, message, null);
    }

    public void log(String message, Map<String, Object> custom) {
        this.log(null, custom, message, null);
    }

    public void log(String message, Level level) {
        this.log(null, null, message, level);
    }

    public void log(String message, Map<String, Object> custom, Level level) {
        this.log(null, custom, message, level);
    }

    public void log(Throwable error, Map<String, Object> custom, String description, Level level) {
        this.log(error, custom, description, level, false);
    }

    public void log(Throwable error, Map<String, Object> custom, String description, Level level, boolean isUncaught) {
        RollbarThrowableWrapper rollbarThrowableWrapper = null;
        if (error != null) {
            rollbarThrowableWrapper = new RollbarThrowableWrapper(error);
        }
        this.log(rollbarThrowableWrapper, custom, description, level, isUncaught);
    }

    public void log(ThrowableWrapper error, Map<String, Object> custom, String description, Level level, boolean isUncaught) {
        try {
            this.process(error, custom, description, level, isUncaught);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing payload to send to Rollbar: {}", (Throwable)e);
        }
    }

    public Level level(Config config, Throwable error) {
        if (error == null) {
            return config.defaultMessageLevel();
        }
        if (error instanceof Error) {
            return config.defaultErrorLevel();
        }
        return config.defaultThrowableLevel();
    }

    public void close(boolean wait) throws Exception {
        this.config.sender().close(wait);
    }

    public void sendJsonPayload(String json) {
        try {
            this.configReadLock.lock();
            Config config = this.config;
            this.configReadLock.unlock();
            this.sendPayload(config, new Payload(json));
        }
        catch (Exception e) {
            LOGGER.error("Error while sending payload to Rollbar: {}", (Throwable)e);
        }
    }

    private void process(ThrowableWrapper error, Map<String, Object> custom, String description, Level level, boolean isUncaught) {
        this.configReadLock.lock();
        Config config = this.config;
        this.configReadLock.unlock();
        if (!config.isEnabled()) {
            LOGGER.debug("Notifier disabled.");
            return;
        }
        if (config.filter() != null && config.filter().preProcess(level, error != null ? error.getThrowable() : null, custom, description)) {
            LOGGER.debug("Pre-filtered error: {}", (Object)error);
            return;
        }
        LOGGER.debug("Gathering information to build the payload.");
        Data data = this.buildData(config, error, custom, description, level, isUncaught);
        if (config.transformer() != null) {
            LOGGER.debug("Transforming the data.");
            data = config.transformer().transform(data);
        }
        if (config.uuidGenerator() != null || config.fingerPrintGenerator() != null) {
            Data.Builder dataBuilder = new Data.Builder(data);
            if (config.uuidGenerator() != null) {
                LOGGER.debug("Generating UUID.");
                dataBuilder.uuid(config.uuidGenerator().from(data));
            }
            if (config.fingerPrintGenerator() != null) {
                LOGGER.debug("Generating fingerprint.");
                dataBuilder.fingerprint(config.fingerPrintGenerator().from(data));
            }
            data = dataBuilder.build();
        }
        if (config.filter() != null && config.filter().postProcess(data)) {
            LOGGER.debug("Post-filtered error: {}", (Object)error);
            return;
        }
        Payload payload = new Payload.Builder().accessToken(config.accessToken()).data(data).build();
        LOGGER.debug("Payload built: {}", (Object)payload);
        this.sendPayload(config, payload);
    }

    private Data buildData(Config config, ThrowableWrapper error, Map<String, Object> custom, String description, Level level, boolean isUncaught) {
        Data.Builder dataBuilder = new Data.Builder().environment(config.environment()).codeVersion(config.codeVersion()).platform(config.platform()).language(config.language()).framework(config.framework()).level(level != null ? level : (error != null ? this.level(config, error.getThrowable()) : this.level(config, null))).body(this.bodyFactory.from(error, description)).isUncaught(isUncaught);
        if (config.context() != null) {
            LOGGER.debug("Gathering context info.");
            dataBuilder.context(config.context().provide());
        }
        if (config.request() != null) {
            LOGGER.debug("Gathering request info.");
            dataBuilder.request(config.request().provide());
        }
        if (config.person() != null) {
            LOGGER.debug("Gathering person info.");
            dataBuilder.person(config.person().provide());
        }
        if (config.server() != null) {
            LOGGER.debug("Gathering server info.");
            dataBuilder.server(config.server().provide());
        }
        if (config.client() != null) {
            LOGGER.debug("Gathering client info.");
            dataBuilder.client(config.client().provide());
        }
        HashMap<String, Object> tmpCustom = new HashMap<String, Object>();
        if (config.custom() != null) {
            LOGGER.debug("Gathering custom info.");
            Map<String, Object> customProvided = config.custom().provide();
            if (customProvided != null) {
                tmpCustom.putAll(customProvided);
            }
        }
        if (custom != null) {
            tmpCustom.putAll(custom);
        }
        if (tmpCustom.size() > 0) {
            dataBuilder.custom(tmpCustom);
        }
        if (config.notifier() != null) {
            LOGGER.debug("Gathering notifier info.");
            dataBuilder.notifier(config.notifier().provide());
        }
        if (config.timestamp() != null) {
            LOGGER.debug("Gathering timestamp info.");
            dataBuilder.timestamp(config.timestamp().provide());
        }
        return dataBuilder.build();
    }

    private void sendPayload(Config config, Payload payload) {
        if (config.sender() != null) {
            LOGGER.debug("Sending payload.");
            config.sender().send(payload);
        }
    }
}

