/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.config;

import com.rollbar.notifier.config.ConfigProvider;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProviderHelper {
    private static final Logger thisLogger = LoggerFactory.getLogger((String)"ConfigProviderHelper");

    public static ConfigProvider getConfigProvider(String configProviderClassName) {
        ConfigProvider configProvider = null;
        if (configProviderClassName != null && !"".equals(configProviderClassName)) {
            Class<?> userConfigProviderClass = null;
            try {
                userConfigProviderClass = Class.forName(configProviderClassName);
            }
            catch (Exception e) {
                thisLogger.error("Could not get the config provider class: {}.", (Object)configProviderClassName, (Object)e.getMessage());
            }
            if (userConfigProviderClass != null) {
                try {
                    Constructor<?> constructor = userConfigProviderClass.getConstructor(new Class[0]);
                    configProvider = (ConfigProvider)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    thisLogger.error("Could not create the config provider.", (Throwable)e);
                }
            }
        }
        return configProvider;
    }
}

