/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.log4j2;

import com.rollbar.notifier.Rollbar;
import com.rollbar.notifier.config.Config;
import com.rollbar.notifier.config.ConfigBuilder;
import com.rollbar.notifier.config.ConfigProvider;
import com.rollbar.notifier.config.ConfigProviderHelper;
import com.rollbar.notifier.provider.Provider;
import com.rollbar.notifier.provider.server.ServerProvider;
import com.rollbar.notifier.wrapper.RollbarThrowableWrapper;
import com.rollbar.notifier.wrapper.ThrowableWrapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="Rollbar", category="Core", elementType="appender", printObject=true)
public class RollbarAppender
extends AbstractAppender {
    private static final String PACKAGE_NAME = "com.rollbar";
    private static final String CUSTOM_NAMESPACE_KEY = "rollbar-log4j2";
    private static final String CUSTOM_LOGGER_NAME_KEY = "loggerName";
    private static final String CUSTOM_MDC_NAME_KEY = "mdc";
    private static final String CUSTOM_NDC_NAME_KEY = "ndc";
    private static final String CUSTOM_MAKER_NAME_KEY = "marker";
    private static final String CUSTOM_THREAD_NAME_KEY = "threadName";
    private Rollbar rollbar;

    protected RollbarAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Rollbar rollbar) {
        super(name, filter, layout, ignoreExceptions);
        this.rollbar = rollbar;
    }

    @PluginFactory
    public static RollbarAppender createAppender(@PluginAttribute(value="accessToken") @Required String accessToken, @PluginAttribute(value="endpoint") String endpoint, @PluginAttribute(value="environment") String environment, @PluginAttribute(value="language") String language, @PluginAttribute(value="configProviderClassName") String configProviderClassName, @PluginAttribute(value="name") @Required String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") String ignore) {
        ConfigProvider configProvider = ConfigProviderHelper.getConfigProvider((String)configProviderClassName);
        ConfigBuilder configBuilder = ConfigBuilder.withAccessToken((String)accessToken).environment(environment).endpoint(endpoint).server((Provider)new ServerProvider()).language(language);
        Config config = configProvider != null ? configProvider.provide(configBuilder) : configBuilder.build();
        Rollbar rollbar = new Rollbar(config);
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        return new RollbarAppender(name, filter, layout, ignoreExceptions, rollbar);
    }

    public void append(LogEvent event) {
        if (event.getLoggerName() != null && event.getLoggerName().startsWith(PACKAGE_NAME)) {
            LOGGER.warn("Recursive logging from [{}] for appender [{}].", (Object)event.getLoggerName(), (Object)this.getName());
            return;
        }
        ThrowableProxy throwableProxy = event.getThrownProxy();
        ThrowableWrapper rollbarThrowableWrapper = this.buildRollbarThrowableWrapper(throwableProxy);
        Map<String, Object> custom = this.buildCustom(event);
        String message = event.getMessage() != null ? event.getMessage().getFormattedMessage() : null;
        com.rollbar.api.payload.data.Level level = this.getLevel(event);
        this.rollbar.log(rollbarThrowableWrapper, custom, message, level, false);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        super.stop(timeout, timeUnit);
        try {
            this.rollbar.close(true);
        }
        catch (Exception e) {
            LOGGER.error("Closing rollbar", (Throwable)e);
        }
        return true;
    }

    public void stop() {
        this.stop(0L, TimeUnit.MILLISECONDS);
    }

    private ThrowableWrapper buildRollbarThrowableWrapper(ThrowableProxy throwableProxy) {
        if (throwableProxy == null) {
            return null;
        }
        if (throwableProxy.getThrowable() != null) {
            return new RollbarThrowableWrapper(throwableProxy.getThrowable());
        }
        String className = throwableProxy.getName();
        String message = throwableProxy.getMessage();
        ThrowableWrapper causeThrowableWrapper = this.buildRollbarThrowableWrapper(throwableProxy.getCauseProxy());
        StackTraceElement[] stackTraceElements = this.buildStackTraceElements(throwableProxy.getStackTrace());
        return new RollbarThrowableWrapper(className, message, stackTraceElements, causeThrowableWrapper);
    }

    private StackTraceElement[] buildStackTraceElements(StackTraceElement[] stackTraceElements) {
        StackTraceElement[] elements = new StackTraceElement[stackTraceElements.length];
        for (int i = 0; i < stackTraceElements.length; ++i) {
            elements[i] = stackTraceElements[i];
        }
        return elements;
    }

    private com.rollbar.api.payload.data.Level getLevel(LogEvent event) {
        Level level = event.getLevel();
        com.rollbar.api.payload.data.Level rollbarLevel = com.rollbar.api.payload.data.Level.lookupByName((String)level.name());
        if (rollbarLevel != null) {
            return rollbarLevel;
        }
        if (Level.FATAL.equals((Object)level)) {
            return com.rollbar.api.payload.data.Level.CRITICAL;
        }
        return null;
    }

    private Map<String, Object> buildCustom(LogEvent event) {
        HashMap<String, Object> custom = new HashMap<String, Object>();
        custom.put(CUSTOM_LOGGER_NAME_KEY, event.getLoggerName());
        custom.put(CUSTOM_THREAD_NAME_KEY, event.getThreadName());
        custom.put(CUSTOM_MDC_NAME_KEY, this.buildMdc(event));
        custom.put(CUSTOM_NDC_NAME_KEY, this.getNdc(event));
        custom.put(CUSTOM_MAKER_NAME_KEY, this.getMarker(event));
        HashMap<String, Object> rootCustom = new HashMap<String, Object>();
        rootCustom.put(CUSTOM_NAMESPACE_KEY, custom);
        return rootCustom;
    }

    private Map<String, Object> buildMdc(LogEvent event) {
        if (event.getContextData() == null || event.getContextData().size() == 0) {
            return null;
        }
        HashMap<String, Object> mdc = new HashMap<String, Object>();
        for (Map.Entry mdcEntry : event.getContextData().toMap().entrySet()) {
            mdc.put((String)mdcEntry.getKey(), mdcEntry.getValue());
        }
        return mdc;
    }

    private List<String> getNdc(LogEvent event) {
        if (event.getContextStack() == null || event.getContextStack().size() == 0) {
            return null;
        }
        return event.getContextStack().asList();
    }

    private String getMarker(LogEvent event) {
        if (event.getMarker() == null) {
            return null;
        }
        return event.getMarker().getName();
    }
}

