/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.AppenderBase;
import com.rollbar.api.payload.data.Level;
import com.rollbar.notifier.Rollbar;
import com.rollbar.notifier.config.ConfigBuilder;
import com.rollbar.notifier.wrapper.RollbarThrowableWrapper;
import com.rollbar.notifier.wrapper.ThrowableWrapper;
import java.util.HashMap;
import java.util.Map;

public class RollbarAppender
extends AppenderBase<ILoggingEvent> {
    private static final String PACKAGE_NAME = "com.rollbar";
    private static final String CUSTOM_NAMESPACE_KEY = "rollbar-logback";
    private static final String CUSTOM_LOGGER_NAME_KEY = "loggerName";
    private static final String CUSTOM_MDC_NAME_KEY = "mdc";
    private static final String CUSTOM_MAKER_NAME_KEY = "marker";
    private static final String CUSTOM_THREAD_NAME_KEY = "threadName";
    private Rollbar rollbar;
    private String accessToken;

    protected RollbarAppender(Rollbar rollbar) {
        this.rollbar = rollbar;
    }

    public void start() {
        this.rollbar = new Rollbar(ConfigBuilder.withAccessToken((String)this.accessToken).build());
        super.start();
    }

    protected void append(ILoggingEvent event) {
        if (event.getLoggerName() != null && event.getLoggerName().startsWith(PACKAGE_NAME)) {
            this.addWarn("Recursive logging");
            return;
        }
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        ThrowableWrapper rollbarThrowableWrapper = this.buildRollbarThrowableWrapper(throwableProxy);
        Map<String, Object> custom = this.buildCustom(event);
        this.rollbar.log(rollbarThrowableWrapper, custom, event.getFormattedMessage(), Level.lookupByName((String)event.getLevel().levelStr), false);
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    private ThrowableWrapper buildRollbarThrowableWrapper(IThrowableProxy throwableProxy) {
        if (throwableProxy == null) {
            return null;
        }
        String className = throwableProxy.getClassName();
        String message = throwableProxy.getMessage();
        ThrowableWrapper causeThrowableWrapper = this.buildRollbarThrowableWrapper(throwableProxy.getCause());
        StackTraceElement[] stackTraceElements = this.buildStackTraceElements(throwableProxy.getStackTraceElementProxyArray());
        return new RollbarThrowableWrapper(className, message, stackTraceElements, causeThrowableWrapper);
    }

    private StackTraceElement[] buildStackTraceElements(StackTraceElementProxy[] stackTraceElements) {
        StackTraceElement[] elements = new StackTraceElement[stackTraceElements.length];
        for (int i = 0; i < stackTraceElements.length; ++i) {
            elements[i] = stackTraceElements[i].getStackTraceElement();
        }
        return elements;
    }

    private Map<String, Object> buildCustom(ILoggingEvent event) {
        HashMap<String, Object> custom = new HashMap<String, Object>();
        custom.put(CUSTOM_LOGGER_NAME_KEY, event.getLoggerName());
        custom.put(CUSTOM_THREAD_NAME_KEY, event.getThreadName());
        custom.put(CUSTOM_MDC_NAME_KEY, this.buildMdc(event));
        custom.put(CUSTOM_MAKER_NAME_KEY, this.getMarker(event));
        HashMap<String, Object> rootCustom = new HashMap<String, Object>();
        rootCustom.put(CUSTOM_NAMESPACE_KEY, custom);
        return rootCustom;
    }

    private Map<String, Object> buildMdc(ILoggingEvent event) {
        if (event.getMDCPropertyMap() == null || event.getMDCPropertyMap().size() == 0) {
            return null;
        }
        HashMap<String, Object> custom = new HashMap<String, Object>();
        for (Map.Entry mdcEntry : event.getMDCPropertyMap().entrySet()) {
            custom.put((String)mdcEntry.getKey(), mdcEntry.getValue());
        }
        return custom;
    }

    private String getMarker(ILoggingEvent event) {
        if (event.getMarker() == null) {
            return null;
        }
        return event.getMarker().getName();
    }
}

