/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.sender;

import com.rollbar.payload.Payload;
import com.rollbar.sender.ConnectionFailedException;
import com.rollbar.sender.InvalidResponseCodeException;
import com.rollbar.sender.RollbarResponse;
import com.rollbar.sender.RollbarResponseCode;
import com.rollbar.sender.RollbarResponseHandler;
import com.rollbar.sender.Sender;
import com.rollbar.utilities.ArgumentNullException;
import com.rollbar.utilities.Validate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PayloadSender
implements Sender {
    public static final String DEFAULT_API_ENDPOINT = "https://api.rollbar.com/api/1/item/";
    private final URL url;
    private static final Pattern messagePattern = Pattern.compile("\"message\"\\s*:\\s*\"([^\"]*)\"");
    private static final Pattern uuidPattern = Pattern.compile("\"uuid\"\\s*:\\s*\"([^\"]*)\"");

    public PayloadSender() {
        try {
            this.url = new URL(DEFAULT_API_ENDPOINT);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("The DEFAULT_API_ENDPOINT is valid. This should never get hit.");
        }
    }

    public PayloadSender(String url) throws ArgumentNullException, MalformedURLException {
        Validate.isNotNull((Object)url, (String)"url");
        this.url = new URL(url);
    }

    public RollbarResponse send(Payload payload) {
        byte[] bytes;
        HttpURLConnection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (ConnectionFailedException e) {
            return RollbarResponse.failure(RollbarResponseCode.ConnectionFailed, e.getMessage());
        }
        try {
            bytes = payload.toJson().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Rollbar Requires UTF8 Encoding and your JVM does not support UTF8, please update your JVM");
        }
        try {
            this.sendJson(connection, bytes);
        }
        catch (ConnectionFailedException e) {
            return RollbarResponse.failure(RollbarResponseCode.ConnectionFailed, e.getMessage());
        }
        try {
            return this.readResponse(connection);
        }
        catch (ConnectionFailedException e) {
            return RollbarResponse.failure(RollbarResponseCode.ConnectionFailed, e.getMessage());
        }
    }

    public void send(Payload payload, RollbarResponseHandler handler) {
        RollbarResponse response = this.send(payload);
        if (handler != null) {
            handler.handleResponse(response);
        }
    }

    private RollbarResponse readResponse(HttpURLConnection connection) throws ConnectionFailedException {
        RollbarResponseCode code;
        String content;
        int result;
        try {
            result = connection.getResponseCode();
            content = PayloadSender.GetResponseContent(connection);
        }
        catch (IOException e) {
            throw new ConnectionFailedException(connection.getURL(), "Reading the Response Failed", e);
        }
        try {
            code = RollbarResponseCode.fromInt(result);
        }
        catch (InvalidResponseCodeException e) {
            throw new ConnectionFailedException(connection.getURL(), "Unknown Response Code Received", e);
        }
        boolean err = result >= 400;
        Pattern p = err ? messagePattern : uuidPattern;
        Matcher m = p.matcher(content);
        m.find();
        if (err) {
            return code.response(m.group(1));
        }
        return RollbarResponse.success(m.group(1));
    }

    private static String GetResponseContent(HttpURLConnection connection) throws IOException {
        String line;
        InputStream inputStream = connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream();
        InputStreamReader reader = new InputStreamReader(inputStream, "utf-8");
        BufferedReader bis = new BufferedReader(reader);
        StringBuilder buffer = new StringBuilder();
        while ((line = bis.readLine()) != null) {
            buffer.append(line).append("\n");
        }
        bis.close();
        return buffer.toString();
    }

    private HttpURLConnection getConnection() throws ConnectionFailedException {
        HttpURLConnection connection = this.getHttpURLConnection();
        this.setMethodToPOST(connection);
        this.setJsonSendAndReceive(connection);
        return connection;
    }

    private void sendJson(HttpURLConnection connection, byte[] bytes) throws ConnectionFailedException {
        OutputStream out;
        try {
            out = connection.getOutputStream();
        }
        catch (IOException e) {
            throw new ConnectionFailedException(this.url, "OpeningBodyWriter", e);
        }
        try {
            out.write(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new ConnectionFailedException(this.url, "WritingToBody", e);
        }
        try {
            out.close();
        }
        catch (IOException e) {
            throw new ConnectionFailedException(this.url, "Closing Body Writer", e);
        }
    }

    private void setJsonSendAndReceive(HttpURLConnection connection) {
        connection.setRequestProperty("Accept-Charset", "utf-8");
        connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        connection.setRequestProperty("Accept", "application/json");
    }

    private void setMethodToPOST(HttpURLConnection connection) throws ConnectionFailedException {
        try {
            connection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new ConnectionFailedException(this.url, "Setting method to POST Failed", e);
        }
        connection.setDoOutput(true);
    }

    private HttpURLConnection getHttpURLConnection() throws ConnectionFailedException {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
        }
        catch (IOException e) {
            throw new ConnectionFailedException(this.url, "Initializing URL Connection", e);
        }
        return connection;
    }
}

