/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.sender;

import com.rollbar.sender.RollbarResponseCode;

public class RollbarResponse {
    private final RollbarResponseCode statusCode;
    private final String result;

    public static RollbarResponse success(String uuid) {
        return new RollbarResponse(RollbarResponseCode.Success, uuid);
    }

    public static RollbarResponse failure(RollbarResponseCode code, String reason) {
        return new RollbarResponse(code, reason);
    }

    public static RollbarResponse notSent() {
        return new RollbarResponse(RollbarResponseCode.Filtered, "Payload not sent, because it was filtered.");
    }

    private RollbarResponse(RollbarResponseCode statusCode, String result) {
        this.statusCode = statusCode;
        this.result = result;
    }

    public RollbarResponseCode statusCode() {
        return this.statusCode;
    }

    public String uuid() {
        if (this.isSuccessful()) {
            return this.result;
        }
        return null;
    }

    public String instanceUrl() {
        String urlFormat = "https://rollbar.com/instance/uuid/?uuid=%s";
        if (this.isSuccessful()) {
            return String.format("https://rollbar.com/instance/uuid/?uuid=%s", this.uuid());
        }
        return null;
    }

    public String errorMessage() {
        if (!this.isSuccessful()) {
            return this.result;
        }
        return null;
    }

    public boolean isSuccessful() {
        return this.statusCode == RollbarResponseCode.Success;
    }
}

