/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.sender;

import com.rollbar.sender.InvalidResponseCodeException;
import com.rollbar.sender.RollbarResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RollbarResponseCode {
    Success(200),
    BadRequest(400),
    Unauthorized(401),
    AccessDenied(403),
    RequestTooLarge(413),
    UnprocessablePayload(422),
    TooManyRequests(429),
    InternalServerError(500),
    Filtered(-1),
    ConnectionFailed(-2);

    private final int value;

    private RollbarResponseCode(int value) {
        this.value = value;
    }

    public RollbarResponse response(String message) {
        return RollbarResponse.failure(this, message);
    }

    public static RollbarResponseCode fromInt(int i) throws InvalidResponseCodeException {
        for (RollbarResponseCode rrc : RollbarResponseCode.values()) {
            if (rrc.value != i) continue;
            return rrc;
        }
        throw new InvalidResponseCodeException(i);
    }
}

